/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common;

import com.google.common.io.ByteStreams;
import com.metamx.common.guava.CloseQuietly;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeoutException;

public class StreamUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToFileAndClose(InputStream is, File file) throws IOException {
        file.getParentFile().mkdirs();
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            CloseQuietly.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToFileAndClose(InputStream is, File file, long timeout) throws IOException, TimeoutException {
        file.getParentFile().mkdirs();
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            StreamUtils.copyWithTimeout(is, os, timeout);
        }
        finally {
            CloseQuietly.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndClose(InputStream is, OutputStream os) throws IOException {
        try {
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            CloseQuietly.close(is);
            CloseQuietly.close(os);
        }
    }

    public static void copyWithTimeout(InputStream is, OutputStream os, long timeout) throws IOException, TimeoutException {
        byte[] buffer = new byte[4096];
        int n = 0;
        long startTime = System.currentTimeMillis();
        while (-1 != (n = is.read(buffer))) {
            if (System.currentTimeMillis() - startTime > timeout) {
                throw new TimeoutException(String.format("Copy time has exceeded %,d millis", timeout));
            }
            os.write(buffer, 0, n);
        }
    }
}

