/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.metamx.common.logger.Logger;
import java.util.Random;
import java.util.concurrent.Callable;

public class RetryUtils {
    public static final Logger log = new Logger(RetryUtils.class);

    public static <T> T retry(Callable<T> f, Predicate<Throwable> shouldRetry, int maxTries) throws Exception {
        Preconditions.checkArgument((maxTries > 0 ? 1 : 0) != 0, (Object)"maxTries > 0");
        int nTry = 0;
        while (true) {
            try {
                ++nTry;
                return f.call();
            }
            catch (Throwable e) {
                if (nTry < maxTries && shouldRetry.apply((Object)e)) {
                    RetryUtils.awaitNextRetry(e, nTry);
                    continue;
                }
                Throwables.propagateIfInstanceOf((Throwable)e, Exception.class);
                throw Throwables.propagate((Throwable)e);
            }
            break;
        }
    }

    private static void awaitNextRetry(Throwable e, int nTry) throws InterruptedException {
        long baseSleepMillis = 1000L;
        long maxSleepMillis = 60000L;
        double fuzzyMultiplier = Math.min(Math.max(1.0 + 0.2 * new Random().nextGaussian(), 0.0), 2.0);
        long sleepMillis = (long)(Math.min(60000.0, 1000.0 * Math.pow(2.0, nTry)) * fuzzyMultiplier);
        log.warn(e, "Failed on try %d, retrying in %,dms.", nTry, sleepMillis);
        Thread.sleep(sleepMillis);
    }
}

