/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common;

import com.google.common.base.Throwables;
import com.metamx.common.UOE;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import sun.nio.ch.FileChannelImpl;

public class ByteBufferUtils {
    private static final Method unmap;

    public static void unmap(MappedByteBuffer buffer) {
        try {
            unmap.invoke(null, buffer);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        try {
            Method unmapMethod = FileChannelImpl.class.getDeclaredMethod("unmap", MappedByteBuffer.class);
            unmapMethod.setAccessible(true);
            unmap = unmapMethod;
        }
        catch (Exception e) {
            throw new UOE(e, "Exception thrown while trying to find unmap method on MappedByteBuffer, this method must exist in your VM in order for this to work", new Object[0]);
        }
    }
}

