/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.comms;

import com.ircclouds.irc.api.comms.IConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class SocketChannelConnection
implements IConnection {
    private SocketChannel channel;
    private ByteBuffer buffer = ByteBuffer.allocate(2048);

    @Override
    public int write(String aMessage) throws IOException {
        return this.channel.write(ByteBuffer.wrap(aMessage.getBytes()));
    }

    @Override
    public boolean open(String aHostname, int aPort) throws IOException {
        if (this.channel == null || !this.channel.isConnected()) {
            this.channel = SocketChannel.open();
            return this.channel.connect(new InetSocketAddress(aHostname, aPort));
        }
        throw new RuntimeException("Socket is already open.");
    }

    @Override
    public String read() throws IOException {
        this.buffer.clear();
        this.channel.read(this.buffer);
        this.buffer.flip();
        byte[] _bytes = new byte[this.buffer.limit()];
        this.buffer.get(_bytes);
        return new String(_bytes);
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
    }
}

