/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.commands;

import com.ircclouds.irc.api.IServerParameters;
import com.ircclouds.irc.api.commands.ICommand;
import com.ircclouds.irc.api.utils.StringUtils;

public class ConnectCmd
implements ICommand {
    private static final String COLUMN = ":";
    private static final String SPACE = " ";
    private static final String CRNL = "\r\n";
    private static final String NICK = "NICK";
    private static final String USER = "USER";
    private static final String PASSWORD = "PASS";
    private String nick;
    private String ident;
    private String realname;
    private String password;

    public ConnectCmd(IServerParameters aServerParameters) {
        this.nick = aServerParameters.getNickname();
        this.ident = aServerParameters.getIdent();
        this.realname = aServerParameters.getRealname();
        this.password = aServerParameters.getServer().getPassword();
    }

    @Override
    public String asString() {
        return new StringBuffer().append(USER).append(SPACE).append(this.ident).append(SPACE).append("0").append(SPACE).append("*").append(SPACE).append(COLUMN).append(this.realname).append(CRNL).append(NICK).append(SPACE).append(this.nick).append(CRNL).append(this.getPassword()).toString();
    }

    private String getPassword() {
        if (!StringUtils.isEmpty(this.password)) {
            return "PASS " + this.password + CRNL;
        }
        return "";
    }
}

