/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api;

import com.ircclouds.irc.api.AbstractIRCSession;
import com.ircclouds.irc.api.ApiException;
import com.ircclouds.irc.api.Callback;
import com.ircclouds.irc.api.DCCManager;
import com.ircclouds.irc.api.DCCManagerImpl;
import com.ircclouds.irc.api.ICommandServer;
import com.ircclouds.irc.api.IIRCSession;
import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.IServerParameters;
import com.ircclouds.irc.api.commands.ChangeModeCmd;
import com.ircclouds.irc.api.commands.ChangeNickCmd;
import com.ircclouds.irc.api.commands.ChangeTopicCmd;
import com.ircclouds.irc.api.commands.ConnectCmd;
import com.ircclouds.irc.api.commands.ICommand;
import com.ircclouds.irc.api.commands.JoinChanCmd;
import com.ircclouds.irc.api.commands.KickUserCmd;
import com.ircclouds.irc.api.commands.PartChanCmd;
import com.ircclouds.irc.api.commands.QuitCmd;
import com.ircclouds.irc.api.commands.SendActionMessage;
import com.ircclouds.irc.api.commands.SendNoticeMessage;
import com.ircclouds.irc.api.commands.SendPrivateMessage;
import com.ircclouds.irc.api.commands.SendRawMessage;
import com.ircclouds.irc.api.ctcp.DCCReceiveCallback;
import com.ircclouds.irc.api.ctcp.DCCSendCallback;
import com.ircclouds.irc.api.domain.IRCChannel;
import com.ircclouds.irc.api.domain.IRCServerOptions;
import com.ircclouds.irc.api.filters.AbstractAndMessageFilter;
import com.ircclouds.irc.api.filters.ApiMessageFilter;
import com.ircclouds.irc.api.filters.IMessageFilter;
import com.ircclouds.irc.api.listeners.AbstractExecuteCommandListener;
import com.ircclouds.irc.api.listeners.ExecuteCommandListenerImpl;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.listeners.MESSAGE_VISIBILITY;
import com.ircclouds.irc.api.listeners.PingVersionListenerImpl;
import com.ircclouds.irc.api.state.AbstractIRCStateUpdater;
import com.ircclouds.irc.api.state.DisconnectedIRCState;
import com.ircclouds.irc.api.state.IIRCState;
import com.ircclouds.irc.api.state.IRCStateImpl;
import com.ircclouds.irc.api.state.IStateAccessor;
import com.ircclouds.irc.api.utils.NetUtils;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRCApiImpl
implements IRCApi {
    private static final Logger LOG = LoggerFactory.getLogger(IRCApiImpl.class);
    private IIRCSession session;
    private AbstractExecuteCommandListener executeCmdListener;
    private IIRCState state;
    private int asyncId = 0;
    private IMessageFilter filter;
    private ApiMessageFilter apiFilter = new ApiMessageFilter(this.asyncId);
    private IMessageFilter abstractAndMsgFilter = new AbstractAndMessageFilter(this.apiFilter){

        @Override
        protected IMessageFilter getSecondFilter() {
            return IRCApiImpl.this.filter;
        }
    };
    private DCCManagerImpl dccManager;

    public IRCApiImpl(Boolean aSaveIRCState) {
        this.state = new DisconnectedIRCState();
        this.session = new AbstractIRCSession(){

            @Override
            protected IRCServerOptions getIRCServerOptions() {
                return IRCApiImpl.this.state.getServerOptions();
            }

            @Override
            public IMessageFilter getMessageFilter() {
                if (IRCApiImpl.this.filter != null) {
                    return IRCApiImpl.this.abstractAndMsgFilter;
                }
                return IRCApiImpl.this.apiFilter;
            }
        };
        IMessageListener[] iMessageListenerArray = new IMessageListener[2];
        this.executeCmdListener = new ExecuteCommandListenerImpl(this.session, this.getStateUpdater(aSaveIRCState));
        iMessageListenerArray[0] = this.executeCmdListener;
        iMessageListenerArray[1] = new PingVersionListenerImpl(this.session);
        this.session.addListeners(MESSAGE_VISIBILITY.PRIVATE, iMessageListenerArray);
        this.dccManager = new DCCManagerImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(IServerParameters aServerParameters, Callback<IIRCState> aCallback) {
        if (this.state.isConnected()) {
            aCallback.onFailure(new ApiException("Already connected!"));
            return;
        }
        Dirty _d = new Dirty();
        this.executeCmdListener.submitConnectCallback(this.newConnectCallback(aCallback, _d), aServerParameters);
        boolean _isOpen = false;
        try {
            _isOpen = this.session.open(aServerParameters.getServer());
            if (_isOpen) {
                this.executeAsync(new ConnectCmd(aServerParameters), aCallback, _d);
            } else {
                aCallback.onFailure(new ApiException("Failed to open connection to [" + aServerParameters.getServer().toString() + "]"));
            }
        }
        catch (IOException aExc) {
            LOG.error("Error opening session", (Throwable)aExc);
            aCallback.onFailure(aExc);
        }
        finally {
            if (!_isOpen) {
                this.closeSession(aCallback);
            }
        }
    }

    @Override
    public void disconnect(String aQuitMessage) {
        this.checkConnected();
        this.execute(new QuitCmd(aQuitMessage));
        ((IRCStateImpl)this.state).setConnected(false);
    }

    @Override
    public void joinChannel(String aChannelName) {
        this.joinChannel(aChannelName, "");
    }

    @Override
    public void joinChannel(String aChannelName, Callback<IRCChannel> aCallback) {
        this.joinChannel(aChannelName, "", aCallback);
    }

    @Override
    public void joinChannel(String aChannelName, String aKey) {
        this.checkConnected();
        this.execute(new JoinChanCmd(this.prependChanType(aChannelName), aKey));
    }

    @Override
    public void joinChannel(String aChannelName, String aKey, Callback<IRCChannel> aCallback) {
        if (!this.state.isConnected()) {
            aCallback.onFailure(new ApiException("Not connected!"));
            return;
        }
        aChannelName = this.prependChanType(aChannelName);
        Dirty _d = new Dirty();
        this.executeCmdListener.submitJoinChannelCallback(aChannelName, this.getDirtyCallback(aCallback, _d));
        this.executeAsync(new JoinChanCmd(aChannelName, aKey), aCallback, _d);
    }

    @Override
    public void leaveChannel(String aChannelName) {
        this.leaveChannel(aChannelName, "");
    }

    @Override
    public void leaveChannel(String aChannelName, Callback<String> aCallback) {
        this.leaveChannel(aChannelName, "", aCallback);
    }

    @Override
    public void leaveChannel(String aChannelName, String aPartMessage) {
        this.checkConnected();
        this.execute(new PartChanCmd(aChannelName, aPartMessage));
    }

    @Override
    public void leaveChannel(String aChannelName, String aPartMessage, Callback<String> aCallback) {
        if (!this.state.isConnected()) {
            aCallback.onFailure(new ApiException("Not connected!"));
            return;
        }
        Dirty _d = new Dirty();
        this.executeCmdListener.submitPartChannelCallback(aChannelName, this.getDirtyCallback(aCallback, _d));
        this.executeAsync(new PartChanCmd(aChannelName, aPartMessage), aCallback, _d);
    }

    @Override
    public void message(String aTarget, String aMessage) {
        this.checkConnected();
        this.execute(new SendPrivateMessage(aTarget, aMessage));
    }

    @Override
    public void message(String aTarget, String aMessage, Callback<String> aCallback) {
        if (!this.state.isConnected()) {
            aCallback.onFailure(new ApiException("Not connected!"));
            return;
        }
        Dirty _d = new Dirty();
        this.executeCmdListener.submitSendMessageCallback(this.asyncId, this.getDirtyCallback(aCallback, _d));
        this.apiFilter.addValue(this.asyncId);
        this.executeAsync(new SendPrivateMessage(aTarget, aMessage, this.asyncId++), aCallback, _d);
    }

    @Override
    public void act(String aTarget, String aActionMessage) {
        this.checkConnected();
        this.execute(new SendActionMessage(aTarget, aActionMessage));
    }

    @Override
    public void act(String aTarget, String aActionMessage, Callback<String> aCallback) {
        if (!this.state.isConnected()) {
            aCallback.onFailure(new ApiException("Not connected!"));
            return;
        }
        Dirty _d = new Dirty();
        this.executeCmdListener.submitSendMessageCallback(this.asyncId, this.getDirtyCallback(aCallback, _d));
        this.apiFilter.addValue(this.asyncId);
        this.executeAsync(new SendActionMessage(aTarget, aActionMessage, this.asyncId++), aCallback, _d);
    }

    @Override
    public void notice(String aTarget, String aText) {
        this.checkConnected();
        this.execute(new SendNoticeMessage(aTarget, aText));
    }

    @Override
    public void notice(String aTarget, String aText, Callback<String> aCallback) {
        if (!this.state.isConnected()) {
            aCallback.onFailure(new ApiException("Not connected!"));
            return;
        }
        Dirty _d = new Dirty();
        this.executeCmdListener.submitSendMessageCallback(this.asyncId, this.getDirtyCallback(aCallback, _d));
        this.apiFilter.addValue(this.asyncId);
        this.executeAsync(new SendNoticeMessage(aTarget, aText, this.asyncId++), aCallback, _d);
    }

    @Override
    public void kick(String aChannel, String aNick) {
        this.kick(aChannel, aNick, "");
    }

    @Override
    public void kick(String aChannel, String aNick, Callback<String> aCallback) {
        this.kick(aChannel, aNick, "", aCallback);
    }

    @Override
    public void kick(String aChannel, String aNick, String aKickMessage) {
        this.checkConnected();
        this.execute(new KickUserCmd(aChannel, aNick, aKickMessage));
    }

    @Override
    public void kick(String aChannel, String aNick, String aKickMessage, Callback<String> aCallback) {
        if (!this.state.isConnected()) {
            aCallback.onFailure(new ApiException("Not connected!"));
            return;
        }
        Dirty _d = new Dirty();
        this.executeCmdListener.submitKickUserCallback(aChannel, this.getDirtyCallback(aCallback, _d));
        this.executeAsync(new KickUserCmd(aChannel, aNick, aKickMessage), aCallback, _d);
    }

    @Override
    public void changeNick(String aNewNick) {
        this.checkConnected();
        this.execute(new ChangeNickCmd(aNewNick));
    }

    @Override
    public void changeNick(String aNewNickname, Callback<String> aCallback) {
        if (!this.state.isConnected()) {
            aCallback.onFailure(new ApiException("Not connected!"));
            return;
        }
        Dirty _d = new Dirty();
        this.executeCmdListener.submitChangeNickCallback(aNewNickname, this.getDirtyCallback(aCallback, _d));
        this.apiFilter.addValue(this.asyncId);
        this.executeAsync(new ChangeNickCmd(aNewNickname), aCallback, _d);
    }

    @Override
    public void changeTopic(String aChannel, String aSuggestedTopic) {
        this.checkConnected();
        this.execute(new ChangeTopicCmd(aChannel, aSuggestedTopic));
    }

    @Override
    public void changeMode(String aModeString) {
        this.checkConnected();
        this.execute(new ChangeModeCmd(aModeString));
    }

    @Override
    public void rawMessage(String aMessage) {
        this.execute(new SendRawMessage(aMessage));
    }

    @Override
    public void addListener(IMessageListener aListener) {
        this.session.addListeners(MESSAGE_VISIBILITY.PUBLIC, aListener);
    }

    @Override
    public void deleteListener(IMessageListener aListener) {
        this.session.removeListener(aListener);
    }

    @Override
    public void setMessageFilter(IMessageFilter aFilter) {
        this.filter = aFilter;
    }

    @Override
    public void dccSend(String aNick, File aFile, DCCSendCallback aCallback) {
        this.dccSend(aNick, aFile, NetUtils.getRandDccPort(), 10000, aCallback);
    }

    @Override
    public void dccSend(String aNick, Integer aListeningPort, File aFile, DCCSendCallback aCallback) {
        this.dccSend(aNick, aFile, aListeningPort, 10000, aCallback);
    }

    @Override
    public void dccSend(String aNick, File aFile, Integer aTimeout, DCCSendCallback aCallback) {
        this.dccSend(aNick, aFile, NetUtils.getRandDccPort(), aTimeout, aCallback);
    }

    @Override
    public void dccSend(String aNick, File aFile, Integer aListeningPort, Integer aTimeout, DCCSendCallback aCallback) {
        this.dccManager.dccSend(aNick, aFile, aListeningPort, aTimeout, aCallback);
    }

    @Override
    public void dccAccept(String aNick, File aFile, Integer aPort, Integer aResumePosition, DCCSendCallback aCallback) {
        this.dccAccept(aNick, aFile, aPort, aResumePosition, 10000, aCallback);
    }

    @Override
    public void dccAccept(String aNick, File aFile, Integer aPort, Integer aResumePosition, Integer aTimeout, DCCSendCallback aCallback) {
        this.dccManager.dccAccept(aNick, aFile, aPort, aResumePosition, aTimeout, aCallback);
    }

    @Override
    public void dccReceive(File aFile, Integer aSize, SocketAddress aAddress, DCCReceiveCallback aCallback) {
        this.dccResume(aFile, 0, aSize, aAddress, aCallback);
    }

    @Override
    public void dccResume(File aFile, Integer aResumePosition, Integer aSize, SocketAddress aAddress, DCCReceiveCallback aCallback) {
        this.dccManager.dccResume(aFile, aResumePosition, aSize, aAddress, aCallback);
    }

    @Override
    public DCCManager getDCCManager() {
        return this.dccManager;
    }

    protected ICommandServer getCommandServer() {
        return this.session.getCommandServer();
    }

    private String prependChanType(String aChannelName) {
        for (Character _c : this.state.getServerOptions().getChanTypes()) {
            if (!_c.equals(Character.valueOf(aChannelName.charAt(0)))) continue;
            return aChannelName;
        }
        return this.state.getServerOptions().getChanTypes().iterator().next() + aChannelName;
    }

    private void closeSession(Callback<IIRCState> aCallback) {
        try {
            this.session.close();
        }
        catch (IOException aExc) {
            aCallback.onFailure(aExc);
            LOG.error("Error Closing Session.", (Throwable)aExc);
        }
    }

    private void checkConnected() {
        if (!this.state.isConnected()) {
            throw new ApiException("Not connected!");
        }
    }

    private Callback<IIRCState> newConnectCallback(final Callback<IIRCState> aCallback, final Dirty aDirty) {
        return new Callback<IIRCState>(){

            @Override
            public void onSuccess(IIRCState aConnectedState) {
                IRCApiImpl.this.state = aConnectedState;
                ((IRCStateImpl)IRCApiImpl.this.state).setConnected(true);
                aCallback.onSuccess(aConnectedState);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Exception aExc) {
                LOG.info("", (Throwable)aExc);
                Dirty dirty = aDirty;
                synchronized (dirty) {
                    if (!aDirty.isDirty()) {
                        aCallback.onFailure(aExc);
                        aDirty.setDirty();
                    }
                }
            }
        };
    }

    private void execute(ICommand aCommand) {
        try {
            this.getCommandServer().execute(aCommand);
        }
        catch (IOException aExc) {
            LOG.error("Error executing command", (Throwable)aExc);
            throw new RuntimeException(aExc);
        }
    }

    private IStateAccessor getStateUpdater(Boolean aSaveIRCState) {
        IStateAccessor _stateUpdater = new AbstractIRCStateUpdater(){

            @Override
            public IIRCState getIRCState() {
                return IRCApiImpl.this.state;
            }
        };
        if (aSaveIRCState.booleanValue()) {
            this.session.addListeners(MESSAGE_VISIBILITY.PRIVATE, new IMessageListener[]{_stateUpdater});
        } else {
            _stateUpdater = new IStateAccessor(){

                @Override
                public void saveChan(IRCChannel aChannel) {
                }

                @Override
                public IIRCState getIRCState() {
                    return IRCApiImpl.this.state;
                }

                @Override
                public void deleteChan(String aChannelName) {
                }

                @Override
                public void updateNick(String aNewNick) {
                }

                @Override
                public void deleteNickFromChan(String aChan, String aNick) {
                }
            };
        }
        return _stateUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAsync(ICommand aCommand, Callback<?> aCallback, Dirty aDirty) {
        try {
            this.getCommandServer().execute(aCommand);
        }
        catch (IOException aExc) {
            LOG.error("Error executing command", (Throwable)aExc);
            Dirty dirty = aDirty;
            synchronized (dirty) {
                if (!aDirty.isDirty()) {
                    aCallback.onFailure(aExc);
                    aDirty.setDirty();
                }
            }
        }
    }

    private <R> Callback<R> getDirtyCallback(final Callback<R> aCallback, final Dirty aDirty) {
        return new Callback<R>(){

            @Override
            public void onSuccess(R aObject) {
                aCallback.onSuccess(aObject);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Exception aExc) {
                LOG.info("", (Throwable)aExc);
                Dirty dirty = aDirty;
                synchronized (dirty) {
                    if (!aDirty.isDirty()) {
                        aCallback.onFailure(aExc);
                        aDirty.setDirty();
                    }
                }
            }
        };
    }

    private class Dirty {
        boolean dirty;

        private Dirty() {
        }

        void setDirty() {
            this.dirty = true;
        }

        boolean isDirty() {
            return this.dirty;
        }
    }
}

