/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api;

import com.ircclouds.irc.api.IMessageReader;
import com.ircclouds.irc.api.comms.INeedsConnection;
import com.ircclouds.irc.api.domain.IRCServerOptions;
import com.ircclouds.irc.api.domain.messages.interfaces.IMessage;
import com.ircclouds.irc.api.om.AbstractMessageFactory;
import com.ircclouds.irc.api.om.IRCOMException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageReader
implements IMessageReader,
INeedsConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMessageReader.class);
    private static final String CRLF = "\r\n";
    private AbstractMessageFactory msgFactory;
    private StringBuilder ircData = new StringBuilder();
    private Queue<String> ircMessages = new LinkedList<String>();
    private boolean canRead = true;

    public AbstractMessageReader() {
        this.msgFactory = new AbstractMessageFactory(){

            @Override
            protected IRCServerOptions getIRCServerOptions() {
                return AbstractMessageReader.this.getIRCServerOptions();
            }
        };
    }

    @Override
    public boolean available() {
        try {
            if (this.canRead) {
                this.ircData.append(this.getConnection().read());
                this.canRead = false;
                this.fetchNextBatch();
            }
            return !this.ircMessages.isEmpty() || this.ircData.length() != 0;
        }
        catch (IOException aExc) {
            LOG.error("Error reading from connection", (Throwable)aExc);
            return false;
        }
    }

    @Override
    public IMessage readMessage() {
        IMessage _msg = IMessage.NULL_MESSAGE;
        if (this.ircMessages.peek() != null) {
            try {
                _msg = this.msgFactory.build(this.ircMessages.poll());
            }
            catch (IRCOMException aExc) {
                LOG.error("Error from the OM layer", (Throwable)aExc);
            }
        }
        this.canRead = this.ircMessages.isEmpty();
        return _msg;
    }

    @Override
    public void reset() {
        this.ircMessages.clear();
        this.ircData.setLength(0);
        this.canRead = true;
    }

    protected abstract IRCServerOptions getIRCServerOptions();

    private void fetchNextBatch() {
        if (this.ircData.indexOf(CRLF) != -1) {
            String _tempMsg = this.ircData.toString();
            if (this.ircData.lastIndexOf(CRLF) != this.ircData.length() - CRLF.length() - 1) {
                int _i = this.ircData.lastIndexOf(CRLF);
                _tempMsg = this.ircData.substring(0, _i);
                this.ircData = new StringBuilder(this.ircData.substring(_i + CRLF.length()));
            } else {
                this.ircData.setLength(0);
            }
            this.ircMessages.addAll(Arrays.asList(_tempMsg.split(CRLF)));
        }
    }
}

