/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.worker.executor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import io.druid.concurrent.Execs;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.worker.executor.ExecutorLifecycleConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;

public class ExecutorLifecycle {
    private static final EmittingLogger log = new EmittingLogger(ExecutorLifecycle.class);
    private final ExecutorLifecycleConfig config;
    private final TaskActionClientFactory taskActionClientFactory;
    private final TaskRunner taskRunner;
    private final ObjectMapper jsonMapper;
    private final ExecutorService parentMonitorExec = Execs.singleThreaded((String)"parent-monitor-%d");
    private volatile ListenableFuture<TaskStatus> statusFuture = null;

    @Inject
    public ExecutorLifecycle(ExecutorLifecycleConfig config, TaskActionClientFactory taskActionClientFactory, TaskRunner taskRunner, ObjectMapper jsonMapper) {
        this.config = config;
        this.taskActionClientFactory = taskActionClientFactory;
        this.taskRunner = taskRunner;
        this.jsonMapper = jsonMapper;
    }

    @LifecycleStart
    public void start() {
        Task task;
        File taskFile = (File)Preconditions.checkNotNull((Object)this.config.getTaskFile(), (Object)"taskFile");
        final File statusFile = (File)Preconditions.checkNotNull((Object)this.config.getStatusFile(), (Object)"statusFile");
        final InputStream parentStream = (InputStream)Preconditions.checkNotNull((Object)this.config.getParentStream(), (Object)"parentStream");
        try {
            task = (Task)this.jsonMapper.readValue(taskFile, Task.class);
            log.info("Running with task: %s", new Object[]{this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)task)});
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.parentMonitorExec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    while (parentStream.read() != -1) {
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Failed to read from stdin", new Object[0]);
                }
                log.info("Triggering JVM shutdown.", new Object[0]);
                System.exit(2);
            }
        });
        try {
            if (!task.isReady(this.taskActionClientFactory.create(task))) {
                throw new ISE("Task is not ready to run yet!", new Object[]{task.getId()});
            }
        }
        catch (Exception e) {
            throw new ISE((Throwable)e, "Failed to run isReady", new Object[]{task.getId()});
        }
        this.statusFuture = Futures.transform(this.taskRunner.run(task), (Function)new Function<TaskStatus, TaskStatus>(){

            public TaskStatus apply(TaskStatus taskStatus) {
                try {
                    log.info("Task completed with status: %s", new Object[]{ExecutorLifecycle.this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)taskStatus)});
                    File statusFileParent = statusFile.getParentFile();
                    if (statusFileParent != null) {
                        statusFileParent.mkdirs();
                    }
                    ExecutorLifecycle.this.jsonMapper.writeValue(statusFile, (Object)taskStatus);
                    return taskStatus;
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    public void join() {
        try {
            this.statusFuture.get();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @LifecycleStop
    public void stop() {
        this.parentMonitorExec.shutdown();
    }
}

