/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.common.task.TaskResource;

public class TaskAnnouncement {
    private final TaskStatus taskStatus;
    private final TaskResource taskResource;

    public static TaskAnnouncement create(Task task, TaskStatus status) {
        Preconditions.checkArgument((boolean)status.getId().equals(task.getId()), (Object)"task id == status id");
        return new TaskAnnouncement(null, null, status, task.getTaskResource());
    }

    @JsonCreator
    private TaskAnnouncement(@JsonProperty(value="id") String taskId, @JsonProperty(value="status") TaskStatus.Status status, @JsonProperty(value="taskStatus") TaskStatus taskStatus, @JsonProperty(value="taskResource") TaskResource taskResource) {
        this.taskStatus = taskStatus != null ? taskStatus : TaskStatus.fromCode(taskId, status);
        this.taskResource = taskResource == null ? new TaskResource(this.taskStatus.getId(), 1) : taskResource;
    }

    @JsonProperty(value="id")
    @Deprecated
    public String getTaskId() {
        return this.taskStatus.getId();
    }

    @JsonProperty(value="status")
    @Deprecated
    public TaskStatus.Status getStatus() {
        return this.taskStatus.getStatusCode();
    }

    @JsonProperty(value="taskStatus")
    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    @JsonProperty(value="taskResource")
    public TaskResource getTaskResource() {
        return this.taskResource;
    }
}

