/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.client.util.Charsets;
import io.druid.indexing.overlord.setup.EC2UserData;
import org.apache.commons.codec.binary.Base64;

public class StringEC2UserData
implements EC2UserData<StringEC2UserData> {
    private final String data;
    private final String versionReplacementString;
    private final String version;

    @JsonCreator
    public StringEC2UserData(@JsonProperty(value="data") String data, @JsonProperty(value="versionReplacementString") String versionReplacementString, @JsonProperty(value="version") String version) {
        this.data = data;
        this.versionReplacementString = versionReplacementString;
        this.version = version;
    }

    @JsonProperty
    public String getData() {
        return this.data;
    }

    @JsonProperty
    public String getVersionReplacementString() {
        return this.versionReplacementString;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    public StringEC2UserData withVersion(String _version) {
        return new StringEC2UserData(this.data, this.versionReplacementString, _version);
    }

    @Override
    public String getUserDataBase64() {
        String finalData = this.versionReplacementString != null && this.version != null ? this.data.replace(this.versionReplacementString, this.version) : this.data;
        return Base64.encodeBase64String((byte[])finalData.getBytes(Charsets.UTF_8));
    }

    public String toString() {
        return "StringEC2UserData{data='" + this.data + '\'' + ", versionReplacementString='" + this.versionReplacementString + '\'' + ", version='" + this.version + '\'' + '}';
    }
}

