/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.repackaged.com.google.common.base.Throwables;
import io.druid.guice.annotations.Json;
import io.druid.indexing.overlord.setup.EC2UserData;
import org.apache.commons.codec.binary.Base64;

public class GalaxyEC2UserData
implements EC2UserData<GalaxyEC2UserData> {
    private final ObjectMapper jsonMapper;
    private final String env;
    private final String version;
    private final String type;

    @JsonCreator
    public GalaxyEC2UserData(@JacksonInject @Json ObjectMapper jsonMapper, @JsonProperty(value="env") String env, @JsonProperty(value="version") String version, @JsonProperty(value="type") String type) {
        this.jsonMapper = jsonMapper;
        this.env = env;
        this.version = version;
        this.type = type;
    }

    @JsonProperty
    public String getEnv() {
        return this.env;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    public GalaxyEC2UserData withVersion(String ver) {
        return new GalaxyEC2UserData(this.jsonMapper, this.env, ver, this.type);
    }

    @Override
    public String getUserDataBase64() {
        try {
            return Base64.encodeBase64String((byte[])this.jsonMapper.writeValueAsBytes((Object)this));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String toString() {
        return "GalaxyUserData{env='" + this.env + '\'' + ", version='" + this.version + '\'' + ", type='" + this.type + '\'' + '}';
    }
}

