/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.actions.SegmentInsertAction;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.timeline.DataSegment;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TaskStorageQueryAdapter {
    private final TaskStorage storage;

    @Inject
    public TaskStorageQueryAdapter(TaskStorage storage) {
        this.storage = storage;
    }

    public List<Task> getActiveTasks() {
        return this.storage.getActiveTasks();
    }

    public List<TaskStatus> getRecentlyFinishedTaskStatuses() {
        return this.storage.getRecentlyFinishedTaskStatuses();
    }

    public Optional<Task> getTask(String taskid) {
        return this.storage.getTask(taskid);
    }

    public Optional<TaskStatus> getStatus(String taskid) {
        return this.storage.getStatus(taskid);
    }

    public Set<DataSegment> getInsertedSegments(String taskid) {
        HashSet segments = Sets.newHashSet();
        for (TaskAction action : this.storage.getAuditLogs(taskid)) {
            if (!(action instanceof SegmentInsertAction)) continue;
            segments.addAll(((SegmentInsertAction)action).getSegments());
        }
        return segments;
    }
}

