/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.metamx.common.concurrent.ScheduledExecutorFactory;
import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.curator.discovery.ServiceAnnouncer;
import io.druid.guice.annotations.Self;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.RemoteTaskRunner;
import io.druid.indexing.overlord.TaskLockbox;
import io.druid.indexing.overlord.TaskQueue;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskRunnerFactory;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.indexing.overlord.config.TaskQueueConfig;
import io.druid.indexing.overlord.scaling.ResourceManagementScheduler;
import io.druid.indexing.overlord.scaling.ResourceManagementSchedulerFactory;
import io.druid.server.DruidNode;
import io.druid.server.initialization.ZkPathsConfig;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.state.ConnectionState;

public class TaskMaster {
    private final LeaderSelector leaderSelector;
    private final ReentrantLock giant = new ReentrantLock();
    private final Condition mayBeStopped = this.giant.newCondition();
    private final TaskActionClientFactory taskActionClientFactory;
    private final AtomicReference<Lifecycle> leaderLifecycleRef = new AtomicReference<Object>(null);
    private volatile boolean leading = false;
    private volatile TaskRunner taskRunner;
    private volatile TaskQueue taskQueue;
    private volatile ResourceManagementScheduler resourceManagementScheduler;
    private static final EmittingLogger log = new EmittingLogger(TaskMaster.class);

    @Inject
    public TaskMaster(final TaskQueueConfig taskQueueConfig, final TaskLockbox taskLockbox, final TaskStorage taskStorage, final TaskActionClientFactory taskActionClientFactory, final @Self DruidNode node, ZkPathsConfig zkPaths, final TaskRunnerFactory runnerFactory, final ResourceManagementSchedulerFactory managementSchedulerFactory, CuratorFramework curator, final ServiceAnnouncer serviceAnnouncer, final ServiceEmitter emitter) {
        this.taskActionClientFactory = taskActionClientFactory;
        this.leaderSelector = new LeaderSelector(curator, zkPaths.getIndexerLeaderLatchPath(), new LeaderSelectorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void takeLeadership(CuratorFramework client) throws Exception {
                TaskMaster.this.giant.lock();
                try {
                    TaskMaster.this.stopLeading();
                    log.info("By the power of Grayskull, I have the power!", new Object[0]);
                    taskLockbox.syncFromStorage();
                    TaskMaster.this.taskRunner = runnerFactory.build();
                    TaskMaster.this.taskQueue = new TaskQueue(taskQueueConfig, taskStorage, TaskMaster.this.taskRunner, taskActionClientFactory, taskLockbox, emitter);
                    Lifecycle leaderLifecycle = new Lifecycle();
                    if (TaskMaster.this.leaderLifecycleRef.getAndSet(leaderLifecycle) != null) {
                        log.makeAlert("TaskMaster set a new Lifecycle without the old one being cleared!  Race condition", new Object[0]).emit();
                    }
                    leaderLifecycle.addManagedInstance((Object)TaskMaster.this.taskRunner);
                    if (TaskMaster.this.taskRunner instanceof RemoteTaskRunner) {
                        ScheduledExecutorFactory executorFactory = ScheduledExecutors.createFactory((Lifecycle)leaderLifecycle);
                        TaskMaster.this.resourceManagementScheduler = managementSchedulerFactory.build((RemoteTaskRunner)TaskMaster.this.taskRunner, executorFactory);
                        leaderLifecycle.addManagedInstance((Object)TaskMaster.this.resourceManagementScheduler);
                    }
                    leaderLifecycle.addManagedInstance((Object)TaskMaster.this.taskQueue);
                    leaderLifecycle.addHandler(new Lifecycle.Handler(){

                        public void start() throws Exception {
                            serviceAnnouncer.announce(node);
                        }

                        public void stop() {
                            serviceAnnouncer.unannounce(node);
                        }
                    });
                    try {
                        leaderLifecycle.start();
                        TaskMaster.this.leading = true;
                        while (TaskMaster.this.leading && !Thread.currentThread().isInterrupted()) {
                            TaskMaster.this.mayBeStopped.await();
                        }
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    finally {
                        log.info("Bowing out!", new Object[0]);
                        TaskMaster.this.stopLeading();
                    }
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to lead", new Object[0]).emit();
                    throw Throwables.propagate((Throwable)e);
                }
                finally {
                    TaskMaster.this.giant.unlock();
                }
            }

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                if (newState == ConnectionState.LOST || newState == ConnectionState.SUSPENDED) {
                    TaskMaster.this.stopLeading();
                }
            }
        });
        this.leaderSelector.setId(node.getHost());
        this.leaderSelector.autoRequeue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        this.giant.lock();
        try {
            this.leaderSelector.start();
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        this.giant.lock();
        try {
            this.leaderSelector.close();
            this.stopLeading();
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLeading() {
        this.giant.lock();
        try {
            if (this.leading) {
                this.leading = false;
                this.mayBeStopped.signalAll();
                Lifecycle leaderLifecycle = this.leaderLifecycleRef.getAndSet(null);
                if (leaderLifecycle != null) {
                    leaderLifecycle.stop();
                }
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    public boolean isLeading() {
        return this.leading;
    }

    public String getLeader() {
        try {
            return this.leaderSelector.getLeader().getId();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Optional<TaskRunner> getTaskRunner() {
        if (this.leading) {
            return Optional.of((Object)this.taskRunner);
        }
        return Optional.absent();
    }

    public Optional<TaskQueue> getTaskQueue() {
        if (this.leading) {
            return Optional.of((Object)this.taskQueue);
        }
        return Optional.absent();
    }

    public Optional<TaskActionClient> getTaskActionClient(Task task) {
        if (this.leading) {
            return Optional.of((Object)this.taskActionClientFactory.create(task));
        }
        return Optional.absent();
    }

    public Optional<ResourceManagementScheduler> getResourceManagementScheduler() {
        if (this.leading) {
            return Optional.fromNullable((Object)this.resourceManagementScheduler);
        }
        return Optional.absent();
    }
}

