/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.overlord.TaskRunnerWorkItem;
import io.druid.indexing.worker.Worker;
import org.joda.time.DateTime;

public class RemoteTaskRunnerWorkItem
extends TaskRunnerWorkItem {
    private final SettableFuture<TaskStatus> result;
    private final Worker worker;

    public RemoteTaskRunnerWorkItem(String taskId, Worker worker) {
        this(taskId, (SettableFuture<TaskStatus>)SettableFuture.create(), worker);
    }

    public RemoteTaskRunnerWorkItem(String taskId, DateTime createdTime, DateTime queueInsertionTime, Worker worker) {
        this(taskId, (SettableFuture<TaskStatus>)SettableFuture.create(), createdTime, queueInsertionTime, worker);
    }

    private RemoteTaskRunnerWorkItem(String taskId, SettableFuture<TaskStatus> result, Worker worker) {
        super(taskId, (ListenableFuture<TaskStatus>)result);
        this.result = result;
        this.worker = worker;
    }

    private RemoteTaskRunnerWorkItem(String taskId, SettableFuture<TaskStatus> result, DateTime createdTime, DateTime queueInsertionTime, Worker worker) {
        super(taskId, (ListenableFuture<TaskStatus>)result, createdTime, queueInsertionTime);
        this.result = result;
        this.worker = worker;
    }

    public Worker getWorker() {
        return this.worker;
    }

    public void setResult(TaskStatus status) {
        this.result.set((Object)status);
    }

    @Override
    public RemoteTaskRunnerWorkItem withQueueInsertionTime(DateTime time) {
        return new RemoteTaskRunnerWorkItem(this.getTaskId(), this.result, this.getCreatedTime(), time, this.worker);
    }

    public RemoteTaskRunnerWorkItem withWorker(Worker theWorker) {
        return new RemoteTaskRunnerWorkItem(this.getTaskId(), this.result, this.getCreatedTime(), this.getQueueInsertionTime(), theWorker);
    }
}

