/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.metamx.http.client.HttpClient;
import io.druid.curator.cache.PathChildrenCacheFactory;
import io.druid.curator.cache.SimplePathChildrenCacheFactory;
import io.druid.guice.annotations.Global;
import io.druid.indexing.overlord.RemoteTaskRunner;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskRunnerFactory;
import io.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import io.druid.indexing.overlord.setup.WorkerSetupData;
import io.druid.server.initialization.ZkPathsConfig;
import org.apache.curator.framework.CuratorFramework;

public class RemoteTaskRunnerFactory
implements TaskRunnerFactory {
    private final CuratorFramework curator;
    private final RemoteTaskRunnerConfig remoteTaskRunnerConfig;
    private final ZkPathsConfig zkPaths;
    private final ObjectMapper jsonMapper;
    private final Supplier<WorkerSetupData> setupDataWatch;
    private final HttpClient httpClient;

    @Inject
    public RemoteTaskRunnerFactory(CuratorFramework curator, RemoteTaskRunnerConfig remoteTaskRunnerConfig, ZkPathsConfig zkPaths, ObjectMapper jsonMapper, Supplier<WorkerSetupData> setupDataWatch, @Global HttpClient httpClient) {
        this.curator = curator;
        this.remoteTaskRunnerConfig = remoteTaskRunnerConfig;
        this.zkPaths = zkPaths;
        this.jsonMapper = jsonMapper;
        this.setupDataWatch = setupDataWatch;
        this.httpClient = httpClient;
    }

    @Override
    public TaskRunner build() {
        return new RemoteTaskRunner(this.jsonMapper, this.remoteTaskRunnerConfig, this.zkPaths, this.curator, (PathChildrenCacheFactory)new SimplePathChildrenCacheFactory.Builder().withCompressed(this.remoteTaskRunnerConfig.isCompressZnodes()).build(), this.setupDataWatch, this.httpClient);
    }
}

