/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.InputSupplier;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.metamx.common.ISE;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.response.HttpResponseHandler;
import com.metamx.http.client.response.InputStreamResponseHandler;
import com.metamx.http.client.response.StatusResponseHandler;
import com.metamx.http.client.response.StatusResponseHolder;
import io.druid.curator.cache.PathChildrenCacheFactory;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.RemoteTaskRunnerWorkItem;
import io.druid.indexing.overlord.RemoteTaskRunnerWorkQueue;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.ZkWorker;
import io.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import io.druid.indexing.overlord.setup.WorkerSetupData;
import io.druid.indexing.worker.TaskAnnouncement;
import io.druid.indexing.worker.Worker;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.tasklogs.TaskLogStreamer;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.DateTime;

public class RemoteTaskRunner
implements TaskRunner,
TaskLogStreamer {
    private static final EmittingLogger log = new EmittingLogger(RemoteTaskRunner.class);
    private static final StatusResponseHandler RESPONSE_HANDLER = new StatusResponseHandler(Charsets.UTF_8);
    private static final Joiner JOINER = Joiner.on((String)"/");
    private final ObjectMapper jsonMapper;
    private final RemoteTaskRunnerConfig config;
    private final ZkPathsConfig zkPaths;
    private final CuratorFramework cf;
    private final PathChildrenCacheFactory pathChildrenCacheFactory;
    private final PathChildrenCache workerPathCache;
    private final Supplier<WorkerSetupData> workerSetupData;
    private final HttpClient httpClient;
    private final ConcurrentMap<String, ZkWorker> zkWorkers = new ConcurrentHashMap<String, ZkWorker>();
    private final ConcurrentMap<String, Task> pendingTaskPayloads = new ConcurrentHashMap<String, Task>();
    private final RemoteTaskRunnerWorkQueue pendingTasks = new RemoteTaskRunnerWorkQueue();
    private final RemoteTaskRunnerWorkQueue runningTasks = new RemoteTaskRunnerWorkQueue();
    private final RemoteTaskRunnerWorkQueue completeTasks = new RemoteTaskRunnerWorkQueue();
    private final ExecutorService runPendingTasksExec = Executors.newSingleThreadExecutor();
    private final Object statusLock = new Object();
    private volatile boolean started = false;

    public RemoteTaskRunner(ObjectMapper jsonMapper, RemoteTaskRunnerConfig config, ZkPathsConfig zkPaths, CuratorFramework cf, PathChildrenCacheFactory pathChildrenCacheFactory, Supplier<WorkerSetupData> workerSetupData, HttpClient httpClient) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.zkPaths = zkPaths;
        this.cf = cf;
        this.pathChildrenCacheFactory = pathChildrenCacheFactory;
        this.workerPathCache = pathChildrenCacheFactory.make(cf, zkPaths.getIndexerAnnouncementPath());
        this.workerSetupData = workerSetupData;
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        try {
            if (this.started) {
                return;
            }
            final MutableInt waitingFor = new MutableInt(1);
            final Object waitingForMonitor = new Object();
            this.workerPathCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                    switch (event.getType()) {
                        case CHILD_ADDED: {
                            Worker worker = (Worker)RemoteTaskRunner.this.jsonMapper.readValue(event.getData().getData(), Worker.class);
                            Object object = waitingForMonitor;
                            synchronized (object) {
                                waitingFor.increment();
                            }
                            Futures.addCallback((ListenableFuture)RemoteTaskRunner.this.addWorker(worker), (FutureCallback)new FutureCallback<ZkWorker>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void onSuccess(ZkWorker zkWorker) {
                                    Object object = waitingForMonitor;
                                    synchronized (object) {
                                        waitingFor.decrement();
                                        waitingForMonitor.notifyAll();
                                    }
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void onFailure(Throwable throwable) {
                                    Object object = waitingForMonitor;
                                    synchronized (object) {
                                        waitingFor.decrement();
                                        waitingForMonitor.notifyAll();
                                    }
                                }
                            });
                            break;
                        }
                        case CHILD_REMOVED: {
                            Worker worker = (Worker)RemoteTaskRunner.this.jsonMapper.readValue(event.getData().getData(), Worker.class);
                            RemoteTaskRunner.this.removeWorker(worker);
                            break;
                        }
                        case INITIALIZED: {
                            Object object = waitingForMonitor;
                            synchronized (object) {
                                waitingFor.decrement();
                                waitingForMonitor.notifyAll();
                                break;
                            }
                        }
                    }
                }
            });
            this.workerPathCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
            Object object = waitingForMonitor;
            synchronized (object) {
                while (waitingFor.intValue() > 0) {
                    waitingForMonitor.wait();
                }
            }
            this.started = true;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @LifecycleStop
    public void stop() {
        try {
            if (!this.started) {
                return;
            }
            this.started = false;
            for (ZkWorker zkWorker : this.zkWorkers.values()) {
                zkWorker.close();
            }
            this.workerPathCache.close();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Collection<ZkWorker> getWorkers() {
        return ImmutableList.copyOf(this.zkWorkers.values());
    }

    public Collection<RemoteTaskRunnerWorkItem> getRunningTasks() {
        return ImmutableList.copyOf(this.runningTasks.values());
    }

    public Collection<RemoteTaskRunnerWorkItem> getPendingTasks() {
        return ImmutableList.copyOf(this.pendingTasks.values());
    }

    public Collection<RemoteTaskRunnerWorkItem> getKnownTasks() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.pendingTasks.values(), this.runningTasks.values(), this.completeTasks.values()));
    }

    public ZkWorker findWorkerRunningTask(String taskId) {
        for (ZkWorker zkWorker : this.zkWorkers.values()) {
            if (!zkWorker.isRunningTask(taskId)) continue;
            return zkWorker;
        }
        return null;
    }

    public boolean isWorkerRunningTask(Worker worker, String taskId) {
        ZkWorker zkWorker = (ZkWorker)this.zkWorkers.get(worker.getHost());
        return zkWorker != null && zkWorker.isRunningTask(taskId);
    }

    @Override
    public ListenableFuture<TaskStatus> run(Task task) {
        RemoteTaskRunnerWorkItem pendingTask = (RemoteTaskRunnerWorkItem)this.pendingTasks.get(task.getId());
        if (pendingTask != null) {
            log.info("Assigned a task[%s] that is already pending, not doing anything", new Object[]{task.getId()});
            return pendingTask.getResult();
        }
        RemoteTaskRunnerWorkItem runningTask = (RemoteTaskRunnerWorkItem)this.runningTasks.get(task.getId());
        if (runningTask != null) {
            ZkWorker zkWorker = this.findWorkerRunningTask(task.getId());
            if (zkWorker == null) {
                log.warn("Told to run task[%s], but no worker has started running it yet.", new Object[]{task.getId()});
            } else {
                log.info("Task[%s] already running on %s.", new Object[]{task.getId(), zkWorker.getWorker().getHost()});
                TaskAnnouncement announcement = zkWorker.getRunningTasks().get(task.getId());
                if (announcement.getTaskStatus().isComplete()) {
                    this.taskComplete(runningTask, zkWorker, announcement.getTaskStatus());
                }
            }
            return runningTask.getResult();
        }
        RemoteTaskRunnerWorkItem completeTask = (RemoteTaskRunnerWorkItem)this.completeTasks.get(task.getId());
        if (completeTask != null) {
            return completeTask.getResult();
        }
        return this.addPendingTask(task).getResult();
    }

    @Override
    public void shutdown(String taskId) {
        if (!this.started) {
            log.info("This TaskRunner is stopped. Ignoring shutdown command for task: %s", new Object[]{taskId});
        } else if (this.pendingTasks.remove(taskId) != null) {
            this.pendingTaskPayloads.remove(taskId);
            log.info("Removed task from pending queue: %s", new Object[]{taskId});
        } else if (this.completeTasks.containsKey(taskId)) {
            this.cleanup(taskId);
        } else {
            ZkWorker zkWorker = this.findWorkerRunningTask(taskId);
            if (zkWorker == null) {
                log.info("Can't shutdown! No worker running task %s", new Object[]{taskId});
                return;
            }
            try {
                URL url = this.makeWorkerURL(zkWorker.getWorker(), String.format("/task/%s/shutdown", taskId));
                StatusResponseHolder response = (StatusResponseHolder)this.httpClient.post(url).go((HttpResponseHandler)RESPONSE_HANDLER).get();
                log.info("Sent shutdown message to worker: %s, status %s, response: %s", new Object[]{zkWorker.getWorker().getHost(), response.getStatus(), response.getContent()});
                if (!response.getStatus().equals((Object)HttpResponseStatus.ACCEPTED)) {
                    log.error("Shutdown failed for %s! Are you sure the task was running?", new Object[]{taskId});
                }
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public Optional<InputSupplier<InputStream>> streamTaskLog(String taskId, long offset) {
        ZkWorker zkWorker = this.findWorkerRunningTask(taskId);
        if (zkWorker == null) {
            return Optional.absent();
        }
        final URL url = this.makeWorkerURL(zkWorker.getWorker(), String.format("/task/%s/log?offset=%d", taskId, offset));
        return Optional.of((Object)new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                try {
                    return (InputStream)RemoteTaskRunner.this.httpClient.get(url).go((HttpResponseHandler)new InputStreamResponseHandler()).get();
                }
                catch (InterruptedException e) {
                    throw Throwables.propagate((Throwable)e);
                }
                catch (ExecutionException e) {
                    Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class);
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    private URL makeWorkerURL(Worker worker, String path) {
        Preconditions.checkArgument((boolean)path.startsWith("/"), (String)"path must start with '/': %s", (Object[])new Object[]{path});
        try {
            return new URL(String.format("http://%s/druid/worker/v1%s", worker.getHost(), path));
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private RemoteTaskRunnerWorkItem addPendingTask(Task task) {
        log.info("Added pending task %s", new Object[]{task.getId()});
        RemoteTaskRunnerWorkItem taskRunnerWorkItem = new RemoteTaskRunnerWorkItem(task.getId(), null);
        this.pendingTaskPayloads.put(task.getId(), task);
        this.pendingTasks.put(task.getId(), taskRunnerWorkItem);
        this.runPendingTasks();
        return taskRunnerWorkItem;
    }

    private void runPendingTasks() {
        this.runPendingTasksExec.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    ArrayList copy = Lists.newArrayList(RemoteTaskRunner.this.pendingTasks.values());
                    for (RemoteTaskRunnerWorkItem taskRunnerWorkItem : copy) {
                        String taskId = taskRunnerWorkItem.getTaskId();
                        try {
                            if (!RemoteTaskRunner.this.tryAssignTask((Task)RemoteTaskRunner.this.pendingTaskPayloads.get(taskId), taskRunnerWorkItem)) continue;
                            RemoteTaskRunner.this.pendingTaskPayloads.remove(taskId);
                        }
                        catch (Exception e) {
                            log.makeAlert((Throwable)e, "Exception while trying to assign task", new Object[0]).addData("taskId", (Object)taskRunnerWorkItem.getTaskId()).emit();
                            RemoteTaskRunnerWorkItem workItem = (RemoteTaskRunnerWorkItem)RemoteTaskRunner.this.pendingTasks.remove(taskId);
                            RemoteTaskRunner.this.taskComplete(workItem, null, TaskStatus.failure(taskId));
                        }
                    }
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Exception in running pending tasks", new Object[0]).emit();
                }
                return null;
            }
        });
    }

    private void cleanup(String taskId) {
        if (!this.started) {
            return;
        }
        RemoteTaskRunnerWorkItem removed = (RemoteTaskRunnerWorkItem)this.completeTasks.remove(taskId);
        Worker worker = removed.getWorker();
        if (removed == null || worker == null) {
            log.makeAlert("WTF?! Asked to cleanup nonexistent task", new Object[0]).addData("taskId", (Object)taskId).emit();
        } else {
            String workerId = worker.getHost();
            log.info("Cleaning up task[%s] on worker[%s]", new Object[]{taskId, workerId});
            String statusPath = JOINER.join((Object)this.zkPaths.getIndexerStatusPath(), (Object)workerId, new Object[]{taskId});
            try {
                this.cf.delete().guaranteed().forPath(statusPath);
            }
            catch (KeeperException.NoNodeException e) {
                log.info("Tried to delete status path[%s] that didn't exist! Must've gone away already?", new Object[]{statusPath});
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private boolean tryAssignTask(Task task, RemoteTaskRunnerWorkItem taskRunnerWorkItem) throws Exception {
        Preconditions.checkNotNull((Object)task, (Object)"task");
        Preconditions.checkNotNull((Object)taskRunnerWorkItem, (Object)"taskRunnerWorkItem");
        Preconditions.checkArgument((boolean)task.getId().equals(taskRunnerWorkItem.getTaskId()), (Object)"task id != workItem id");
        if (this.runningTasks.containsKey(task.getId()) || this.findWorkerRunningTask(task.getId()) != null) {
            log.info("Task[%s] already running.", new Object[]{task.getId()});
            return true;
        }
        ZkWorker zkWorker = this.findWorkerForTask(task);
        if (zkWorker != null) {
            this.announceTask(task, zkWorker, taskRunnerWorkItem);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void announceTask(Task task, ZkWorker theZkWorker, RemoteTaskRunnerWorkItem taskRunnerWorkItem) throws Exception {
        RemoteTaskRunnerWorkItem workItem;
        Preconditions.checkArgument((boolean)task.getId().equals(taskRunnerWorkItem.getTaskId()), (Object)"task id != workItem id");
        Worker theWorker = theZkWorker.getWorker();
        log.info("Coordinator asking Worker[%s] to add task[%s]", new Object[]{theWorker.getHost(), task.getId()});
        byte[] rawBytes = this.jsonMapper.writeValueAsBytes((Object)task);
        if ((long)rawBytes.length > this.config.getMaxZnodeBytes()) {
            throw new ISE("Length of raw bytes for task too large[%,d > %,d]", new Object[]{rawBytes.length, this.config.getMaxZnodeBytes()});
        }
        String taskPath = JOINER.join((Object)this.zkPaths.getIndexerTaskPath(), (Object)theWorker.getHost(), new Object[]{task.getId()});
        if (this.cf.checkExists().forPath(taskPath) == null) {
            ((ACLBackgroundPathAndBytesable)this.cf.create().withMode(CreateMode.EPHEMERAL)).forPath(taskPath, rawBytes);
        }
        if ((workItem = (RemoteTaskRunnerWorkItem)this.pendingTasks.remove(task.getId())) == null) {
            log.makeAlert("WTF?! Got a null work item from pending tasks?! How can this be?!", new Object[0]).addData("taskId", (Object)task.getId()).emit();
            return;
        }
        RemoteTaskRunnerWorkItem newWorkItem = workItem.withWorker(theWorker);
        this.runningTasks.put(task.getId(), newWorkItem);
        log.info("Task %s switched from pending to running (on [%s])", new Object[]{task.getId(), newWorkItem.getWorker().getHost()});
        Stopwatch timeoutStopwatch = Stopwatch.createUnstarted();
        timeoutStopwatch.start();
        Object object = this.statusLock;
        synchronized (object) {
            while (!this.isWorkerRunningTask(theWorker, task.getId())) {
                long waitMs = this.config.getTaskAssignmentTimeout().toStandardDuration().getMillis();
                this.statusLock.wait(waitMs);
                long elapsed = timeoutStopwatch.elapsed(TimeUnit.MILLISECONDS);
                if (elapsed < waitMs) continue;
                log.error("Something went wrong! [%s] never ran task [%s]! Timeout: (%s >= %s)!", new Object[]{theWorker.getHost(), task.getId(), elapsed, this.config.getTaskAssignmentTimeout()});
                this.taskComplete(taskRunnerWorkItem, theZkWorker, TaskStatus.failure(task.getId()));
                break;
            }
        }
    }

    private ListenableFuture<ZkWorker> addWorker(final Worker worker) {
        log.info("Worker[%s] reportin' for duty!", new Object[]{worker.getHost()});
        try {
            String workerStatusPath = JOINER.join((Object)this.zkPaths.getIndexerStatusPath(), (Object)worker.getHost(), new Object[0]);
            PathChildrenCache statusCache = this.pathChildrenCacheFactory.make(this.cf, workerStatusPath);
            final SettableFuture retVal = SettableFuture.create();
            final ZkWorker zkWorker = new ZkWorker(worker, statusCache, this.jsonMapper);
            zkWorker.addListener(new PathChildrenCacheListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                    Object object = RemoteTaskRunner.this.statusLock;
                    synchronized (object) {
                        try {
                            switch (event.getType()) {
                                case CHILD_ADDED: 
                                case CHILD_UPDATED: {
                                    RemoteTaskRunnerWorkItem taskRunnerWorkItem;
                                    String taskId = ZKPaths.getNodeFromPath((String)event.getData().getPath());
                                    TaskStatus taskStatus = (TaskStatus)RemoteTaskRunner.this.jsonMapper.readValue(event.getData().getData(), TaskStatus.class);
                                    log.info("Worker[%s] wrote %s status for task: %s", new Object[]{zkWorker.getWorker().getHost(), taskStatus.getStatusCode(), taskId});
                                    RemoteTaskRunner.this.statusLock.notifyAll();
                                    RemoteTaskRunnerWorkItem tmp = (RemoteTaskRunnerWorkItem)RemoteTaskRunner.this.runningTasks.get(taskId);
                                    if (tmp != null) {
                                        taskRunnerWorkItem = tmp;
                                    } else {
                                        RemoteTaskRunnerWorkItem newTaskRunnerWorkItem = new RemoteTaskRunnerWorkItem(taskId, zkWorker.getWorker());
                                        RemoteTaskRunnerWorkItem existingItem = RemoteTaskRunner.this.runningTasks.putIfAbsent(taskId, newTaskRunnerWorkItem);
                                        if (existingItem == null) {
                                            log.warn("Worker[%s] announced a status for a task I didn't know about, adding to runningTasks: %s", new Object[]{zkWorker.getWorker().getHost(), taskId});
                                            taskRunnerWorkItem = newTaskRunnerWorkItem;
                                        } else {
                                            taskRunnerWorkItem = existingItem;
                                        }
                                    }
                                    if (!taskStatus.isComplete()) break;
                                    RemoteTaskRunner.this.taskComplete(taskRunnerWorkItem, zkWorker, taskStatus);
                                    RemoteTaskRunner.this.runPendingTasks();
                                    break;
                                }
                                case CHILD_REMOVED: {
                                    String taskId = ZKPaths.getNodeFromPath((String)event.getData().getPath());
                                    RemoteTaskRunnerWorkItem taskRunnerWorkItem = (RemoteTaskRunnerWorkItem)RemoteTaskRunner.this.runningTasks.remove(taskId);
                                    if (taskRunnerWorkItem != null) {
                                        log.info("Task[%s] just disappeared!", new Object[]{taskId});
                                        taskRunnerWorkItem.setResult(TaskStatus.failure(taskRunnerWorkItem.getTaskId()));
                                        break;
                                    }
                                    log.info("Task[%s] went bye bye.", new Object[]{taskId});
                                    break;
                                }
                                case INITIALIZED: {
                                    if (RemoteTaskRunner.this.zkWorkers.putIfAbsent(worker.getHost(), zkWorker) == null) {
                                        retVal.set((Object)zkWorker);
                                    } else {
                                        String message = String.format("WTF?! Tried to add already-existing worker[%s]", worker.getHost());
                                        log.makeAlert(message, new Object[0]).addData("workerHost", (Object)worker.getHost()).addData("workerIp", (Object)worker.getIp()).emit();
                                        retVal.setException((Throwable)new IllegalStateException(message));
                                    }
                                    RemoteTaskRunner.this.runPendingTasks();
                                }
                            }
                        }
                        catch (Exception e) {
                            log.makeAlert((Throwable)e, "Failed to handle new worker status", new Object[0]).addData("worker", (Object)zkWorker.getWorker().getHost()).addData("znode", (Object)event.getData().getPath()).emit();
                        }
                    }
                }
            });
            zkWorker.start();
            return retVal;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeWorker(Worker worker) {
        log.info("Kaboom! Worker[%s] removed!", new Object[]{worker.getHost()});
        ZkWorker zkWorker = (ZkWorker)this.zkWorkers.get(worker.getHost());
        if (zkWorker == null) return;
        try {
            ArrayList tasksToFail = Lists.newArrayList((Iterable)((Iterable)this.cf.getChildren().forPath(JOINER.join((Object)this.zkPaths.getIndexerTaskPath(), (Object)worker.getHost(), new Object[0]))));
            log.info("[%s]: Found %d tasks assigned", new Object[]{worker.getHost(), tasksToFail.size()});
            for (Map.Entry entry : this.runningTasks.entrySet()) {
                if (entry.getValue() == null) {
                    log.error("Huh? null work item for [%s]", new Object[]{entry.getKey()});
                    continue;
                }
                if (((RemoteTaskRunnerWorkItem)entry.getValue()).getWorker() == null) {
                    log.error("Huh? no worker for [%s]", new Object[]{entry.getKey()});
                    continue;
                }
                if (!((RemoteTaskRunnerWorkItem)entry.getValue()).getWorker().getHost().equalsIgnoreCase(worker.getHost())) continue;
                log.info("[%s]: Found [%s] running", new Object[]{worker.getHost(), entry.getKey()});
                tasksToFail.add(entry.getKey());
            }
            for (String assignedTask : tasksToFail) {
                RemoteTaskRunnerWorkItem taskRunnerWorkItem = (RemoteTaskRunnerWorkItem)this.runningTasks.remove(assignedTask);
                if (taskRunnerWorkItem != null) {
                    String taskPath = JOINER.join((Object)this.zkPaths.getIndexerTaskPath(), (Object)worker.getHost(), new Object[]{assignedTask});
                    if (this.cf.checkExists().forPath(taskPath) != null) {
                        this.cf.delete().guaranteed().forPath(taskPath);
                    }
                    log.info("Failing task[%s]", new Object[]{assignedTask});
                    taskRunnerWorkItem.setResult(TaskStatus.failure(taskRunnerWorkItem.getTaskId()));
                    continue;
                }
                log.warn("RemoteTaskRunner has no knowledge of task[%s]", new Object[]{assignedTask});
            }
        }
        catch (Exception e) {
            try {
                throw Throwables.propagate((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    zkWorker.close();
                }
                catch (Exception e2) {
                    log.error((Throwable)e2, "Exception closing worker[%s]!", new Object[]{worker.getHost()});
                }
                this.zkWorkers.remove(worker.getHost());
                throw throwable;
            }
        }
        try {
            zkWorker.close();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception closing worker[%s]!", new Object[]{worker.getHost()});
        }
        this.zkWorkers.remove(worker.getHost());
    }

    private ZkWorker findWorkerForTask(Task task) {
        TreeSet sortedWorkers = Sets.newTreeSet((Comparator)new Comparator<ZkWorker>(){

            @Override
            public int compare(ZkWorker zkWorker, ZkWorker zkWorker2) {
                int retVal = -Ints.compare((int)zkWorker.getCurrCapacityUsed(), (int)zkWorker2.getCurrCapacityUsed());
                if (retVal == 0) {
                    retVal = zkWorker.getWorker().getHost().compareTo(zkWorker2.getWorker().getHost());
                }
                return retVal;
            }
        });
        sortedWorkers.addAll(this.zkWorkers.values());
        String minWorkerVer = this.config.getMinWorkerVersion();
        for (ZkWorker zkWorker : sortedWorkers) {
            if (!zkWorker.canRunTask(task) || !zkWorker.isValidVersion(minWorkerVer)) continue;
            return zkWorker;
        }
        log.debug("Worker nodes %s do not have capacity to run any more tasks!", new Object[]{this.zkWorkers.values()});
        return null;
    }

    private void taskComplete(RemoteTaskRunnerWorkItem taskRunnerWorkItem, ZkWorker zkWorker, TaskStatus taskStatus) {
        Preconditions.checkNotNull((Object)taskRunnerWorkItem, (Object)"taskRunnerWorkItem");
        Preconditions.checkNotNull((Object)taskStatus, (Object)"taskStatus");
        if (zkWorker != null) {
            log.info("Worker[%s] completed task[%s] with status[%s]", new Object[]{zkWorker.getWorker().getHost(), taskStatus.getId(), taskStatus.getStatusCode()});
            zkWorker.setLastCompletedTaskTime(new DateTime());
        } else {
            log.info("Workerless task[%s] completed with status[%s]", new Object[]{taskStatus.getId(), taskStatus.getStatusCode()});
        }
        this.completeTasks.put(taskStatus.getId(), taskRunnerWorkItem);
        this.runningTasks.remove(taskStatus.getId());
        taskRunnerWorkItem.setResult(taskStatus);
    }
}

