/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.db.DbConnector;
import io.druid.db.DbTablesConfig;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.NoneShardSpec;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class IndexerDBCoordinator {
    private static final Logger log = new Logger(IndexerDBCoordinator.class);
    private final ObjectMapper jsonMapper;
    private final DbTablesConfig dbTables;
    private final DbConnector dbConnector;

    @Inject
    public IndexerDBCoordinator(ObjectMapper jsonMapper, DbTablesConfig dbTables, DbConnector dbConnector) {
        this.jsonMapper = jsonMapper;
        this.dbTables = dbTables;
        this.dbConnector = dbConnector;
    }

    public List<DataSegment> getUsedSegmentsForInterval(final String dataSource, Interval interval) throws IOException {
        VersionedIntervalTimeline timeline = (VersionedIntervalTimeline)this.dbConnector.getDBI().withHandle((HandleCallback)new HandleCallback<VersionedIntervalTimeline<String, DataSegment>>(){

            public VersionedIntervalTimeline<String, DataSegment> withHandle(Handle handle) throws IOException {
                VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
                ResultIterator dbSegments = ((Query)handle.createQuery(String.format("SELECT payload FROM %s WHERE used = true AND dataSource = :dataSource", IndexerDBCoordinator.this.dbTables.getSegmentsTable())).bind("dataSource", dataSource)).iterator();
                while (dbSegments.hasNext()) {
                    Map dbSegment = (Map)dbSegments.next();
                    DataSegment segment = (DataSegment)IndexerDBCoordinator.this.jsonMapper.readValue((String)dbSegment.get("payload"), DataSegment.class);
                    timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)segment));
                }
                dbSegments.close();
                return timeline;
            }
        });
        List segments = Lists.transform((List)timeline.lookup(interval), (Function)new Function<TimelineObjectHolder<String, DataSegment>, DataSegment>(){

            public DataSegment apply(TimelineObjectHolder<String, DataSegment> input) {
                return (DataSegment)input.getObject().getChunk(0).getObject();
            }
        });
        return segments;
    }

    public Set<DataSegment> announceHistoricalSegments(final Set<DataSegment> segments) throws IOException {
        return (Set)this.dbConnector.getDBI().inTransaction((TransactionCallback)new TransactionCallback<Set<DataSegment>>(){

            public Set<DataSegment> inTransaction(Handle handle, TransactionStatus transactionStatus) throws IOException {
                HashSet inserted = Sets.newHashSet();
                for (DataSegment segment : segments) {
                    if (!IndexerDBCoordinator.this.announceHistoricalSegment(handle, segment)) continue;
                    inserted.add(segment);
                }
                return ImmutableSet.copyOf((Collection)inserted);
            }
        });
    }

    private boolean announceHistoricalSegment(Handle handle, DataSegment segment) throws IOException {
        block6: {
            try {
                if (this.segmentExists(handle, segment)) {
                    log.info("Found [%s] in DB, not updating DB", new Object[]{segment.getIdentifier()});
                    return false;
                }
                try {
                    ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(String.format(this.dbConnector.isPostgreSQL() ? "INSERT INTO %s (id, dataSource, created_date, start, \"end\", partitioned, version, used, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload)" : "INSERT INTO %s (id, dataSource, created_date, start, end, partitioned, version, used, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload)", this.dbTables.getSegmentsTable())).bind("id", segment.getIdentifier())).bind("dataSource", segment.getDataSource())).bind("created_date", new DateTime().toString())).bind("start", segment.getInterval().getStart().toString())).bind("end", segment.getInterval().getEnd().toString())).bind("partitioned", segment.getShardSpec() instanceof NoneShardSpec ? 0 : 1)).bind("version", segment.getVersion())).bind("used", true)).bind("payload", this.jsonMapper.writeValueAsString((Object)segment))).execute();
                    log.info("Published segment [%s] to DB", new Object[]{segment.getIdentifier()});
                }
                catch (Exception e) {
                    if (e.getCause() instanceof SQLException && this.segmentExists(handle, segment)) {
                        log.info("Found [%s] in DB, not updating DB", new Object[]{segment.getIdentifier()});
                        break block6;
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                log.error((Throwable)e, "Exception inserting into DB", new Object[0]);
                throw e;
            }
        }
        return true;
    }

    private boolean segmentExists(Handle handle, DataSegment segment) {
        List exists = ((Query)handle.createQuery(String.format("SELECT id FROM %s WHERE id = :identifier", this.dbTables.getSegmentsTable())).bind("identifier", segment.getIdentifier())).list();
        return !exists.isEmpty();
    }

    public void updateSegmentMetadata(final Set<DataSegment> segments) throws IOException {
        this.dbConnector.getDBI().inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                for (DataSegment segment : segments) {
                    IndexerDBCoordinator.this.updatePayload(handle, segment);
                }
                return null;
            }
        });
    }

    public void deleteSegments(final Set<DataSegment> segments) throws IOException {
        this.dbConnector.getDBI().inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws IOException {
                for (DataSegment segment : segments) {
                    IndexerDBCoordinator.this.deleteSegment(handle, segment);
                }
                return null;
            }
        });
    }

    private void deleteSegment(Handle handle, DataSegment segment) {
        ((Update)handle.createStatement(String.format("DELETE from %s WHERE id = :id", this.dbTables.getSegmentsTable())).bind("id", segment.getIdentifier())).execute();
    }

    private void updatePayload(Handle handle, DataSegment segment) throws IOException {
        try {
            ((Update)((Update)handle.createStatement(String.format("UPDATE %s SET payload = :payload WHERE id = :id", this.dbTables.getSegmentsTable())).bind("id", segment.getIdentifier())).bind("payload", this.jsonMapper.writeValueAsString((Object)segment))).execute();
        }
        catch (IOException e) {
            log.error((Throwable)e, "Exception inserting into DB", new Object[0]);
            throw e;
        }
    }

    public List<DataSegment> getUnusedSegmentsForInterval(final String dataSource, final Interval interval) {
        List matchingSegments = (List)this.dbConnector.getDBI().withHandle((HandleCallback)new HandleCallback<List<DataSegment>>(){

            public List<DataSegment> withHandle(Handle handle) throws IOException, SQLException {
                return (List)((Query)((Query)((Query)handle.createQuery(String.format(IndexerDBCoordinator.this.dbConnector.isPostgreSQL() ? "SELECT payload FROM %s WHERE dataSource = :dataSource and start >= :start and \"end\" <= :end and used = false" : "SELECT payload FROM %s WHERE dataSource = :dataSource and start >= :start and end <= :end and used = false", IndexerDBCoordinator.this.dbTables.getSegmentsTable())).bind("dataSource", dataSource)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).fold((Object)Lists.newArrayList(), (Folder3)new Folder3<List<DataSegment>, Map<String, Object>>(){

                    public List<DataSegment> fold(List<DataSegment> accumulator, Map<String, Object> stringObjectMap, FoldController foldController, StatementContext statementContext) throws SQLException {
                        try {
                            DataSegment segment = (DataSegment)IndexerDBCoordinator.this.jsonMapper.readValue((String)stringObjectMap.get("payload"), DataSegment.class);
                            accumulator.add(segment);
                            return accumulator;
                        }
                        catch (Exception e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                });
            }
        });
        log.info("Found %,d segments for %s for interval %s.", new Object[]{matchingSegments.size(), dataSource, interval});
        return matchingSegments;
    }
}

