/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.api.client.util.Lists;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.config.TaskStorageConfig;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskExistsException;
import io.druid.indexing.overlord.TaskStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class HeapMemoryTaskStorage
implements TaskStorage {
    private final TaskStorageConfig config;
    private final ReentrantLock giant = new ReentrantLock();
    private final Map<String, TaskStuff> tasks = Maps.newHashMap();
    private final Multimap<String, TaskLock> taskLocks = HashMultimap.create();
    private final Multimap<String, TaskAction> taskActions = ArrayListMultimap.create();
    private static final Logger log = new Logger(HeapMemoryTaskStorage.class);

    @Inject
    public HeapMemoryTaskStorage(TaskStorageConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Task task, TaskStatus status) throws TaskExistsException {
        this.giant.lock();
        try {
            Preconditions.checkNotNull((Object)task, (Object)"task");
            Preconditions.checkNotNull((Object)status, (Object)"status");
            Preconditions.checkArgument((boolean)task.getId().equals(status.getId()), (String)"Task/Status ID mismatch[%s/%s]", (Object[])new Object[]{task.getId(), status.getId()});
            if (this.tasks.containsKey(task.getId())) {
                throw new TaskExistsException(task.getId());
            }
            log.info("Inserting task %s with status: %s", new Object[]{task.getId(), status});
            this.tasks.put(task.getId(), new TaskStuff(task, status, new DateTime()));
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Task> getTask(String taskid) {
        this.giant.lock();
        try {
            Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
            if (this.tasks.containsKey(taskid)) {
                Optional optional = Optional.of((Object)this.tasks.get(taskid).getTask());
                return optional;
            }
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(TaskStatus status) {
        this.giant.lock();
        try {
            Preconditions.checkNotNull((Object)status, (Object)"status");
            String taskid = status.getId();
            Preconditions.checkState((boolean)this.tasks.containsKey(taskid), (String)"Task ID must already be present: %s", (Object[])new Object[]{taskid});
            Preconditions.checkState((boolean)this.tasks.get(taskid).getStatus().isRunnable(), (String)"Task status must be runnable: %s", (Object[])new Object[]{taskid});
            log.info("Updating task %s to status: %s", new Object[]{taskid, status});
            this.tasks.put(taskid, this.tasks.get(taskid).withStatus(status));
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<TaskStatus> getStatus(String taskid) {
        this.giant.lock();
        try {
            Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
            if (this.tasks.containsKey(taskid)) {
                Optional optional = Optional.of((Object)this.tasks.get(taskid).getStatus());
                return optional;
            }
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Task> getActiveTasks() {
        this.giant.lock();
        try {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (TaskStuff taskStuff : this.tasks.values()) {
                if (!taskStuff.getStatus().isRunnable()) continue;
                listBuilder.add((Object)taskStuff.getTask());
            }
            ImmutableList immutableList = listBuilder.build();
            return immutableList;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskStatus> getRecentlyFinishedTaskStatuses() {
        this.giant.lock();
        try {
            ArrayList returns = Lists.newArrayList();
            long recent = System.currentTimeMillis() - this.config.getRecentlyFinishedThreshold().getMillis();
            Ordering createdDateDesc = new Ordering<TaskStuff>(){

                public int compare(TaskStuff a, TaskStuff b) {
                    return a.getCreatedDate().compareTo((ReadableInstant)b.getCreatedDate());
                }
            }.reverse();
            for (TaskStuff taskStuff : createdDateDesc.sortedCopy(this.tasks.values())) {
                if (!taskStuff.getStatus().isComplete() || taskStuff.getCreatedDate().getMillis() <= recent) continue;
                returns.add(taskStuff.getStatus());
            }
            ArrayList arrayList = returns;
            return arrayList;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLock(String taskid, TaskLock taskLock) {
        this.giant.lock();
        try {
            Preconditions.checkNotNull((Object)taskLock, (Object)"taskLock");
            this.taskLocks.put((Object)taskid, (Object)taskLock);
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLock(String taskid, TaskLock taskLock) {
        this.giant.lock();
        try {
            Preconditions.checkNotNull((Object)taskLock, (Object)"taskLock");
            this.taskLocks.remove((Object)taskid, (Object)taskLock);
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskLock> getLocks(String taskid) {
        this.giant.lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf((Collection)this.taskLocks.get((Object)taskid));
            return immutableList;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addAuditLog(Task task, TaskAction<T> taskAction) {
        this.giant.lock();
        try {
            this.taskActions.put((Object)task.getId(), taskAction);
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskAction> getAuditLogs(String taskid) {
        this.giant.lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf((Collection)this.taskActions.get((Object)taskid));
            return immutableList;
        }
        finally {
            this.giant.unlock();
        }
    }

    private static class TaskStuff {
        final Task task;
        final TaskStatus status;
        final DateTime createdDate;

        private TaskStuff(Task task, TaskStatus status, DateTime createdDate) {
            Preconditions.checkNotNull((Object)task);
            Preconditions.checkNotNull((Object)status);
            Preconditions.checkArgument((boolean)task.getId().equals(status.getId()));
            this.task = task;
            this.status = status;
            this.createdDate = (DateTime)Preconditions.checkNotNull((Object)createdDate, (Object)"createdDate");
        }

        public Task getTask() {
            return this.task;
        }

        public TaskStatus getStatus() {
            return this.status;
        }

        public DateTime getCreatedDate() {
            return this.createdDate;
        }

        private TaskStuff withStatus(TaskStatus _status) {
            return new TaskStuff(this.task, _status, this.createdDate);
        }
    }
}

