/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.firehose;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.client.repackaged.com.google.common.base.Throwables;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.inject.Injector;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.YieldingAccumulator;
import com.metamx.common.parsers.ParseException;
import com.metamx.emitter.EmittingLogger;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.impl.InputRowParser;
import io.druid.granularity.QueryGranularity;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.TaskToolboxFactory;
import io.druid.indexing.common.actions.SegmentListUsedAction;
import io.druid.indexing.common.task.NoopTask;
import io.druid.query.filter.DimFilter;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.IndexIO;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.QueryableIndexStorageAdapter;
import io.druid.segment.StorageAdapter;
import io.druid.segment.TimestampColumnSelector;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.Filters;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.utils.Runnables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class IngestSegmentFirehoseFactory
implements FirehoseFactory<InputRowParser> {
    private static final EmittingLogger log = new EmittingLogger(IngestSegmentFirehoseFactory.class);
    private final String dataSource;
    private final Interval interval;
    private final DimFilter dimFilter;
    private final List<String> dimensions;
    private final List<String> metrics;
    private final Injector injector;

    @JsonCreator
    public IngestSegmentFirehoseFactory(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="metrics") List<String> metrics, @JacksonInject Injector injector) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.dataSource = dataSource;
        this.interval = interval;
        this.dimFilter = dimFilter;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.injector = injector;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public List<String> getMetrics() {
        return this.metrics;
    }

    public Firehose connect(InputRowParser inputRowParser) throws IOException, ParseException {
        log.info("Connecting firehose: dataSource[%s], interval[%s]", new Object[]{this.dataSource, this.interval});
        TaskToolbox toolbox = ((TaskToolboxFactory)this.injector.getInstance(TaskToolboxFactory.class)).build(new NoopTask("reingest", 0L, 0L, null, null));
        try {
            ArrayList metricsList;
            ArrayList dims;
            List<DataSegment> usedSegments = toolbox.getTaskActionClient().submit(new SegmentListUsedAction(this.dataSource, this.interval));
            final Map<DataSegment, File> segmentFileMap = toolbox.fetchSegments(usedSegments);
            VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural().nullsFirst());
            for (DataSegment segment : usedSegments) {
                timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)segment));
            }
            List timeLineSegments = timeline.lookup(this.interval);
            if (this.dimensions != null) {
                dims = this.dimensions;
            } else {
                HashSet dimSet = new HashSet();
                for (TimelineObjectHolder timelineObjectHolder : timeLineSegments) {
                    dimSet.addAll(((DataSegment)timelineObjectHolder.getObject().getChunk(0).getObject()).getDimensions());
                }
                dims = Lists.newArrayList(dimSet);
            }
            if (this.metrics != null) {
                metricsList = this.metrics;
            } else {
                HashSet metricsSet = new HashSet();
                for (TimelineObjectHolder timelineObjectHolder : timeLineSegments) {
                    metricsSet.addAll(((DataSegment)timelineObjectHolder.getObject().getChunk(0).getObject()).getDimensions());
                }
                metricsList = Lists.newArrayList(metricsSet);
            }
            List adapters = Lists.transform((List)timeLineSegments, (Function)new Function<TimelineObjectHolder<String, DataSegment>, StorageAdapter>(){

                public StorageAdapter apply(TimelineObjectHolder<String, DataSegment> input) {
                    DataSegment segment = (DataSegment)input.getObject().getChunk(0).getObject();
                    File file = (File)Preconditions.checkNotNull(segmentFileMap.get(segment), (String)"File for segment %s", (Object[])new Object[]{segment.getIdentifier()});
                    try {
                        return new QueryableIndexStorageAdapter(IndexIO.loadIndex((File)file));
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            });
            return new IngestSegmentFirehose(adapters, dims, metricsList);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (SegmentLoadingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public InputRowParser getParser() {
        return null;
    }

    public class IngestSegmentFirehose
    implements Firehose {
        private volatile Yielder<InputRow> rowYielder;

        public IngestSegmentFirehose(List<StorageAdapter> adapters, final List<String> dims, final List<String> metrics) {
            Sequence rows = Sequences.concat((Iterable)Iterables.transform(adapters, (Function)new Function<StorageAdapter, Sequence<InputRow>>(){

                @Nullable
                public Sequence<InputRow> apply(@Nullable StorageAdapter adapter) {
                    return Sequences.concat((Sequence)Sequences.map((Sequence)adapter.makeCursors(Filters.convertDimensionFilters((DimFilter)IngestSegmentFirehoseFactory.this.dimFilter), IngestSegmentFirehoseFactory.this.interval, QueryGranularity.ALL), (Function)new Function<Cursor, Sequence<InputRow>>(){

                        @Nullable
                        public Sequence<InputRow> apply(final @Nullable Cursor cursor) {
                            final TimestampColumnSelector timestampColumnSelector = cursor.makeTimestampColumnSelector();
                            final HashMap dimSelectors = Maps.newHashMap();
                            for (String dim : dims) {
                                DimensionSelector dimSelector = cursor.makeDimensionSelector(dim);
                                dimSelectors.put(dim, dimSelector);
                            }
                            final HashMap metSelectors = Maps.newHashMap();
                            for (String metric : metrics) {
                                ObjectColumnSelector metricSelector = cursor.makeObjectColumnSelector(metric);
                                metSelectors.put(metric, metricSelector);
                            }
                            return Sequences.simple((Iterable)new Iterable<InputRow>(){

                                @Override
                                public Iterator<InputRow> iterator() {
                                    return new Iterator<InputRow>(){

                                        @Override
                                        public boolean hasNext() {
                                            return !cursor.isDone();
                                        }

                                        @Override
                                        public InputRow next() {
                                            DimensionSelector selector;
                                            LinkedHashMap theEvent = Maps.newLinkedHashMap();
                                            long timestamp = timestampColumnSelector.getTimestamp();
                                            theEvent.put("timestamp", new DateTime(timestamp));
                                            for (Map.Entry dimSelector : dimSelectors.entrySet()) {
                                                String dim = (String)dimSelector.getKey();
                                                selector = (DimensionSelector)dimSelector.getValue();
                                                IndexedInts vals = selector.getRow();
                                                if (vals.size() == 1) {
                                                    String dimVal = selector.lookupName(vals.get(0));
                                                    theEvent.put(dim, dimVal);
                                                    continue;
                                                }
                                                ArrayList dimVals = Lists.newArrayList();
                                                for (int i = 0; i < vals.size(); ++i) {
                                                    dimVals.add(selector.lookupName(vals.get(i)));
                                                }
                                                theEvent.put(dim, dimVals);
                                            }
                                            for (Map.Entry metSelector : metSelectors.entrySet()) {
                                                String metric = (String)metSelector.getKey();
                                                selector = (ObjectColumnSelector)metSelector.getValue();
                                                theEvent.put(metric, selector.get());
                                            }
                                            cursor.advance();
                                            return new MapBasedInputRow(timestamp, dims, (Map)theEvent);
                                        }

                                        @Override
                                        public void remove() {
                                            throw new UnsupportedOperationException("Remove Not Supported");
                                        }
                                    };
                                }
                            });
                        }
                    }));
                }
            }));
            this.rowYielder = rows.toYielder(null, new YieldingAccumulator(){

                public Object accumulate(Object accumulated, Object in) {
                    this.yield();
                    return in;
                }
            });
        }

        public boolean hasMore() {
            return !this.rowYielder.isDone();
        }

        public InputRow nextRow() {
            InputRow inputRow = (InputRow)this.rowYielder.get();
            this.rowYielder = this.rowYielder.next(null);
            return inputRow;
        }

        public Runnable commit() {
            return Runnables.getNoopRunnable();
        }

        public void close() throws IOException {
            this.rowYielder.close();
        }
    }
}

