/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.metamx.common.Granularity;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.parsers.ParseException;
import com.metamx.emitter.EmittingLogger;
import com.metamx.metrics.Monitor;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.LockAcquireAction;
import io.druid.indexing.common.actions.LockReleaseAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AbstractTask;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.common.task.TaskResource;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.query.QueryToolChest;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeIOConfig;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.indexing.granularity.GranularitySpec;
import io.druid.segment.indexing.granularity.UniformGranularitySpec;
import io.druid.segment.realtime.FireDepartment;
import io.druid.segment.realtime.FireDepartmentConfig;
import io.druid.segment.realtime.RealtimeMetricsMonitor;
import io.druid.segment.realtime.Schema;
import io.druid.segment.realtime.SegmentPublisher;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.RealtimePlumberSchool;
import io.druid.segment.realtime.plumber.RejectionPolicyFactory;
import io.druid.segment.realtime.plumber.VersioningPolicy;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.timeline.DataSegment;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class RealtimeIndexTask
extends AbstractTask {
    private static final EmittingLogger log = new EmittingLogger(RealtimeIndexTask.class);
    @JsonIgnore
    private final FireDepartment spec;
    @JsonIgnore
    private volatile Plumber plumber = null;
    @JsonIgnore
    private volatile QueryRunnerFactoryConglomerate queryRunnerFactoryConglomerate = null;

    private static String makeTaskId(FireDepartment fireDepartment, Schema schema) {
        if (fireDepartment == null) {
            return String.format("index_realtime_%s_%d_%s", schema.getDataSource(), schema.getShardSpec().getPartitionNum(), new DateTime().toString());
        }
        return String.format("index_realtime_%s_%d_%s", fireDepartment.getDataSchema().getDataSource(), fireDepartment.getTuningConfig().getShardSpec().getPartitionNum(), new DateTime().toString());
    }

    private static String makeDatasource(FireDepartment fireDepartment, Schema schema) {
        return fireDepartment != null ? fireDepartment.getDataSchema().getDataSource() : schema.getDataSource();
    }

    @JsonCreator
    public RealtimeIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="spec") FireDepartment fireDepartment, @JsonProperty(value="schema") Schema spec, @JsonProperty(value="firehose") FirehoseFactory firehoseFactory, @JsonProperty(value="fireDepartmentConfig") FireDepartmentConfig fireDepartmentConfig, @JsonProperty(value="windowPeriod") Period windowPeriod, @JsonProperty(value="maxPendingPersists") int maxPendingPersists, @JsonProperty(value="segmentGranularity") Granularity segmentGranularity, @JsonProperty(value="rejectionPolicy") RejectionPolicyFactory rejectionPolicy, @JsonProperty(value="rejectionPolicyFactory") RejectionPolicyFactory rejectionPolicyFactory) {
        super(id == null ? RealtimeIndexTask.makeTaskId(fireDepartment, spec) : id, String.format("index_realtime_%s", RealtimeIndexTask.makeDatasource(fireDepartment, spec)), taskResource == null ? new TaskResource(RealtimeIndexTask.makeTaskId(fireDepartment, spec), 1) : taskResource, RealtimeIndexTask.makeDatasource(fireDepartment, spec));
        this.spec = fireDepartment != null ? fireDepartment : new FireDepartment(new DataSchema(spec.getDataSource(), firehoseFactory == null ? null : firehoseFactory.getParser(), spec.getAggregators(), (GranularitySpec)new UniformGranularitySpec(segmentGranularity, spec.getIndexGranularity(), null, segmentGranularity)), new RealtimeIOConfig(firehoseFactory, null), new RealtimeTuningConfig(fireDepartmentConfig == null ? null : Integer.valueOf(fireDepartmentConfig.getMaxRowsInMemory()), fireDepartmentConfig == null ? null : fireDepartmentConfig.getIntermediatePersistPeriod(), windowPeriod, null, null, rejectionPolicy == null ? rejectionPolicyFactory : rejectionPolicy, Integer.valueOf(maxPendingPersists), spec.getShardSpec()), null, null, null, null);
    }

    @Override
    public String getType() {
        return "index_realtime";
    }

    @Override
    public String getNodeType() {
        return "realtime";
    }

    @Override
    public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
        if (this.plumber != null) {
            QueryRunnerFactory factory = this.queryRunnerFactoryConglomerate.findFactory(query);
            QueryToolChest toolChest = factory.getToolchest();
            return new FinalizeResultsQueryRunner(this.plumber.getQueryRunner(query), toolChest);
        }
        return null;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatus run(final TaskToolbox toolbox) throws Exception {
        if (this.plumber != null) {
            throw new IllegalStateException("WTF?!? run with non-null plumber??!");
        }
        for (TaskLock taskLock : this.getTaskLocks(toolbox)) {
            toolbox.getTaskActionClient().submit(new LockReleaseAction(taskLock.getInterval()));
        }
        boolean normalExit = true;
        Period intermediatePersistPeriod = this.spec.getTuningConfig().getIntermediatePersistPeriod();
        Firehose firehose = this.spec.getIOConfig().getFirehoseFactory().connect(this.spec.getDataSchema().getParser());
        TaskActionSegmentPublisher segmentPublisher = new TaskActionSegmentPublisher(this, toolbox);
        DataSegmentAnnouncer lockingSegmentAnnouncer = new DataSegmentAnnouncer(){

            public void announceSegment(DataSegment segment) throws IOException {
                toolbox.getTaskActionClient().submit(new LockAcquireAction(segment.getInterval()));
                toolbox.getSegmentAnnouncer().announceSegment(segment);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unannounceSegment(DataSegment segment) throws IOException {
                try {
                    toolbox.getSegmentAnnouncer().unannounceSegment(segment);
                }
                finally {
                    toolbox.getTaskActionClient().submit(new LockReleaseAction(segment.getInterval()));
                }
            }

            public void announceSegments(Iterable<DataSegment> segments) throws IOException {
                for (DataSegment segment : segments) {
                    toolbox.getTaskActionClient().submit(new LockAcquireAction(segment.getInterval()));
                }
                toolbox.getSegmentAnnouncer().announceSegments(segments);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unannounceSegments(Iterable<DataSegment> segments) throws IOException {
                try {
                    toolbox.getSegmentAnnouncer().unannounceSegments(segments);
                }
                finally {
                    for (DataSegment segment : segments) {
                        toolbox.getTaskActionClient().submit(new LockReleaseAction(segment.getInterval()));
                    }
                }
            }
        };
        VersioningPolicy versioningPolicy = new VersioningPolicy(){

            public String getVersion(Interval interval) {
                try {
                    TaskLock myLock = toolbox.getTaskActionClient().submit(new LockAcquireAction(interval));
                    return myLock.getVersion();
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
        DataSchema dataSchema = this.spec.getDataSchema();
        RealtimeIOConfig realtimeIOConfig = this.spec.getIOConfig();
        RealtimeTuningConfig tuningConfig = this.spec.getTuningConfig().withBasePersistDirectory(new File(toolbox.getTaskWorkDir(), "persist")).withVersioningPolicy(versioningPolicy);
        FireDepartment fireDepartment = new FireDepartment(dataSchema, realtimeIOConfig, tuningConfig, null, null, null, null);
        RealtimeMetricsMonitor metricsMonitor = new RealtimeMetricsMonitor((List)ImmutableList.of((Object)fireDepartment));
        this.queryRunnerFactoryConglomerate = toolbox.getQueryRunnerFactoryConglomerate();
        RealtimePlumberSchool plumberSchool = new RealtimePlumberSchool(toolbox.getEmitter(), toolbox.getQueryRunnerFactoryConglomerate(), toolbox.getSegmentPusher(), lockingSegmentAnnouncer, (SegmentPublisher)segmentPublisher, toolbox.getNewSegmentServerView(), toolbox.getQueryExecutorService(), null, null, null, null, null, null, 0);
        this.plumber = plumberSchool.findPlumber(dataSchema, tuningConfig, fireDepartment.getMetrics());
        try {
            this.plumber.startJob();
            toolbox.getMonitorScheduler().addMonitor((Monitor)metricsMonitor);
            long nextFlush = new DateTime().plus((ReadablePeriod)intermediatePersistPeriod).getMillis();
            while (firehose.hasMore()) {
                try {
                    InputRow inputRow = firehose.nextRow();
                    if (inputRow == null) continue;
                    int currCount = this.plumber.add(inputRow);
                    if (currCount == -1) {
                        fireDepartment.getMetrics().incrementThrownAway();
                        log.debug("Throwing away event[%s]", new Object[]{inputRow});
                        if (System.currentTimeMillis() <= nextFlush) continue;
                        this.plumber.persist(firehose.commit());
                        nextFlush = new DateTime().plus((ReadablePeriod)intermediatePersistPeriod).getMillis();
                        continue;
                    }
                    fireDepartment.getMetrics().incrementProcessed();
                    if (currCount < tuningConfig.getMaxRowsInMemory() && System.currentTimeMillis() <= nextFlush) continue;
                    this.plumber.persist(firehose.commit());
                    nextFlush = new DateTime().plus((ReadablePeriod)intermediatePersistPeriod).getMillis();
                }
                catch (ParseException e) {
                    log.warn((Throwable)e, "unparseable line", new Object[0]);
                    fireDepartment.getMetrics().incrementUnparseable();
                }
            }
        }
        catch (Throwable e) {
            normalExit = false;
            log.makeAlert(e, "Exception aborted realtime processing[%s]", new Object[]{dataSchema.getDataSource()}).emit();
            throw e;
        }
        finally {
            if (normalExit) {
                try {
                    this.plumber.persist(firehose.commit());
                    this.plumber.finishJob();
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to finish realtime task", new Object[0]).emit();
                }
                finally {
                    CloseQuietly.close((Closeable)firehose);
                    toolbox.getMonitorScheduler().removeMonitor((Monitor)metricsMonitor);
                }
            }
        }
        return TaskStatus.success(this.getId());
    }

    @JsonProperty(value="spec")
    public FireDepartment getRealtimeIngestionSchema() {
        return this.spec;
    }

    public static class TaskActionSegmentPublisher
    implements SegmentPublisher {
        final Task task;
        final TaskToolbox taskToolbox;

        public TaskActionSegmentPublisher(Task task, TaskToolbox taskToolbox) {
            this.task = task;
            this.taskToolbox = taskToolbox;
        }

        public void publishSegment(DataSegment segment) throws IOException {
            this.taskToolbox.pushSegments((Iterable<DataSegment>)ImmutableList.of((Object)segment));
        }
    }
}

