/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Ints;
import com.metamx.common.ISE;
import com.metamx.common.guava.Comparators;
import com.metamx.common.logger.Logger;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.granularity.QueryGranularity;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.index.YeOldePlumberSchool;
import io.druid.indexing.common.task.AbstractFixedIntervalTask;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.IOConfig;
import io.druid.segment.indexing.IngestionSpec;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.indexing.TuningConfig;
import io.druid.segment.indexing.granularity.GranularitySpec;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.HashBasedNumberedShardSpec;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.ShardSpec;
import io.druid.timeline.partition.SingleDimensionShardSpec;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexTask
extends AbstractFixedIntervalTask {
    private static final Logger log = new Logger(IndexTask.class);
    @JsonIgnore
    private final IndexIngestionSpec ingestionSchema;
    private final ObjectMapper jsonMapper;

    private static String makeId(String id, IndexIngestionSpec ingestionSchema, String dataSource) {
        if (id == null) {
            return String.format("index_%s_%s", IndexTask.makeDataSource(ingestionSchema, dataSource), new DateTime().toString());
        }
        return id;
    }

    private static String makeDataSource(IndexIngestionSpec ingestionSchema, String dataSource) {
        if (ingestionSchema != null) {
            return ingestionSchema.getDataSchema().getDataSource();
        }
        return dataSource;
    }

    private static Interval makeInterval(IndexIngestionSpec ingestionSchema, GranularitySpec granularitySpec) {
        GranularitySpec spec = ingestionSchema != null ? ingestionSchema.getDataSchema().getGranularitySpec() : granularitySpec;
        return new Interval((ReadableInstant)((Interval)((SortedSet)spec.bucketIntervals().get()).first()).getStart(), (ReadableInstant)((Interval)((SortedSet)spec.bucketIntervals().get()).last()).getEnd());
    }

    @JsonCreator
    public IndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="schema") IndexIngestionSpec ingestionSchema, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="granularitySpec") GranularitySpec granularitySpec, @JsonProperty(value="aggregators") AggregatorFactory[] aggregators, @JsonProperty(value="indexGranularity") QueryGranularity indexGranularity, @JsonProperty(value="targetPartitionSize") int targetPartitionSize, @JsonProperty(value="firehose") FirehoseFactory firehoseFactory, @JsonProperty(value="rowFlushBoundary") int rowFlushBoundary, @JacksonInject ObjectMapper jsonMapper) {
        super(IndexTask.makeId(id, ingestionSchema, dataSource), IndexTask.makeDataSource(ingestionSchema, dataSource), IndexTask.makeInterval(ingestionSchema, granularitySpec));
        this.ingestionSchema = ingestionSchema != null ? ingestionSchema : new IndexIngestionSpec(new DataSchema(dataSource, firehoseFactory.getParser(), aggregators, granularitySpec.withQueryGranularity(indexGranularity == null ? QueryGranularity.NONE : indexGranularity)), new IndexIOConfig(firehoseFactory), new IndexTuningConfig(targetPartitionSize, rowFlushBoundary, null));
        this.jsonMapper = jsonMapper;
    }

    @Override
    public String getType() {
        return "index";
    }

    @JsonProperty(value="schema")
    public IndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        int targetPartitionSize = this.ingestionSchema.getTuningConfig().getTargetPartitionSize();
        TaskLock myLock = (TaskLock)Iterables.getOnlyElement(this.getTaskLocks(toolbox));
        HashSet segments = Sets.newHashSet();
        Sets.SetView validIntervals = Sets.intersection((Set)((Set)granularitySpec.bucketIntervals().get()), this.getDataIntervals());
        if (validIntervals.isEmpty()) {
            throw new ISE("No valid data intervals found. Check your configs!", new Object[0]);
        }
        for (Interval bucket : validIntervals) {
            ArrayList shardSpecs;
            if (targetPartitionSize > 0) {
                shardSpecs = this.determinePartitions(bucket, targetPartitionSize);
            } else {
                int numShards = this.ingestionSchema.getTuningConfig().getNumShards();
                if (numShards > 0) {
                    shardSpecs = Lists.newArrayList();
                    for (int i = 0; i < numShards; ++i) {
                        shardSpecs.add(new HashBasedNumberedShardSpec(i, numShards, this.jsonMapper));
                    }
                } else {
                    shardSpecs = ImmutableList.of((Object)new NoneShardSpec());
                }
            }
            for (ShardSpec shardSpec : shardSpecs) {
                DataSegment segment = this.generateSegment(toolbox, this.ingestionSchema.getDataSchema(), shardSpec, bucket, myLock.getVersion());
                segments.add(segment);
            }
        }
        toolbox.pushSegments(segments);
        return TaskStatus.success(this.getId());
    }

    private SortedSet<Interval> getDataIntervals() throws IOException {
        FirehoseFactory firehoseFactory = this.ingestionSchema.getIOConfig().getFirehoseFactory();
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        TreeSet retVal = Sets.newTreeSet((Comparator)Comparators.intervalsByStartThenEnd());
        try (Firehose firehose = firehoseFactory.connect(this.ingestionSchema.getDataSchema().getParser());){
            while (firehose.hasMore()) {
                InputRow inputRow = firehose.nextRow();
                Interval interval = granularitySpec.getSegmentGranularity().bucket(new DateTime(inputRow.getTimestampFromEpoch()));
                retVal.add(interval);
            }
        }
        return retVal;
    }

    private List<ShardSpec> determinePartitions(Interval interval, int targetPartitionSize) throws IOException {
        log.info("Determining partitions for interval[%s] with targetPartitionSize[%d]", new Object[]{interval, targetPartitionSize});
        FirehoseFactory firehoseFactory = this.ingestionSchema.getIOConfig().getFirehoseFactory();
        HashSet unusableDimensions = Sets.newHashSet();
        HashMap dimensionValueMultisets = Maps.newHashMap();
        try (Firehose firehose = firehoseFactory.connect(this.ingestionSchema.getDataSchema().getParser());){
            while (firehose.hasMore()) {
                InputRow inputRow = firehose.nextRow();
                if (!interval.contains(inputRow.getTimestampFromEpoch())) continue;
                for (String dim : inputRow.getDimensions()) {
                    List dimValues = inputRow.getDimension(dim);
                    if (unusableDimensions.contains(dim)) continue;
                    if (dimValues.size() == 1) {
                        TreeMultiset dimensionValueMultiset = (TreeMultiset)dimensionValueMultisets.get(dim);
                        if (dimensionValueMultiset == null) {
                            dimensionValueMultiset = TreeMultiset.create();
                            dimensionValueMultisets.put(dim, dimensionValueMultiset);
                        }
                        dimensionValueMultiset.add(dimValues.get(0));
                        continue;
                    }
                    unusableDimensions.add(dim);
                    dimensionValueMultisets.remove(dim);
                }
            }
        }
        ArrayList shardSpecs = Lists.newArrayList();
        Ordering<Map.Entry<String, TreeMultiset<String>>> byCardinalityOrdering = new Ordering<Map.Entry<String, TreeMultiset<String>>>(){

            public int compare(Map.Entry<String, TreeMultiset<String>> left, Map.Entry<String, TreeMultiset<String>> right) {
                return Ints.compare((int)left.getValue().elementSet().size(), (int)right.getValue().elementSet().size());
            }
        };
        if (dimensionValueMultisets.isEmpty()) {
            log.info("No suitable partition dimension found", new Object[0]);
            shardSpecs.add(new NoneShardSpec());
        } else {
            Map.Entry partitionEntry = (Map.Entry)byCardinalityOrdering.max(dimensionValueMultisets.entrySet());
            String partitionDim = (String)partitionEntry.getKey();
            TreeMultiset partitionDimValues = (TreeMultiset)partitionEntry.getValue();
            log.info("Partitioning on dimension[%s] with cardinality[%d] over rows[%d]", new Object[]{partitionDim, partitionDimValues.elementSet().size(), partitionDimValues.size()});
            String currentPartitionStart = null;
            int currentPartitionSize = 0;
            for (String partitionDimValue : partitionDimValues.elementSet()) {
                if ((currentPartitionSize += partitionDimValues.count((Object)partitionDimValue)) < targetPartitionSize) continue;
                SingleDimensionShardSpec shardSpec = new SingleDimensionShardSpec(partitionDim, currentPartitionStart, partitionDimValue, shardSpecs.size());
                log.info("Adding shard: %s", new Object[]{shardSpec});
                shardSpecs.add(shardSpec);
                currentPartitionSize = partitionDimValues.count((Object)partitionDimValue);
                currentPartitionStart = partitionDimValue;
            }
            if (currentPartitionSize > 0) {
                Object shardSpec = shardSpecs.isEmpty() ? new NoneShardSpec() : new SingleDimensionShardSpec(partitionDim, currentPartitionStart, null, shardSpecs.size());
                log.info("Adding shard: %s", new Object[]{shardSpec});
                shardSpecs.add(shardSpec);
            }
        }
        return shardSpecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSegment generateSegment(final TaskToolbox toolbox, DataSchema schema, ShardSpec shardSpec, Interval interval, String version) throws IOException {
        File tmpDir = new File(toolbox.getTaskWorkDir(), String.format("%s_%s_%s_%s_%s", this.getDataSource(), interval.getStart(), interval.getEnd(), version, shardSpec.getPartitionNum()));
        FirehoseFactory firehoseFactory = this.ingestionSchema.getIOConfig().getFirehoseFactory();
        int rowFlushBoundary = this.ingestionSchema.getTuningConfig().getRowFlushBoundary();
        final CopyOnWriteArrayList pushedSegments = new CopyOnWriteArrayList();
        DataSegmentPusher wrappedDataSegmentPusher = new DataSegmentPusher(){

            public String getPathForHadoop(String dataSource) {
                return toolbox.getSegmentPusher().getPathForHadoop(dataSource);
            }

            public DataSegment push(File file, DataSegment segment) throws IOException {
                DataSegment pushedSegment = toolbox.getSegmentPusher().push(file, segment);
                pushedSegments.add(pushedSegment);
                return pushedSegment;
            }
        };
        FireDepartmentMetrics metrics = new FireDepartmentMetrics();
        Firehose firehose = firehoseFactory.connect(this.ingestionSchema.getDataSchema().getParser());
        Plumber plumber = new YeOldePlumberSchool(interval, version, wrappedDataSegmentPusher, tmpDir).findPlumber(schema, new RealtimeTuningConfig(null, null, null, null, null, null, null, shardSpec), metrics);
        int myRowFlushBoundary = rowFlushBoundary > 0 ? rowFlushBoundary : toolbox.getConfig().getDefaultRowFlushBoundary();
        try {
            plumber.startJob();
            while (firehose.hasMore()) {
                InputRow inputRow = firehose.nextRow();
                if (this.shouldIndex(shardSpec, interval, inputRow)) {
                    int numRows = plumber.add(inputRow);
                    if (numRows == -1) {
                        throw new ISE(String.format("Was expecting non-null sink for timestamp[%s]", new DateTime(inputRow.getTimestampFromEpoch())), new Object[0]);
                    }
                    metrics.incrementProcessed();
                    if (numRows < myRowFlushBoundary) continue;
                    plumber.persist(firehose.commit());
                    continue;
                }
                metrics.incrementThrownAway();
            }
        }
        finally {
            firehose.close();
        }
        plumber.persist(firehose.commit());
        try {
            plumber.finishJob();
        }
        catch (Throwable throwable) {
            log.info("Task[%s] interval[%s] partition[%d] took in %,d rows (%,d processed, %,d unparseable, %,d thrown away) and output %,d rows", new Object[]{this.getId(), interval, shardSpec.getPartitionNum(), metrics.processed() + metrics.unparseable() + metrics.thrownAway(), metrics.processed(), metrics.unparseable(), metrics.thrownAway(), metrics.rowOutput()});
            throw throwable;
        }
        log.info("Task[%s] interval[%s] partition[%d] took in %,d rows (%,d processed, %,d unparseable, %,d thrown away) and output %,d rows", new Object[]{this.getId(), interval, shardSpec.getPartitionNum(), metrics.processed() + metrics.unparseable() + metrics.thrownAway(), metrics.processed(), metrics.unparseable(), metrics.thrownAway(), metrics.rowOutput()});
        return (DataSegment)Iterables.getOnlyElement(pushedSegments);
    }

    private boolean shouldIndex(ShardSpec shardSpec, Interval interval, InputRow inputRow) {
        return interval.contains(inputRow.getTimestampFromEpoch()) && shardSpec.isInChunk(inputRow);
    }

    @JsonTypeName(value="index")
    public static class IndexTuningConfig
    implements TuningConfig {
        private static final int DEFAULT_TARGET_PARTITION_SIZE = 5000000;
        private static final int DEFAULT_ROW_FLUSH_BOUNDARY = 500000;
        private final int targetPartitionSize;
        private final int rowFlushBoundary;
        private final int numShards;

        @JsonCreator
        public IndexTuningConfig(@JsonProperty(value="targetPartitionSize") int targetPartitionSize, @JsonProperty(value="rowFlushBoundary") int rowFlushBoundary, @JsonProperty(value="numShards") @Nullable Integer numShards) {
            this.targetPartitionSize = targetPartitionSize == 0 ? 5000000 : targetPartitionSize;
            this.rowFlushBoundary = rowFlushBoundary == 0 ? 500000 : rowFlushBoundary;
            this.numShards = numShards == null ? -1 : numShards;
            Preconditions.checkArgument((this.targetPartitionSize == -1 || this.numShards == -1 ? 1 : 0) != 0, (Object)"targetPartitionsSize and shardCount both cannot be set");
        }

        @JsonProperty
        public int getTargetPartitionSize() {
            return this.targetPartitionSize;
        }

        @JsonProperty
        public int getRowFlushBoundary() {
            return this.rowFlushBoundary;
        }

        @JsonProperty
        public int getNumShards() {
            return this.numShards;
        }
    }

    @JsonTypeName(value="index")
    public static class IndexIOConfig
    implements IOConfig {
        private final FirehoseFactory firehoseFactory;

        @JsonCreator
        public IndexIOConfig(@JsonProperty(value="firehose") FirehoseFactory firehoseFactory) {
            this.firehoseFactory = firehoseFactory;
        }

        @JsonProperty(value="firehose")
        public FirehoseFactory getFirehoseFactory() {
            return this.firehoseFactory;
        }
    }

    public static class IndexIngestionSpec
    extends IngestionSpec<IndexIOConfig, IndexTuningConfig> {
        private final DataSchema dataSchema;
        private final IndexIOConfig ioConfig;
        private final IndexTuningConfig tuningConfig;

        @JsonCreator
        public IndexIngestionSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="ioConfig") IndexIOConfig ioConfig, @JsonProperty(value="tuningConfig") IndexTuningConfig tuningConfig) {
            super(dataSchema, (IOConfig)ioConfig, (TuningConfig)tuningConfig);
            this.dataSchema = dataSchema;
            this.ioConfig = ioConfig;
            this.tuningConfig = tuningConfig == null ? new IndexTuningConfig(0, 0, null) : tuningConfig;
        }

        @JsonProperty(value="dataSchema")
        public DataSchema getDataSchema() {
            return this.dataSchema;
        }

        @JsonProperty(value="ioConfig")
        public IndexIOConfig getIOConfig() {
            return this.ioConfig;
        }

        @JsonProperty(value="tuningConfig")
        public IndexTuningConfig getTuningConfig() {
            return this.tuningConfig;
        }
    }
}

