/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.logger.Logger;
import io.druid.granularity.QueryGranularity;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.task.AbstractFixedIntervalTask;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexAdapter;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.ShardSpec;
import java.io.File;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class DeleteTask
extends AbstractFixedIntervalTask {
    private static final Logger log = new Logger(DeleteTask.class);

    @JsonCreator
    public DeleteTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval) {
        super(id != null ? id : String.format("delete_%s_%s_%s_%s", dataSource, interval.getStart(), interval.getEnd(), new DateTime().toString()), dataSource, (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval"));
    }

    @Override
    public String getType() {
        return "delete";
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        TaskLock myLock = (TaskLock)Iterables.getOnlyElement(this.getTaskLocks(toolbox));
        IncrementalIndex empty = new IncrementalIndex(0L, QueryGranularity.NONE, new AggregatorFactory[0]);
        IncrementalIndexAdapter emptyAdapter = new IncrementalIndexAdapter(this.getInterval(), empty);
        DataSegment segment = DataSegment.builder().dataSource(this.getDataSource()).interval(this.getInterval()).version(myLock.getVersion()).shardSpec((ShardSpec)new NoneShardSpec()).build();
        File outDir = new File(toolbox.getTaskWorkDir(), segment.getIdentifier());
        File fileToUpload = IndexMerger.merge((List)Lists.newArrayList((Object[])new IndexableAdapter[]{emptyAdapter}), (AggregatorFactory[])new AggregatorFactory[0], (File)outDir);
        DataSegment uploadedSegment = toolbox.getSegmentPusher().push(fileToUpload, segment);
        log.info("Uploaded tombstone segment for[%s] interval[%s] with version[%s]", new Object[]{segment.getDataSource(), segment.getInterval(), segment.getVersion()});
        toolbox.pushSegments((Iterable<DataSegment>)ImmutableList.of((Object)uploadedSegment));
        return TaskStatus.success(this.getId());
    }
}

