/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.druid.indexing.common.task.MergeTaskBase;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.QueryableIndexIndexableAdapter;
import io.druid.segment.Rowboat;
import io.druid.segment.RowboatFilteringIndexAdapter;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class AppendTask
extends MergeTaskBase {
    @JsonCreator
    public AppendTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="segments") List<DataSegment> segments) {
        super(id, dataSource, segments);
    }

    @Override
    public File merge(final Map<DataSegment, File> segments, File outDir) throws Exception {
        VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural().nullsFirst());
        for (DataSegment segment : segments.keySet()) {
            timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)segment));
        }
        List segmentsToMerge = Lists.transform((List)timeline.lookup(new Interval((Object)"1000-01-01/3000-01-01")), (Function)new Function<TimelineObjectHolder<String, DataSegment>, SegmentToMergeHolder>(){

            public SegmentToMergeHolder apply(TimelineObjectHolder<String, DataSegment> input) {
                DataSegment segment = (DataSegment)input.getObject().getChunk(0).getObject();
                File file = (File)Preconditions.checkNotNull(segments.get(segment), (String)"File for segment %s", (Object[])new Object[]{segment.getIdentifier()});
                return new SegmentToMergeHolder(segment, input.getInterval(), file);
            }
        });
        ArrayList adapters = Lists.newArrayList();
        for (final SegmentToMergeHolder holder : segmentsToMerge) {
            adapters.add(new RowboatFilteringIndexAdapter((IndexableAdapter)new QueryableIndexIndexableAdapter(IndexIO.loadIndex((File)holder.getFile())), (Predicate)new Predicate<Rowboat>(){

                public boolean apply(@Nullable Rowboat input) {
                    return holder.getInterval().contains(input.getTimestamp());
                }
            }));
        }
        return IndexMerger.append((List)adapters, (File)outDir);
    }

    @Override
    public String getType() {
        return "append";
    }

    private class SegmentToMergeHolder {
        private final DataSegment segment;
        private final Interval interval;
        private final File file;

        private SegmentToMergeHolder(DataSegment segment, Interval interval, File file) {
            this.segment = segment;
            this.interval = interval;
            this.file = file;
        }

        public DataSegment getSegment() {
            return this.segment;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public File getFile() {
            return this.file;
        }
    }
}

