/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.LockListAction;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.common.task.TaskResource;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import java.io.IOException;

public abstract class AbstractTask
implements Task {
    private static final Joiner ID_JOINER = Joiner.on((String)"_");
    @JsonIgnore
    private final String id;
    @JsonIgnore
    private final String groupId;
    @JsonIgnore
    private final TaskResource taskResource;
    @JsonIgnore
    private final String dataSource;

    protected AbstractTask(String id, String dataSource) {
        this(id, id, new TaskResource(id, 1), dataSource);
    }

    protected AbstractTask(String id, String groupId, String dataSource) {
        this(id, groupId, new TaskResource(id, 1), dataSource);
    }

    protected AbstractTask(String id, String groupId, TaskResource taskResource, String dataSource) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.groupId = (String)Preconditions.checkNotNull((Object)groupId, (Object)"groupId");
        this.taskResource = (TaskResource)Preconditions.checkNotNull((Object)taskResource, (Object)"resource");
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource.toLowerCase(), (Object)"dataSource");
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="resource")
    public TaskResource getTaskResource() {
        return this.taskResource;
    }

    @Override
    public String getNodeType() {
        return null;
    }

    @Override
    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
        return null;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("type", (Object)this.getType()).add("dataSource", (Object)this.dataSource).toString();
    }

    public static String joinId(Object ... objects) {
        return ID_JOINER.join(objects);
    }

    public TaskStatus success() {
        return TaskStatus.success(this.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTask that = (AbstractTask)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected Iterable<TaskLock> getTaskLocks(TaskToolbox toolbox) throws IOException {
        return toolbox.getTaskActionClient().submit(new LockListAction());
    }
}

