/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.index;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.metamx.common.Granularity;
import com.metamx.common.logger.Logger;
import io.druid.data.input.InputRow;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.QueryableIndex;
import io.druid.segment.SegmentUtils;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.FireHydrant;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.PlumberSchool;
import io.druid.segment.realtime.plumber.Sink;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.joda.time.Interval;

@JsonTypeName(value="historical")
public class YeOldePlumberSchool
implements PlumberSchool {
    private final Interval interval;
    private final String version;
    private final DataSegmentPusher dataSegmentPusher;
    private final File tmpSegmentDir;
    private static final Logger log = new Logger(YeOldePlumberSchool.class);

    @JsonCreator
    public YeOldePlumberSchool(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JacksonInject(value="segmentPusher") DataSegmentPusher dataSegmentPusher, @JacksonInject(value="tmpSegmentDir") File tmpSegmentDir) {
        this.interval = interval;
        this.version = version;
        this.dataSegmentPusher = dataSegmentPusher;
        this.tmpSegmentDir = tmpSegmentDir;
    }

    public Granularity getSegmentGranularity() {
        throw new UnsupportedOperationException();
    }

    public Plumber findPlumber(final DataSchema schema, RealtimeTuningConfig config, final FireDepartmentMetrics metrics) {
        final Sink theSink = new Sink(this.interval, schema, config, this.version);
        final File persistDir = new File(this.tmpSegmentDir, theSink.getSegment().getIdentifier());
        final HashSet spilled = Sets.newHashSet();
        return new Plumber(){

            public void startJob() {
            }

            public int add(InputRow row) {
                Sink sink = this.getSink(row.getTimestampFromEpoch());
                if (sink == null) {
                    return -1;
                }
                return sink.add(row);
            }

            public Sink getSink(long timestamp) {
                if (theSink.getInterval().contains(timestamp)) {
                    return theSink;
                }
                return null;
            }

            public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
                throw new UnsupportedOperationException("Don't query me, bro.");
            }

            public void persist(Runnable commitRunnable) {
                this.spillIfSwappable();
                commitRunnable.run();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void finishJob() {
                File fileToUpload = null;
                try {
                    Preconditions.checkState((!theSink.swappable() ? 1 : 0) != 0, (Object)"All data must be persisted before fininshing the job!");
                    if (spilled.size() == 0) {
                        throw new IllegalStateException("Nothing indexed?");
                    }
                    if (spilled.size() == 1) {
                        fileToUpload = (File)Iterables.getOnlyElement((Iterable)spilled);
                    } else {
                        ArrayList indexes = Lists.newArrayList();
                        for (File oneSpill : spilled) {
                            indexes.add(IndexIO.loadIndex((File)oneSpill));
                        }
                        fileToUpload = new File(YeOldePlumberSchool.this.tmpSegmentDir, "merged");
                        IndexMerger.mergeQueryableIndex((List)indexes, (AggregatorFactory[])schema.getAggregators(), (File)fileToUpload);
                    }
                    QueryableIndex mappedSegment = IndexIO.loadIndex((File)fileToUpload);
                    DataSegment segmentToUpload = theSink.getSegment().withDimensions((List)ImmutableList.copyOf((Iterable)mappedSegment.getAvailableDimensions())).withBinaryVersion(SegmentUtils.getVersionFromDir((File)fileToUpload));
                    YeOldePlumberSchool.this.dataSegmentPusher.push(fileToUpload, segmentToUpload);
                    log.info("Uploaded segment[%s]", new Object[]{segmentToUpload.getIdentifier()});
                }
                catch (Exception e) {
                    try {
                        log.warn((Throwable)e, "Failed to merge and upload", new Object[0]);
                        throw Throwables.propagate((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fileToUpload == null) throw throwable;
                            log.info("Deleting Index File[%s]", new Object[]{fileToUpload});
                            FileUtils.deleteDirectory(fileToUpload);
                            throw throwable;
                        }
                        catch (IOException e2) {
                            log.warn((Throwable)e2, "Error deleting directory[%s]", new Object[]{fileToUpload});
                        }
                        throw throwable;
                    }
                }
                try {
                    if (fileToUpload == null) return;
                    log.info("Deleting Index File[%s]", new Object[]{fileToUpload});
                    FileUtils.deleteDirectory((File)fileToUpload);
                    return;
                }
                catch (IOException e) {
                    log.warn((Throwable)e, "Error deleting directory[%s]", new Object[]{fileToUpload});
                    return;
                }
            }

            private void spillIfSwappable() {
                if (theSink.swappable()) {
                    FireHydrant indexToPersist = theSink.swap();
                    int rowsToPersist = indexToPersist.getIndex().size();
                    File dirToPersist = this.getSpillDir(indexToPersist.getCount());
                    log.info("Spilling index[%d] with rows[%d] to: %s", new Object[]{indexToPersist.getCount(), rowsToPersist, dirToPersist});
                    try {
                        IndexMerger.persist((IncrementalIndex)indexToPersist.getIndex(), (File)dirToPersist);
                        indexToPersist.swapSegment(null);
                        metrics.incrementRowOutputCount((long)rowsToPersist);
                        spilled.add(dirToPersist);
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e, "Failed to spill index[%d]", new Object[]{indexToPersist.getCount()});
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }

            private File getSpillDir(int n) {
                return new File(persistDir, String.format("spill%d", n));
            }
        };
    }
}

