/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.task.Task;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.List;
import org.joda.time.Interval;

public class SegmentListUnusedAction
implements TaskAction<List<DataSegment>> {
    @JsonIgnore
    private final String dataSource;
    @JsonIgnore
    private final Interval interval;

    @JsonCreator
    public SegmentListUnusedAction(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval) {
        this.dataSource = dataSource;
        this.interval = interval;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public TypeReference<List<DataSegment>> getReturnTypeReference() {
        return new TypeReference<List<DataSegment>>(){};
    }

    @Override
    public List<DataSegment> perform(Task task, TaskActionToolbox toolbox) throws IOException {
        return toolbox.getIndexerDBCoordinator().getUnusedSegmentsForInterval(this.dataSource, this.interval);
    }

    @Override
    public boolean isAudited() {
        return false;
    }

    public String toString() {
        return "SegmentListUnusedAction{dataSource='" + this.dataSource + '\'' + ", interval=" + this.interval + '}';
    }
}

