/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableSet;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.task.Task;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.Set;

public class SegmentInsertAction
implements TaskAction<Set<DataSegment>> {
    @JsonIgnore
    private final Set<DataSegment> segments;
    @JsonIgnore
    private final boolean allowOlderVersions;

    public SegmentInsertAction(Set<DataSegment> segments) {
        this(segments, false);
    }

    @JsonCreator
    public SegmentInsertAction(@JsonProperty(value="segments") Set<DataSegment> segments, @JsonProperty(value="allowOlderVersions") boolean allowOlderVersions) {
        this.segments = ImmutableSet.copyOf(segments);
        this.allowOlderVersions = allowOlderVersions;
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public boolean isAllowOlderVersions() {
        return this.allowOlderVersions;
    }

    public SegmentInsertAction withAllowOlderVersions(boolean _allowOlderVersions) {
        return new SegmentInsertAction(this.segments, _allowOlderVersions);
    }

    @Override
    public TypeReference<Set<DataSegment>> getReturnTypeReference() {
        return new TypeReference<Set<DataSegment>>(){};
    }

    @Override
    public Set<DataSegment> perform(Task task, TaskActionToolbox toolbox) throws IOException {
        toolbox.verifyTaskLocksAndSinglePartitionSettitude(task, this.segments, true);
        Set<DataSegment> retVal = toolbox.getIndexerDBCoordinator().announceHistoricalSegments(this.segments);
        ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder().setUser2(task.getDataSource()).setUser4(task.getType());
        for (DataSegment segment : this.segments) {
            metricBuilder.setUser5(segment.getInterval().toString());
            toolbox.getEmitter().emit(metricBuilder.build("indexer/segment/bytes", (Number)segment.getSize()));
        }
        return retVal;
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    public String toString() {
        return "SegmentInsertAction{segments=" + this.segments + '}';
    }
}

