/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.metrics.MonitorScheduler;
import io.druid.client.FilteredServerView;
import io.druid.indexing.common.actions.SegmentInsertAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.indexing.common.task.Task;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.segment.loading.DataSegmentArchiver;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.segment.loading.DataSegmentMover;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.loading.SegmentLoader;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.joda.time.Interval;

public class TaskToolbox {
    private final TaskConfig config;
    private final Task task;
    private final TaskActionClientFactory taskActionClientFactory;
    private final ServiceEmitter emitter;
    private final DataSegmentPusher segmentPusher;
    private final DataSegmentKiller dataSegmentKiller;
    private final DataSegmentArchiver dataSegmentArchiver;
    private final DataSegmentMover dataSegmentMover;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final FilteredServerView newSegmentServerView;
    private final QueryRunnerFactoryConglomerate queryRunnerFactoryConglomerate;
    private final MonitorScheduler monitorScheduler;
    private final ExecutorService queryExecutorService;
    private final SegmentLoader segmentLoader;
    private final ObjectMapper objectMapper;
    private final File taskWorkDir;

    public TaskToolbox(TaskConfig config, Task task, TaskActionClientFactory taskActionClientFactory, ServiceEmitter emitter, DataSegmentPusher segmentPusher, DataSegmentKiller dataSegmentKiller, DataSegmentMover dataSegmentMover, DataSegmentArchiver dataSegmentArchiver, DataSegmentAnnouncer segmentAnnouncer, FilteredServerView newSegmentServerView, QueryRunnerFactoryConglomerate queryRunnerFactoryConglomerate, ExecutorService queryExecutorService, MonitorScheduler monitorScheduler, SegmentLoader segmentLoader, ObjectMapper objectMapper, File taskWorkDir) {
        this.config = config;
        this.task = task;
        this.taskActionClientFactory = taskActionClientFactory;
        this.emitter = emitter;
        this.segmentPusher = segmentPusher;
        this.dataSegmentKiller = dataSegmentKiller;
        this.dataSegmentMover = dataSegmentMover;
        this.dataSegmentArchiver = dataSegmentArchiver;
        this.segmentAnnouncer = segmentAnnouncer;
        this.newSegmentServerView = newSegmentServerView;
        this.queryRunnerFactoryConglomerate = queryRunnerFactoryConglomerate;
        this.queryExecutorService = queryExecutorService;
        this.monitorScheduler = monitorScheduler;
        this.segmentLoader = segmentLoader;
        this.objectMapper = objectMapper;
        this.taskWorkDir = taskWorkDir;
    }

    public TaskConfig getConfig() {
        return this.config;
    }

    public TaskActionClient getTaskActionClient() {
        return this.taskActionClientFactory.create(this.task);
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public DataSegmentPusher getSegmentPusher() {
        return this.segmentPusher;
    }

    public DataSegmentKiller getDataSegmentKiller() {
        return this.dataSegmentKiller;
    }

    public DataSegmentMover getDataSegmentMover() {
        return this.dataSegmentMover;
    }

    public DataSegmentArchiver getDataSegmentArchiver() {
        return this.dataSegmentArchiver;
    }

    public DataSegmentAnnouncer getSegmentAnnouncer() {
        return this.segmentAnnouncer;
    }

    public FilteredServerView getNewSegmentServerView() {
        return this.newSegmentServerView;
    }

    public QueryRunnerFactoryConglomerate getQueryRunnerFactoryConglomerate() {
        return this.queryRunnerFactoryConglomerate;
    }

    public ExecutorService getQueryExecutorService() {
        return this.queryExecutorService;
    }

    public MonitorScheduler getMonitorScheduler() {
        return this.monitorScheduler;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Map<DataSegment, File> fetchSegments(List<DataSegment> segments) throws SegmentLoadingException {
        LinkedHashMap retVal = Maps.newLinkedHashMap();
        for (DataSegment segment : segments) {
            retVal.put(segment, this.segmentLoader.getSegmentFiles(segment));
        }
        return retVal;
    }

    public void pushSegments(Iterable<DataSegment> segments) throws IOException {
        ImmutableListMultimap segmentMultimap = Multimaps.index(segments, (Function)new Function<DataSegment, Interval>(){

            public Interval apply(DataSegment segment) {
                return segment.getInterval();
            }
        });
        for (Collection segmentCollection : segmentMultimap.asMap().values()) {
            this.getTaskActionClient().submit(new SegmentInsertAction((Set<DataSegment>)ImmutableSet.copyOf((Collection)segmentCollection)));
        }
    }

    public File getTaskWorkDir() {
        return this.taskWorkDir;
    }
}

