/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class TaskStatus {
    private final String id;
    private final Status status;
    private final long duration;

    public static TaskStatus running(String taskId) {
        return new TaskStatus(taskId, Status.RUNNING, -1L);
    }

    public static TaskStatus success(String taskId) {
        return new TaskStatus(taskId, Status.SUCCESS, -1L);
    }

    public static TaskStatus failure(String taskId) {
        return new TaskStatus(taskId, Status.FAILED, -1L);
    }

    public static TaskStatus fromCode(String taskId, Status code) {
        return new TaskStatus(taskId, code, -1L);
    }

    @JsonCreator
    private TaskStatus(@JsonProperty(value="id") String id, @JsonProperty(value="status") Status status, @JsonProperty(value="duration") long duration) {
        this.id = id;
        this.status = status;
        this.duration = duration;
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkNotNull((Object)((Object)status), (Object)"status");
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="status")
    public Status getStatusCode() {
        return this.status;
    }

    @JsonProperty(value="duration")
    public long getDuration() {
        return this.duration;
    }

    @JsonIgnore
    public boolean isRunnable() {
        return this.status == Status.RUNNING;
    }

    @JsonIgnore
    public boolean isComplete() {
        return !this.isRunnable();
    }

    @JsonIgnore
    public boolean isSuccess() {
        return this.status == Status.SUCCESS;
    }

    @JsonIgnore
    public boolean isFailure() {
        return this.status == Status.FAILED;
    }

    public TaskStatus withDuration(long _duration) {
        return new TaskStatus(this.id, this.status, _duration);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("status", (Object)this.status).add("duration", this.duration).toString();
    }

    public static enum Status {
        RUNNING,
        SUCCESS,
        FAILED;

    }
}

