/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.smile.async;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer;
import com.fasterxml.jackson.core.sym.Name;
import com.fasterxml.jackson.dataformat.smile.PackageVersion;
import com.fasterxml.jackson.dataformat.smile.SmileBufferRecycler;
import com.fasterxml.jackson.dataformat.smile.SmileConstants;
import com.fasterxml.jackson.dataformat.smile.SmileParser;
import com.fasterxml.jackson.dataformat.smile.SmileUtil;
import com.fasterxml.jackson.dataformat.smile.async.NonBlockingInputFeeder;
import com.fasterxml.jackson.dataformat.smile.async.NonBlockingParser;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.Arrays;

public class NonBlockingParserImpl
extends ParserBase
implements NonBlockingParser,
NonBlockingInputFeeder {
    private static final byte[] NO_BYTES = new byte[0];
    private static final int[] NO_INTS = new int[0];
    private static final String[] NO_STRINGS = new String[0];
    protected static final int STATE_INITIAL = 0;
    protected static final int STATE_HEADER = 1;
    protected static final int STATE_TOKEN_COMPLETE = 2;
    protected static final int STATE_NUMBER_INT = 10;
    protected static final int STATE_NUMBER_LONG = 11;
    protected static final int STATE_NUMBER_BIGINT = 12;
    protected static final int STATE_NUMBER_FLOAT = 13;
    protected static final int STATE_NUMBER_DOUBLE = 14;
    protected static final int STATE_NUMBER_BIGDEC = 15;
    protected static final int STATE_SHORT_ASCII = 20;
    protected static final int STATE_SHORT_UNICODE = 21;
    protected static final int STATE_LONG_ASCII = 22;
    protected static final int STATE_LONG_UNICODE = 23;
    protected static final int STATE_LONG_SHARED = 24;
    protected static final int STATE_RAW_BINARY = 25;
    protected static final int STATE_QUOTED_BINARY = 26;
    protected ObjectCodec _objectCodec;
    protected boolean _mayContainRawBinary;
    protected final boolean _cfgRequireHeader;
    protected final SmileBufferRecycler<String> _smileBufferRecycler;
    protected byte[] _inputBuffer = NO_BYTES;
    protected int _origBufferLen;
    protected int _state;
    protected int _substate;
    protected boolean _tokenIncomplete;
    protected boolean _got32BitFloat;
    protected int _pendingInt;
    protected long _pendingLong;
    protected boolean _endOfInput = false;
    protected final BytesToNameCanonicalizer _symbols;
    protected int[] _quadBuffer = NO_INTS;
    protected int _quadCount;
    protected int _currQuad;
    protected int _currQuadBytes = 0;
    protected String[] _seenNames = NO_STRINGS;
    protected int _seenNameCount = 0;
    protected String[] _seenStringValues = null;
    protected int _seenStringValueCount = -1;
    protected static final ThreadLocal<SoftReference<SmileBufferRecycler<String>>> _smileRecyclerRef = new ThreadLocal();
    private int _quad1;
    private int _quad2;

    public NonBlockingParserImpl(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, BytesToNameCanonicalizer bytesToNameCanonicalizer) {
        super(iOContext, n);
        this._objectCodec = objectCodec;
        this._symbols = bytesToNameCanonicalizer;
        this._tokenInputRow = -1;
        this._tokenInputCol = -1;
        this._smileBufferRecycler = NonBlockingParserImpl._smileBufferRecycler();
        this._currToken = JsonToken.NOT_AVAILABLE;
        this._state = 0;
        this._tokenIncomplete = true;
        this._cfgRequireHeader = (n2 & SmileParser.Feature.REQUIRE_HEADER.getMask()) != 0;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    protected boolean handleSignature(boolean bl, boolean bl2) throws IOException, JsonParseException {
        byte by;
        int n;
        if (bl) {
            ++this._inputPtr;
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (this._inputBuffer[this._inputPtr] != 41) {
            if (bl2) {
                this._reportError("Malformed content: signature not valid, starts with 0x3a but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr]) + ", not 0x29");
            }
            return false;
        }
        if (++this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (this._inputBuffer[this._inputPtr] != 10) {
            if (bl2) {
                this._reportError("Malformed content: signature not valid, starts with 0x3a, 0x29, but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr]) + ", not 0xA");
            }
            return false;
        }
        if (++this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n = (by = this._inputBuffer[this._inputPtr++]) >> 4 & 0xF) != 0) {
            this._reportError("Header version number bits (0x" + Integer.toHexString(n) + ") indicate unrecognized version; only 0x0 handled by parser");
        }
        if ((by & 1) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        }
        if ((by & 2) != 0) {
            this._seenStringValues = NO_STRINGS;
            this._seenStringValueCount = 0;
        }
        this._mayContainRawBinary = (by & 4) != 0;
        return true;
    }

    protected static final SmileBufferRecycler<String> _smileBufferRecycler() {
        SmileBufferRecycler<String> smileBufferRecycler;
        SoftReference<SmileBufferRecycler<String>> softReference = _smileRecyclerRef.get();
        SmileBufferRecycler<String> smileBufferRecycler2 = smileBufferRecycler = softReference == null ? null : softReference.get();
        if (smileBufferRecycler == null) {
            smileBufferRecycler = new SmileBufferRecycler();
            _smileRecyclerRef.set(new SoftReference<SmileBufferRecycler<String>>(smileBufferRecycler));
        }
        return smileBufferRecycler;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public int releaseBuffered(OutputStream outputStream) throws IOException {
        int n = this._inputEnd - this._inputPtr;
        if (n < 1) {
            return 0;
        }
        int n2 = this._inputPtr;
        outputStream.write(this._inputBuffer, n2, n);
        return n;
    }

    public Object getInputSource() {
        return null;
    }

    public JsonLocation getTokenLocation() {
        return new JsonLocation(this._ioContext.getSourceReference(), this._tokenInputTotal, -1L, -1, (int)this._tokenInputTotal);
    }

    public JsonLocation getCurrentLocation() {
        long l = this._currInputProcessed + (long)this._inputPtr;
        return new JsonLocation(this._ioContext.getSourceReference(), l, -1L, -1, (int)l);
    }

    protected final boolean loadMore() throws IOException {
        this._throwInternal();
        return false;
    }

    protected final boolean _loadToHaveAtLeast(int n) throws IOException {
        this._throwInternal();
        return false;
    }

    protected void _closeInput() throws IOException {
    }

    protected void _finishString() throws IOException, JsonParseException {
        this._throwInternal();
    }

    public void close() throws IOException {
        super.close();
        this._symbols.release();
    }

    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    protected void _releaseBuffers() throws IOException {
        super._releaseBuffers();
        Object[] objectArray = this._seenNames;
        if (objectArray != null && objectArray.length > 0) {
            this._seenNames = null;
            if (this._seenNameCount > 0) {
                Arrays.fill(objectArray, 0, this._seenNameCount, null);
            }
            this._smileBufferRecycler.releaseSeenNamesBuffer((String[])objectArray);
        }
        if ((objectArray = this._seenStringValues) != null && objectArray.length > 0) {
            this._seenStringValues = null;
            if (this._seenStringValueCount > 0) {
                Arrays.fill(objectArray, 0, this._seenStringValueCount, null);
            }
            this._smileBufferRecycler.releaseSeenStringValuesBuffer((String[])objectArray);
        }
    }

    public boolean mayContainRawBinary() {
        return this._mayContainRawBinary;
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            return this._finishToken();
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
        this._binaryValue = null;
        if (this._parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
            this._currToken = this._handleFieldName();
            return this._currToken;
        }
        if (this._inputPtr >= this._inputEnd) {
            return JsonToken.NOT_AVAILABLE;
        }
        byte by = this._inputBuffer[this._inputPtr++];
        block0 : switch (by >> 5 & 7) {
            case 0: {
                if (by == 0) {
                    this._reportError("Invalid token byte 0x00");
                }
                return this._handleSharedString(by - 1);
            }
            case 1: {
                this._numTypesValid = 0;
                switch (by & 0x1F) {
                    case 0: {
                        this._textBuffer.resetWithEmpty();
                        this._currToken = JsonToken.VALUE_STRING;
                        return this._currToken;
                    }
                    case 1: {
                        this._currToken = JsonToken.VALUE_NULL;
                        return this._currToken;
                    }
                    case 2: {
                        this._currToken = JsonToken.VALUE_FALSE;
                        return this._currToken;
                    }
                    case 3: {
                        this._currToken = JsonToken.VALUE_TRUE;
                        return this._currToken;
                    }
                    case 4: {
                        this._state = 10;
                        return this._nextInt(0, 0);
                    }
                    case 5: {
                        this._numberLong = 0L;
                        this._state = 11;
                        return this._nextLong(0, 0L);
                    }
                    case 6: {
                        this._state = 12;
                        return this._nextBigInt(0);
                    }
                    case 7: {
                        break block0;
                    }
                    case 8: {
                        this._pendingInt = 0;
                        this._state = 13;
                        this._got32BitFloat = true;
                        return this._nextFloat(0, 0);
                    }
                    case 9: {
                        this._pendingLong = 0L;
                        this._state = 14;
                        this._got32BitFloat = false;
                        return this._nextDouble(0, 0L);
                    }
                    case 10: {
                        this._state = 15;
                        return this._nextBigDecimal(0);
                    }
                    case 11: {
                        break block0;
                    }
                    case 26: {
                        if (!this._handleHeader(0)) {
                            return JsonToken.NOT_AVAILABLE;
                        }
                        if (this._currToken == null) {
                            return this.nextToken();
                        }
                        this._currToken = null;
                        return null;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                return this._nextShortAscii(0);
            }
            case 4: 
            case 5: {
                this._currToken = JsonToken.VALUE_STRING;
                if (this._seenStringValueCount >= 0) {
                    this._addSeenStringValue();
                } else {
                    this._tokenIncomplete = true;
                }
                return this._nextShortUnicode(0);
            }
            case 6: {
                this._numberInt = SmileUtil.zigzagDecode(by & 0x1F);
                this._numTypesValid = 1;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            case 7: {
                switch (by & 0x1F) {
                    case 0: {
                        return this._nextLongAscii(0);
                    }
                    case 4: {
                        return this._nextLongUnicode(0);
                    }
                    case 8: {
                        return this._nextQuotedBinary(0);
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        return this._nextLongSharedString(0);
                    }
                    case 24: {
                        this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
                        this._currToken = JsonToken.START_ARRAY;
                        return this._currToken;
                    }
                    case 25: {
                        if (!this._parsingContext.inArray()) {
                            this._reportMismatchedEndMarker(93, '}');
                        }
                        this._parsingContext = this._parsingContext.getParent();
                        this._currToken = JsonToken.END_ARRAY;
                        return this._currToken;
                    }
                    case 26: {
                        this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                        this._currToken = JsonToken.START_OBJECT;
                        return this._currToken;
                    }
                    case 27: {
                        this._reportError("Invalid type marker byte 0xFB in value mode (would be END_OBJECT in key mode)");
                    }
                    case 29: {
                        return this._nextRawBinary(0);
                    }
                    case 31: {
                        this._currToken = null;
                        return null;
                    }
                }
            }
        }
        this._reportError("Invalid type marker byte 0x" + Integer.toHexString(by & 0xFF) + " for expected value token");
        return null;
    }

    private final JsonToken _handleSharedString(int n) throws IOException, JsonParseException {
        if (n >= this._seenStringValueCount) {
            this._reportInvalidSharedStringValue(n);
        }
        this._textBuffer.resetWithString(this._seenStringValues[n]);
        this._currToken = JsonToken.VALUE_STRING;
        return this._currToken;
    }

    private final void _addSeenStringValue() throws IOException, JsonParseException {
        this._finishToken();
        if (this._seenStringValueCount < this._seenStringValues.length) {
            this._seenStringValues[this._seenStringValueCount++] = this._textBuffer.contentsAsString();
            return;
        }
        this._expandSeenStringValues();
    }

    private final void _expandSeenStringValues() {
        String[] stringArray;
        String[] stringArray2 = this._seenStringValues;
        int n = stringArray2.length;
        if (n == 0) {
            stringArray = this._smileBufferRecycler.allocSeenStringValuesBuffer();
            if (stringArray == null) {
                stringArray = new String[64];
            }
        } else if (n == 1024) {
            stringArray = stringArray2;
            this._seenStringValueCount = 0;
        } else {
            int n2 = n == 64 ? 256 : 1024;
            stringArray = new String[n2];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
        }
        this._seenStringValues = stringArray;
        this._seenStringValues[this._seenStringValueCount++] = this._textBuffer.contentsAsString();
    }

    public String getCurrentName() throws IOException, JsonParseException {
        return this._parsingContext.getCurrentName();
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        if (this._got32BitFloat) {
            return JsonParser.NumberType.FLOAT;
        }
        return super.getNumberType();
    }

    @Override
    public final boolean needMoreInput() {
        return this._inputPtr >= this._inputEnd && !this._endOfInput;
    }

    @Override
    public void feedInput(byte[] byArray, int n, int n2) throws IOException {
        if (this._inputPtr < this._inputEnd) {
            throw new IOException("Still have " + (this._inputEnd - this._inputPtr) + " undecoded bytes, should not call 'feedInput'");
        }
        if (this._endOfInput) {
            throw new IOException("Already closed, can not feed more input");
        }
        this._currInputProcessed += (long)this._origBufferLen;
        this._currInputRowStart -= this._origBufferLen;
        this._inputBuffer = byArray;
        this._inputPtr = n;
        this._inputEnd = n + n2;
        this._origBufferLen = n2;
    }

    @Override
    public void endOfInput() {
        this._endOfInput = true;
    }

    @Override
    public JsonToken peekNextToken() throws IOException, JsonParseException {
        if (!this._tokenIncomplete) {
            return JsonToken.NOT_AVAILABLE;
        }
        switch (this._state) {
            case 0: {
                return JsonToken.NOT_AVAILABLE;
            }
            case 1: {
                return JsonToken.NOT_AVAILABLE;
            }
            case 10: 
            case 11: {
                return JsonToken.VALUE_NUMBER_INT;
            }
            case 13: 
            case 14: 
            case 15: {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
        }
        throw new IllegalStateException("Internal error: unknown 'state', " + this._state);
    }

    private final JsonToken _nextInt(int n, int n2) throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd) {
            byte by;
            if ((by = this._inputBuffer[this._inputPtr++]) < 0) {
                n2 = n2 << 6 | by & 0x3F;
                this._numberInt = SmileUtil.zigzagDecode(n2);
                this._numTypesValid = 1;
                this._tokenIncomplete = false;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            if (++n >= 5) {
                this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
            }
            n2 = n2 << 7 | by;
        }
        this._tokenIncomplete = true;
        this._substate = n;
        this._pendingInt = n2;
        this._state = 10;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextLong(int n, long l) throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd) {
            byte by;
            if ((by = this._inputBuffer[this._inputPtr++]) < 0) {
                l = l << 6 | (long)(by & 0x3F);
                this._numberLong = SmileUtil.zigzagDecode(l);
                this._numTypesValid = 2;
                this._tokenIncomplete = false;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            if (++n >= 10) {
                this._reportError("Corrupt input; 64-bit VInt extends beyond 10 data bytes");
            }
            l = l << 7 | (long)by;
        }
        this._tokenIncomplete = true;
        this._substate = n;
        this._pendingLong = l;
        this._state = 11;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextBigInt(int n) throws IOException, JsonParseException {
        this._tokenIncomplete = true;
        this._substate = n;
        this._state = 15;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextFloat(int n, int n2) throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd) {
            byte by = this._inputBuffer[this._inputPtr++];
            n2 = (n2 << 7) + by;
            if (++n != 5) continue;
            this._numberDouble = Float.intBitsToFloat(n2);
            this._numTypesValid = 8;
            this._tokenIncomplete = false;
            this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
            return this._currToken;
        }
        this._tokenIncomplete = true;
        this._substate = n;
        this._pendingInt = n2;
        this._state = 13;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextDouble(int n, long l) throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd) {
            byte by = this._inputBuffer[this._inputPtr++];
            l = (l << 7) + (long)by;
            if (++n != 10) continue;
            this._numberDouble = Double.longBitsToDouble(l);
            this._numTypesValid = 8;
            this._tokenIncomplete = false;
            this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
            return this._currToken;
        }
        this._tokenIncomplete = true;
        this._substate = n;
        this._pendingLong = l;
        this._state = 14;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextBigDecimal(int n) throws IOException, JsonParseException {
        this._tokenIncomplete = true;
        this._substate = n;
        this._state = 15;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final boolean _handleHeader(int n) throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd) {
            byte by = this._inputBuffer[this._inputPtr++];
            switch (n) {
                case 0: {
                    if (by == 41) break;
                    this._reportError("Malformed content: header signature not valid, starts with 0x3a but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr] & 0xFF) + ", not 0x29");
                    break;
                }
                case 1: {
                    if (by == 10) break;
                    this._reportError("Malformed content: signature not valid, starts with 0x3a, 0x29, but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr & 0xFF]) + ", not 0x0A");
                    break;
                }
                case 2: {
                    int n2 = by >> 4 & 0xF;
                    if (n2 != 0) {
                        this._reportError("Header version number bits (0x" + Integer.toHexString(n2) + ") indicate unrecognized version; only 0x0 handled by parser");
                    }
                    if ((by & 1) == 0) {
                        this._seenNames = null;
                        this._seenNameCount = -1;
                    }
                    if ((by & 2) != 0) {
                        this._seenStringValues = NO_STRINGS;
                        this._seenStringValueCount = 0;
                    }
                    this._mayContainRawBinary = (by & 4) != 0;
                    this._tokenIncomplete = false;
                    return true;
                }
            }
        }
        this._tokenIncomplete = true;
        this._state = 1;
        this._substate = n;
        return false;
    }

    private final JsonToken _nextShortAscii(int n) throws IOException, JsonParseException {
        this._state = 20;
        this._tokenIncomplete = true;
        this._substate = n;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextShortUnicode(int n) throws IOException, JsonParseException {
        this._state = 21;
        this._tokenIncomplete = true;
        this._substate = n;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextLongAscii(int n) throws IOException, JsonParseException {
        this._state = 22;
        this._tokenIncomplete = true;
        this._substate = n;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextLongUnicode(int n) throws IOException, JsonParseException {
        this._state = 23;
        this._tokenIncomplete = true;
        this._substate = n;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextLongSharedString(int n) throws IOException, JsonParseException {
        this._tokenIncomplete = true;
        this._state = 24;
        this._substate = n;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextRawBinary(int n) throws IOException, JsonParseException {
        this._tokenIncomplete = true;
        this._state = 25;
        this._substate = n;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextQuotedBinary(int n) throws IOException, JsonParseException {
        this._tokenIncomplete = true;
        this._state = 26;
        this._substate = n;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    public String getText() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        if (this._tokenIncomplete) {
            return null;
        }
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return null;
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this._parsingContext.getCurrentName();
        }
        if (jsonToken.isNumeric()) {
            return this.getNumberValue().toString();
        }
        return this._currToken.asString();
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case VALUE_STRING: {
                    return this._textBuffer.getTextBuffer();
                }
                case FIELD_NAME: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n);
                        } else if (this._nameCopyBuffer.length < n) {
                            this._nameCopyBuffer = new char[n];
                        }
                        string.getChars(0, n, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().toCharArray();
                }
            }
            if (this._tokenIncomplete) {
                return null;
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    public int getTextLength() throws IOException, JsonParseException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                return -1;
            }
            switch (this._currToken) {
                case VALUE_STRING: {
                    return this._textBuffer.size();
                }
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().length();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().length();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + this._currToken + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        return this._binaryValue;
    }

    public Object getEmbeddedObject() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException, JsonParseException {
        throw new UnsupportedOperationException();
    }

    protected final JsonToken _handleFieldName() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int n = this._inputBuffer[this._inputPtr++];
        switch (n >> 6 & 3) {
            case 0: {
                switch (n) {
                    case 32: {
                        this._parsingContext.setCurrentName("");
                        return JsonToken.FIELD_NAME;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        int n2;
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((n2 = ((n & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                            this._reportInvalidSharedName(n2);
                        }
                        this._parsingContext.setCurrentName(this._seenNames[n2]);
                        return JsonToken.FIELD_NAME;
                    }
                    case 52: {
                        this._handleLongFieldName();
                        return JsonToken.FIELD_NAME;
                    }
                }
                break;
            }
            case 1: {
                int n3 = n & 0x3F;
                if (n3 >= this._seenNameCount) {
                    this._reportInvalidSharedName(n3);
                }
                this._parsingContext.setCurrentName(this._seenNames[n3]);
                return JsonToken.FIELD_NAME;
            }
            case 2: {
                String string;
                int n4 = 1 + (n & 0x3F);
                Name name = this._findDecodedFromSymbols(n4);
                if (name != null) {
                    string = name.getName();
                    this._inputPtr += n4;
                } else {
                    string = this._decodeShortAsciiName(n4);
                    string = this._addDecodedToSymbols(n4, string);
                }
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = string;
                }
                this._parsingContext.setCurrentName(string);
                return JsonToken.FIELD_NAME;
            }
            case 3: {
                String string;
                if ((n &= 0x3F) > 55) {
                    if (n != 59) break;
                    if (!this._parsingContext.inObject()) {
                        this._reportMismatchedEndMarker(125, ']');
                    }
                    this._parsingContext = this._parsingContext.getParent();
                    return JsonToken.END_OBJECT;
                }
                int n5 = n + 2;
                Name name = this._findDecodedFromSymbols(n5);
                if (name != null) {
                    string = name.getName();
                    this._inputPtr += n5;
                } else {
                    string = this._decodeShortUnicodeName(n5);
                    string = this._addDecodedToSymbols(n5, string);
                }
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = string;
                }
                this._parsingContext.setCurrentName(string);
                return JsonToken.FIELD_NAME;
            }
        }
        this._reportError("Invalid type marker byte 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr - 1]) + " for expected field name (or END_OBJECT marker)");
        return null;
    }

    private final String[] _expandSeenNames(String[] stringArray) {
        String[] stringArray2;
        int n = stringArray.length;
        if (n == 0) {
            stringArray2 = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (stringArray2 == null) {
                stringArray2 = new String[64];
            }
        } else if (n == 1024) {
            stringArray2 = stringArray;
            this._seenNameCount = 0;
        } else {
            int n2 = n == 64 ? 256 : 1024;
            stringArray2 = new String[n2];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        }
        return stringArray2;
    }

    private final String _addDecodedToSymbols(int n, String string) {
        if (n < 5) {
            return this._symbols.addName(string, this._quad1, 0).getName();
        }
        if (n < 9) {
            return this._symbols.addName(string, this._quad1, this._quad2).getName();
        }
        int n2 = n + 3 >> 2;
        return this._symbols.addName(string, this._quadBuffer, n2).getName();
    }

    private final String _decodeShortAsciiName(int n) throws IOException, JsonParseException {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = 0;
        byte[] byArray = this._inputBuffer;
        int n3 = this._inputPtr;
        int n4 = n3 + n - 3;
        while (n3 < n4) {
            cArray[n2++] = (char)byArray[n3++];
            cArray[n2++] = (char)byArray[n3++];
            cArray[n2++] = (char)byArray[n3++];
            cArray[n2++] = (char)byArray[n3++];
        }
        n4 = n & 3;
        if (n4 > 0) {
            cArray[n2++] = (char)byArray[n3++];
            if (n4 > 1) {
                cArray[n2++] = (char)byArray[n3++];
                if (n4 > 2) {
                    cArray[n2++] = (char)byArray[n3++];
                }
            }
        }
        this._inputPtr = n3;
        this._textBuffer.setCurrentLength(n);
        return this._textBuffer.contentsAsString();
    }

    private final String _decodeShortUnicodeName(int n) throws IOException, JsonParseException {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n3 = this._inputPtr;
        this._inputPtr += n;
        int[] nArray = SmileConstants.sUtf8UnitLengths;
        byte[] byArray = this._inputBuffer;
        int n4 = n3 + n;
        while (n3 < n4) {
            int n5;
            int n6;
            if ((n6 = nArray[n5 = byArray[n3++] & 0xFF]) != 0) {
                switch (n6) {
                    case 1: {
                        n5 = (n5 & 0x1F) << 6 | byArray[n3++] & 0x3F;
                        break;
                    }
                    case 2: {
                        n5 = (n5 & 0xF) << 12 | (byArray[n3++] & 0x3F) << 6 | byArray[n3++] & 0x3F;
                        break;
                    }
                    case 3: {
                        n5 = (n5 & 7) << 18 | (byArray[n3++] & 0x3F) << 12 | (byArray[n3++] & 0x3F) << 6 | byArray[n3++] & 0x3F;
                        cArray[n2++] = (char)(0xD800 | (n5 -= 65536) >> 10);
                        n5 = 0xDC00 | n5 & 0x3FF;
                        break;
                    }
                    default: {
                        this._reportError("Invalid byte " + Integer.toHexString(n5) + " in short Unicode text block");
                    }
                }
            }
            cArray[n2++] = (char)n5;
        }
        this._textBuffer.setCurrentLength(n2);
        return this._textBuffer.contentsAsString();
    }

    private final Name _decodeLongUnicodeName(int[] nArray, int n, int n2) throws IOException, JsonParseException {
        int n3;
        int n4 = n & 3;
        if (n4 < 4) {
            n3 = nArray[n2 - 1];
            nArray[n2 - 1] = n3 << (4 - n4 << 3);
        } else {
            n3 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            int n7 = nArray[n6 >> 2];
            int n8 = n6 & 3;
            n7 = n7 >> (3 - n8 << 3) & 0xFF;
            ++n6;
            if (n7 > 127) {
                int n9;
                if ((n7 & 0xE0) == 192) {
                    n7 &= 0x1F;
                    n9 = 1;
                } else if ((n7 & 0xF0) == 224) {
                    n7 &= 0xF;
                    n9 = 2;
                } else if ((n7 & 0xF8) == 240) {
                    n7 &= 7;
                    n9 = 3;
                } else {
                    this._reportInvalidInitial(n7);
                    n7 = 1;
                    n9 = 1;
                }
                if (n6 + n9 > n) {
                    this._reportInvalidEOF(" in long field name");
                }
                int n10 = nArray[n6 >> 2];
                n8 = n6 & 3;
                ++n6;
                if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(n10);
                }
                n7 = n7 << 6 | n10 & 0x3F;
                if (n9 > 1) {
                    n10 = nArray[n6 >> 2];
                    n8 = n6 & 3;
                    ++n6;
                    if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(n10);
                    }
                    n7 = n7 << 6 | n10 & 0x3F;
                    if (n9 > 2) {
                        n10 = nArray[n6 >> 2];
                        n8 = n6 & 3;
                        ++n6;
                        if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(n10 & 0xFF);
                        }
                        n7 = n7 << 6 | n10 & 0x3F;
                    }
                }
                if (n9 > 2) {
                    n7 -= 65536;
                    if (n5 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n5++] = (char)(55296 + (n7 >> 10));
                    n7 = 0xDC00 | n7 & 0x3FF;
                }
            }
            if (n5 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n5++] = (char)n7;
        }
        String string = new String(cArray, 0, n5);
        if (n4 < 4) {
            nArray[n2 - 1] = n3;
        }
        return this._symbols.addName(string, nArray, n2);
    }

    private final void _handleLongFieldName() throws IOException, JsonParseException {
        Name name;
        int n;
        byte[] byArray = this._inputBuffer;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (n = byArray[this._inputPtr++])) {
                n3 = 0;
                break;
            }
            n4 = n & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (n = byArray[this._inputPtr++])) {
                n3 = 1;
                break;
            }
            n4 = n4 << 8 | n & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (n = byArray[this._inputPtr++])) {
                n3 = 2;
                break;
            }
            n4 = n4 << 8 | n & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (n = byArray[this._inputPtr++])) {
                n3 = 3;
                break;
            }
            n4 = n4 << 8 | n & 0xFF;
            if (n2 >= this._quadBuffer.length) {
                this._quadBuffer = NonBlockingParserImpl._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            this._quadBuffer[n2++] = n4;
        }
        n = n2 << 2;
        if (n3 > 0) {
            if (n2 >= this._quadBuffer.length) {
                this._quadBuffer = NonBlockingParserImpl._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            this._quadBuffer[n2++] = n4;
            n += n3;
        }
        String string = (name = this._symbols.findName(this._quadBuffer, n2)) != null ? name.getName() : this._decodeLongUnicodeName(this._quadBuffer, n, n2).getName();
        if (this._seenNames != null) {
            if (this._seenNameCount >= this._seenNames.length) {
                this._seenNames = this._expandSeenNames(this._seenNames);
            }
            this._seenNames[this._seenNameCount++] = string;
        }
        this._parsingContext.setCurrentName(string);
    }

    private final Name _findDecodedFromSymbols(int n) throws IOException, JsonParseException {
        if (this._inputEnd - this._inputPtr < n) {
            this._loadToHaveAtLeast(n);
        }
        if (n < 5) {
            int n2 = this._inputPtr;
            byte[] byArray = this._inputBuffer;
            int n3 = byArray[n2] & 0xFF;
            if (--n > 0) {
                n3 = (n3 << 8) + (byArray[++n2] & 0xFF);
                if (--n > 0) {
                    n3 = (n3 << 8) + (byArray[++n2] & 0xFF);
                    if (--n > 0) {
                        n3 = (n3 << 8) + (byArray[++n2] & 0xFF);
                    }
                }
            }
            this._quad1 = n3;
            return this._symbols.findName(n3);
        }
        if (n < 9) {
            int n4 = this._inputPtr;
            byte[] byArray = this._inputBuffer;
            int n5 = (byArray[n4] & 0xFF) << 8;
            n5 += byArray[++n4] & 0xFF;
            n5 <<= 8;
            n5 += byArray[++n4] & 0xFF;
            n5 <<= 8;
            n5 += byArray[++n4] & 0xFF;
            int n6 = byArray[++n4] & 0xFF;
            if ((n -= 5) > 0) {
                n6 = (n6 << 8) + (byArray[++n4] & 0xFF);
                if (--n > 0) {
                    n6 = (n6 << 8) + (byArray[++n4] & 0xFF);
                    if (--n > 0) {
                        n6 = (n6 << 8) + (byArray[++n4] & 0xFF);
                    }
                }
            }
            this._quad1 = n5;
            this._quad2 = n6;
            return this._symbols.findName(n5, n6);
        }
        return this._findDecodedMedium(n);
    }

    private final Name _findDecodedMedium(int n) throws IOException, JsonParseException {
        int n2;
        int n3 = n + 3 >> 2;
        if (n3 > this._quadBuffer.length) {
            this._quadBuffer = NonBlockingParserImpl._growArrayTo(this._quadBuffer, n3);
        }
        n3 = 0;
        int n4 = this._inputPtr;
        byte[] byArray = this._inputBuffer;
        do {
            n2 = (byArray[n4++] & 0xFF) << 8;
            n2 |= byArray[n4++] & 0xFF;
            n2 <<= 8;
            n2 |= byArray[n4++] & 0xFF;
            n2 <<= 8;
            this._quadBuffer[n3++] = n2 |= byArray[n4++] & 0xFF;
        } while ((n -= 4) > 3);
        if (n > 0) {
            n2 = byArray[n4] & 0xFF;
            if (--n > 0) {
                n2 = (n2 << 8) + (byArray[++n4] & 0xFF);
                if (--n > 0) {
                    n2 = (n2 << 8) + (byArray[++n4] & 0xFF);
                }
            }
            this._quadBuffer[n3++] = n2;
        }
        return this._symbols.findName(this._quadBuffer, n3);
    }

    private static int[] _growArrayTo(int[] nArray, int n) {
        int[] nArray2 = new int[n + 4];
        if (nArray != null) {
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        }
        return nArray2;
    }

    protected void _parseNumericValue(int n) throws IOException, JsonParseException {
        if (this._tokenIncomplete) {
            this._reportError("No current token available, can not call accessors");
        }
    }

    protected final JsonToken _finishToken() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            return JsonToken.NOT_AVAILABLE;
        }
        byte by = this._inputBuffer[this._inputPtr++];
        if (this._state == 0) {
            if (by == 58) {
                if (!this._handleHeader(0)) {
                    return JsonToken.NOT_AVAILABLE;
                }
                if (this._inputPtr >= this._inputEnd) {
                    return JsonToken.NOT_AVAILABLE;
                }
                by = this._inputBuffer[this._inputPtr++];
            } else if (this._cfgRequireHeader) {
                String string = by == 123 || by == 91 ? "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(by & 0xFF) + ") -- rather, it starts with '" + (char)by + "' (plain JSON input?) -- can not parse" : "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(by & 0xFF) + ") and parser has REQUIRE_HEADER enabled: can not parse";
                throw new JsonParseException(string, JsonLocation.NA);
            }
        } else if (this._state == 1) {
            if (!this._handleHeader(this._substate)) {
                return JsonToken.NOT_AVAILABLE;
            }
            if (this._inputPtr >= this._inputEnd) {
                return JsonToken.NOT_AVAILABLE;
            }
            by = this._inputBuffer[this._inputPtr++];
        }
        switch (this._state) {
            case 10: {
                return this._nextInt(this._substate, this._pendingInt);
            }
            case 11: {
                return this._nextLong(this._substate, this._pendingLong);
            }
            case 12: {
                return this._nextBigInt(this._substate);
            }
            case 13: {
                return this._nextFloat(this._substate, this._pendingInt);
            }
            case 14: {
                return this._nextDouble(this._substate, this._pendingLong);
            }
            case 15: {
                return this._nextBigDecimal(this._substate);
            }
        }
        this._throwInvalidState("Illegal state when trying to complete token: ");
        return null;
    }

    protected void _reportInvalidSharedName(int n) throws IOException {
        if (this._seenNames == null) {
            this._reportError("Encountered shared name reference, even though document header explicitly declared no shared name references are included");
        }
        this._reportError("Invalid shared name reference " + n + "; only got " + this._seenNameCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidSharedStringValue(int n) throws IOException {
        if (this._seenStringValues == null) {
            this._reportError("Encountered shared text value reference, even though document header did not declared shared text value references may be included");
        }
        this._reportError("Invalid shared text value reference " + n + "; only got " + this._seenStringValueCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidChar(int n) throws JsonParseException {
        if (n < 32) {
            this._throwInvalidSpace(n);
        }
        this._reportInvalidInitial(n);
    }

    protected void _reportInvalidInitial(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int n, int n2) throws JsonParseException {
        this._inputPtr = n2;
        this._reportInvalidOther(n);
    }

    protected void _throwInvalidState(String string) {
        throw new IllegalStateException(string + ": state=" + this._state);
    }
}

