/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.ValueExp;

class BetweenQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -2933597532866307444L;
    private final ValueExp exp1;
    private final ValueExp exp2;
    private final ValueExp exp3;

    BetweenQueryExp(ValueExp exp1, ValueExp exp2, ValueExp exp3) {
        this.exp1 = exp1;
        this.exp2 = exp2;
        this.exp3 = exp3;
    }

    public void setMBeanServer(MBeanServer server) {
        super.setMBeanServer(server);
        if (this.exp1 != null) {
            this.exp1.setMBeanServer(server);
        }
        if (this.exp2 != null) {
            this.exp2.setMBeanServer(server);
        }
        if (this.exp3 != null) {
            this.exp3.setMBeanServer(server);
        }
    }

    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        if (this.exp1 != null && this.exp2 != null && this.exp3 != null) {
            ValueExp val1 = this.exp1.apply(name);
            ValueExp val2 = this.exp2.apply(name);
            ValueExp val3 = this.exp3.apply(name);
            if (val1 instanceof NumericValueExp && val2 instanceof NumericValueExp && val3 instanceof NumericValueExp) {
                NumericValueExp num1 = (NumericValueExp)val1;
                NumericValueExp num2 = (NumericValueExp)val2;
                NumericValueExp num3 = (NumericValueExp)val3;
                if (num1.isDouble() || num2.isDouble() || num3.isDouble()) {
                    return this.isBetween(new Double(num1.doubleValue()), new Double(num2.doubleValue()), new Double(num3.doubleValue()));
                }
                return this.isBetween(new Long(num1.longValue()), new Long(num2.longValue()), new Long(num3.longValue()));
            }
            throw new InvalidApplicationException((Object)"Values are not numeric");
        }
        return false;
    }

    private boolean isBetween(Comparable c1, Comparable c2, Comparable c3) {
        if (c1 == null && c2 == null && c3 == null) {
            return true;
        }
        if (c1 == null && (c2 == null || c3 == null)) {
            return true;
        }
        if (c1 == null) {
            return false;
        }
        if (c1 != null && (c2 == null || c3 == null)) {
            return false;
        }
        return c1.compareTo(c2) >= 0 && c1.compareTo(c3) <= 0;
    }
}

