/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.contrib.proxy.PluginProxyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpConnection;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionManagerFactory;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.conn.tsccm.AbstractConnPool;
import org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.HttpContext;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.impl.rest.httpclient.JetS3tRequestAuthorizer;
import org.jets3t.service.io.UnrecoverableIOException;
import org.jets3t.service.utils.ServiceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestUtils {
    private static final Log log = LogFactory.getLog(RestUtils.class);
    public static final List<String> HTTP_HEADER_METADATA_NAMES = Arrays.asList("content-type", "content-md5", "content-length", "content-language", "expires", "cache-control", "content-disposition", "content-encoding");

    public static String encodeUrlString(String path) {
        String encodedPath = null;
        try {
            encodedPath = URLEncoder.encode(path, Constants.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        encodedPath = encodedPath.replaceAll("\\+", "%20");
        encodedPath = encodedPath.replaceAll("%40", "@");
        return encodedPath;
    }

    public static String encodeUrlPath(String path, String delimiter) {
        StringBuilder result = new StringBuilder();
        String[] tokens = path.split(delimiter);
        for (int i = 0; i < tokens.length; ++i) {
            result.append(RestUtils.encodeUrlString(tokens[i]));
            if (i >= tokens.length - 1) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static String makeServiceCanonicalString(String method, String resource, Map<String, Object> headersMap, String expires, String headerPrefix, List<String> serviceResourceParameterNames) {
        Object value;
        String key;
        StringBuilder canonicalStringBuf = new StringBuilder();
        canonicalStringBuf.append(method).append("\n");
        TreeMap<String, Object> interestingHeaders = new TreeMap<String, Object>();
        if (headersMap != null && headersMap.size() > 0) {
            for (Map.Entry<String, Object> entry : headersMap.entrySet()) {
                String lk;
                key = entry.getKey();
                value = entry.getValue();
                if (key == null || !(lk = key.toString().toLowerCase(Locale.ENGLISH)).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith(headerPrefix)) continue;
                interestingHeaders.put(lk, value);
            }
        }
        if (interestingHeaders.containsKey("x-amz-date") || interestingHeaders.containsKey("x-goog-date")) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        if (!interestingHeaders.containsKey("content-md5")) {
            interestingHeaders.put("content-md5", "");
        }
        for (Map.Entry<String, Object> entry : interestingHeaders.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (key.startsWith(headerPrefix)) {
                canonicalStringBuf.append(key).append(':').append(value);
            } else {
                canonicalStringBuf.append(value);
            }
            canonicalStringBuf.append("\n");
        }
        int queryIndex = resource.indexOf(63);
        if (queryIndex == -1) {
            canonicalStringBuf.append(resource);
        } else {
            canonicalStringBuf.append(resource.substring(0, queryIndex));
        }
        if (queryIndex >= 0) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            String query = resource.substring(queryIndex + 1);
            for (String paramPair : query.split("&")) {
                String[] paramNameValue = paramPair.split("=");
                try {
                    String name = URLDecoder.decode(paramNameValue[0], "UTF-8");
                    String value2 = null;
                    if (paramNameValue.length > 1) {
                        value2 = URLDecoder.decode(paramNameValue[1], "UTF-8");
                    }
                    if (!serviceResourceParameterNames.contains(name)) continue;
                    treeMap.put(name, value2);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            if (treeMap.size() > 0) {
                canonicalStringBuf.append("?");
            }
            boolean addedParam = false;
            for (Map.Entry entry : treeMap.entrySet()) {
                if (addedParam) {
                    canonicalStringBuf.append("&");
                }
                canonicalStringBuf.append((String)entry.getKey());
                if (entry.getValue() != null) {
                    canonicalStringBuf.append("=").append((String)entry.getValue());
                }
                addedParam = true;
            }
        }
        return canonicalStringBuf.toString();
    }

    public static HttpClient initHttpConnection(JetS3tRequestAuthorizer requestAuthorizer, Jets3tProperties jets3tProperties, String userAgentDescription, CredentialsProvider credentialsProvider) {
        HttpParams params = RestUtils.createDefaultHttpParams();
        params.setParameter("org.jets3t.service.JetS3tProperties", (Object)jets3tProperties);
        params.setParameter("http.connection-manager.factory-class-name", (Object)jets3tProperties.getStringProperty("http.connection-manager.factory-class-name", ConnManagerFactory.class.getName()));
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)jets3tProperties.getIntProperty("httpclient.connection-timeout-ms", 60000));
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)jets3tProperties.getIntProperty("httpclient.socket-timeout-ms", 60000));
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)jets3tProperties.getBoolProperty("httpclient.stale-checking-enabled", true));
        if (jets3tProperties.containsKey("httpclient.socket-receive-buffer")) {
            HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)jets3tProperties.getIntProperty("httpclient.socket-receive-buffer", 0));
        }
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        String userAgent = jets3tProperties.getStringProperty("httpclient.useragent", null);
        if (userAgent == null) {
            userAgent = ServiceUtils.getUserAgentDescription(userAgentDescription);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting user agent string: " + userAgent));
        }
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)userAgent);
        boolean expectContinue = jets3tProperties.getBoolProperty("http.protocol.expect-continue", true);
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)expectContinue);
        long connectionManagerTimeout = jets3tProperties.getLongProperty("httpclient.connection-manager-timeout", 0L);
        ConnManagerParams.setTimeout((HttpParams)params, (long)connectionManagerTimeout);
        DefaultHttpClient httpClient = new DefaultHttpClient(params);
        httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new JetS3tRetryHandler(jets3tProperties.getIntProperty("httpclient.retry-max", 5), requestAuthorizer));
        if (credentialsProvider != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using credentials provider class: " + credentialsProvider.getClass().getName()));
            }
            httpClient.setCredentialsProvider(credentialsProvider);
            if (jets3tProperties.getBoolProperty("httpclient.authentication-preemptive", false)) {
                httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveInterceptor(), 0);
            }
        }
        return httpClient;
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties) {
        RestUtils.initHttpProxy(httpClient, jets3tProperties, true, null, -1, null, null, null);
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties, String endpoint) {
        RestUtils.initHttpProxy(httpClient, jets3tProperties, true, null, -1, null, null, null, endpoint);
    }

    public static void initHttpProxy(HttpClient httpClient, String proxyHostAddress, int proxyPort, Jets3tProperties jets3tProperties) {
        RestUtils.initHttpProxy(httpClient, jets3tProperties, false, proxyHostAddress, proxyPort, null, null, null);
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties, String proxyHostAddress, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain) {
        RestUtils.initHttpProxy(httpClient, jets3tProperties, false, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain);
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties, boolean proxyAutodetect, String proxyHostAddress, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain) {
        String s3Endpoint = jets3tProperties.getStringProperty("s3service.s3-endpoint", Constants.S3_DEFAULT_HOSTNAME);
        RestUtils.initHttpProxy(httpClient, jets3tProperties, proxyAutodetect, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain, s3Endpoint);
    }

    public static void initHttpProxy(HttpClient httpClient, Jets3tProperties jets3tProperties, boolean proxyAutodetect, String proxyHostAddress, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain, String endpoint) {
        block11: {
            if (proxyHostAddress != null && proxyPort != -1) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Using Proxy: " + proxyHostAddress + ":" + proxyPort));
                }
                HttpHost proxy = new HttpHost(proxyHostAddress, proxyPort);
                httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                if (proxyUser != null && !proxyUser.trim().equals("") && httpClient instanceof AbstractHttpClient) {
                    if (proxyDomain != null) {
                        ((AbstractHttpClient)httpClient).getCredentialsProvider().setCredentials(new AuthScope(proxyHostAddress, proxyPort), (Credentials)new NTCredentials(proxyUser, proxyPassword, proxyHostAddress, proxyDomain));
                    } else {
                        ((AbstractHttpClient)httpClient).getCredentialsProvider().setCredentials(new AuthScope(proxyHostAddress, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                    }
                }
            } else if (proxyAutodetect) {
                HttpHost proxyHost = null;
                try {
                    proxyHost = PluginProxyUtil.detectProxy(new URL("http://" + endpoint));
                    if (proxyHost != null) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Using Proxy: " + proxyHost.getHostName() + ":" + proxyHost.getPort()));
                        }
                        httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
                    }
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block11;
                    log.debug((Object)"Unable to set proxy configuration", t);
                }
            }
        }
    }

    public static long calculateTimeAdjustmentOffset(HttpResponse response) throws ParseException {
        Header[] dateHeaders = response.getHeaders("Date");
        if (dateHeaders.length > 0) {
            String dateHeader = dateHeaders[0].getValue();
            Date awsTime = ServiceUtils.parseRfc822Date(dateHeader);
            Date localTime = new Date();
            long timeOffset = awsTime.getTime() - localTime.getTime();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calculated time offset value of " + timeOffset + " milliseconds between the local machine and the response: " + response));
            }
            return timeOffset;
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("Unable to calculate value of time offset between the local machine and the response: " + response));
        }
        return 0L;
    }

    public static Map<String, String> convertHeadersToMap(Header[] headers) {
        HashMap<String, String> s3Headers = new HashMap<String, String>();
        for (Header header : headers) {
            s3Headers.put(header.getName(), header.getValue());
        }
        return s3Headers;
    }

    public static HttpParams createDefaultHttpParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"ISO-8859-1");
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        return params;
    }

    private static class PreemptiveInterceptor
    implements HttpRequestInterceptor {
        private PreemptiveInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) {
            AuthScope authScope;
            Credentials creds;
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
            if (authState.getAuthScheme() == null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                authState.setAuthScheme((AuthScheme)new BasicScheme());
                authState.setCredentials(creds);
            }
        }
    }

    public static class JetS3tRetryHandler
    extends DefaultHttpRequestRetryHandler {
        private final JetS3tRequestAuthorizer requestAuthorizer;

        public JetS3tRetryHandler(int pRetryMaxCount, JetS3tRequestAuthorizer requestAuthorizer) {
            super(pRetryMaxCount, false);
            this.requestAuthorizer = requestAuthorizer;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            block11: {
                if (super.retryRequest(exception, executionCount, context)) {
                    if (exception instanceof UnrecoverableIOException) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Deliberate interruption, will not retry");
                        }
                        return false;
                    }
                    HttpRequest request = (HttpRequest)context.getAttribute("http.request");
                    if (request instanceof RequestWrapper) {
                        request = ((RequestWrapper)request).getOriginal();
                    }
                    if (!(request instanceof HttpRequestBase)) {
                        return false;
                    }
                    HttpRequestBase method = (HttpRequestBase)request;
                    HttpConnection conn = (HttpConnection)context.getAttribute("http.connection");
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Retrying " + method.getMethod() + " request with path '" + method.getURI() + "' - attempt " + executionCount + " of " + this.getRetryCount()));
                    }
                    try {
                        if (this.requestAuthorizer != null) {
                            this.requestAuthorizer.authorizeHttpRequest((HttpUriRequest)method, context);
                        }
                        return true;
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block11;
                        log.warn((Object)"Unable to generate updated authorization string for retried request", (Throwable)e);
                    }
                }
            }
            return false;
        }
    }

    public static class ThreadSafeConnManager
    extends ThreadSafeClientConnManager {
        public ThreadSafeConnManager(HttpParams params, SchemeRegistry schreg) {
            super(params, schreg);
        }

        protected AbstractConnPool createConnectionPool(HttpParams params) {
            Jets3tProperties props = (Jets3tProperties)params.getParameter("org.jets3t.service.JetS3tProperties");
            int maxConn = 20;
            int maxConnectionsPerHost = 0;
            if (props != null) {
                maxConn = props.getIntProperty("httpclient.max-connections", 20);
                maxConnectionsPerHost = props.getIntProperty("httpclient.max-connections-per-host", 0);
            }
            if (maxConnectionsPerHost == 0) {
                maxConnectionsPerHost = maxConn;
            }
            this.connPerRoute.setDefaultMaxPerRoute(maxConnectionsPerHost);
            return new ConnPoolByRoute(this.connOperator, (ConnPerRoute)this.connPerRoute, maxConn, props.getLongProperty("httpclient.connection.ttl", -1L), TimeUnit.MILLISECONDS);
        }
    }

    public static class ConnManagerFactory
    implements ClientConnectionManagerFactory {
        public ClientConnectionManager newInstance(HttpParams params, SchemeRegistry schemeRegistry) {
            return new ThreadSafeConnManager(params, schemeRegistry);
        }
    }
}

