/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model.cloudfront;

import java.util.Arrays;

public class CacheBehavior {
    private String pathPattern;
    private String targetOriginId;
    private boolean isForwardQueryString = false;
    private String[] trustedSignerAwsAccountNumbers;
    private ViewerProtocolPolicy viewerProtocolPolicy = ViewerProtocolPolicy.ALLOW_ALL;
    private Long minTTL = 0L;

    public CacheBehavior(String pathPattern, String targetOriginId, boolean isForwardQueryString, String[] trustedSignerAwsAccountNumbers, ViewerProtocolPolicy viewerProtocolPolicy, Long minTTL) {
        this.pathPattern = pathPattern;
        this.targetOriginId = targetOriginId;
        this.isForwardQueryString = isForwardQueryString;
        this.trustedSignerAwsAccountNumbers = trustedSignerAwsAccountNumbers;
        this.viewerProtocolPolicy = viewerProtocolPolicy;
        this.minTTL = minTTL;
    }

    public CacheBehavior(String targetOriginId, boolean isForwardQueryString, String[] trustedSignerAwsAccountNumbers, ViewerProtocolPolicy viewerProtocolPolicy, Long minTTL) {
        this(null, targetOriginId, isForwardQueryString, trustedSignerAwsAccountNumbers, viewerProtocolPolicy, minTTL);
    }

    public CacheBehavior() {
    }

    public String getPathPattern() {
        return this.pathPattern;
    }

    public void setPathPattern(String pathPattern) {
        this.pathPattern = pathPattern;
    }

    public String getTargetOriginId() {
        return this.targetOriginId;
    }

    public void setTargetOriginId(String targetOriginId) {
        this.targetOriginId = targetOriginId;
    }

    public boolean isForwardQueryString() {
        return this.isForwardQueryString;
    }

    public void setIsForwardQueryString(boolean isForwardQueryString) {
        this.isForwardQueryString = isForwardQueryString;
    }

    public String[] getTrustedSignerAwsAccountNumbers() {
        return this.trustedSignerAwsAccountNumbers;
    }

    public void setTrustedSignerAwsAccountNumbers(String[] trustedSignerAwsAccountNumbers) {
        this.trustedSignerAwsAccountNumbers = trustedSignerAwsAccountNumbers;
    }

    public ViewerProtocolPolicy getViewerProtocolPolicy() {
        return this.viewerProtocolPolicy;
    }

    public void setViewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy) {
        this.viewerProtocolPolicy = viewerProtocolPolicy;
    }

    public Long getMinTTL() {
        return this.minTTL;
    }

    public void setMinTTL(Long minTTL) {
        this.minTTL = minTTL;
    }

    public boolean hasTrustedSignerAwsAccountNumbers() {
        return this.getTrustedSignerAwsAccountNumbers() != null && this.getTrustedSignerAwsAccountNumbers().length > 0;
    }

    public boolean hasMinTTL() {
        return this.minTTL != null;
    }

    public boolean isTrustedSignerSelf() {
        for (String trustedSigner : this.getTrustedSignerAwsAccountNumbers()) {
            if (!"self".equals(trustedSigner)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "CacheBehavior: pathPattern=" + this.getPathPattern() + ", targetOriginId=" + this.getTargetOriginId() + ", isForwardQueryString=" + this.isForwardQueryString() + ", trustedSignerAwsAccountNumbers=" + Arrays.asList(this.getTrustedSignerAwsAccountNumbers()) + ", viewerProtocolPolicy=" + (Object)((Object)this.getViewerProtocolPolicy()) + ", minTTL=" + this.getMinTTL();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewerProtocolPolicy {
        HTTPS_ONLY("https-only"),
        ALLOW_ALL("allow-all");

        private final String textValue;

        private ViewerProtocolPolicy(String textValue) {
            this.textValue = textValue;
        }

        public String toText() {
            return this.textValue;
        }

        public static ViewerProtocolPolicy fromText(String text) {
            for (ViewerProtocolPolicy e : ViewerProtocolPolicy.values()) {
                if (!e.toText().equalsIgnoreCase(text)) continue;
                return e;
            }
            throw new IllegalArgumentException("Invalid ViewerProtocolPolicy: " + text);
        }
    }
}

