/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.synchronize;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jets3t.apps.synchronize.CommandLineCredentialsProvider;
import org.jets3t.apps.synchronize.PasswordInput;
import org.jets3t.apps.synchronize.SynchronizeException;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3Service;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageService;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.httpclient.GoogleStorageService;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;
import org.jets3t.service.io.BytesProgressWatcher;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageBucket;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.multi.DownloadPackage;
import org.jets3t.service.multi.ThreadWatcher;
import org.jets3t.service.multi.ThreadedStorageService;
import org.jets3t.service.multi.event.CreateObjectsEvent;
import org.jets3t.service.multi.event.DeleteObjectsEvent;
import org.jets3t.service.multi.event.DownloadObjectsEvent;
import org.jets3t.service.multi.event.GetObjectHeadsEvent;
import org.jets3t.service.multi.event.ServiceEvent;
import org.jets3t.service.multi.s3.MultipartCompletesEvent;
import org.jets3t.service.multi.s3.MultipartStartsEvent;
import org.jets3t.service.multi.s3.MultipartUploadsEvent;
import org.jets3t.service.multi.s3.S3ServiceEventAdaptor;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.EncryptionUtil;
import org.jets3t.service.security.GSCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.ByteFormatter;
import org.jets3t.service.utils.FileComparer;
import org.jets3t.service.utils.FileComparerResults;
import org.jets3t.service.utils.MultipartUtils;
import org.jets3t.service.utils.ObjectUtils;
import org.jets3t.service.utils.TimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Synchronize {
    public static final String APPLICATION_DESCRIPTION = "Synchronize/0.9.1";
    protected static final int REPORT_LEVEL_NONE = 0;
    protected static final int REPORT_LEVEL_ACTIONS = 1;
    protected static final int REPORT_LEVEL_DIFFERENCES = 2;
    protected static final int REPORT_LEVEL_ALL = 3;
    private StorageService storageService = null;
    private boolean doAction = false;
    private boolean isQuiet = false;
    private boolean isNoProgress = false;
    private boolean isForce = false;
    private boolean isKeepFiles = false;
    private boolean isNoDelete = false;
    private boolean isGzipEnabled = false;
    private boolean isEncryptionEnabled = false;
    private boolean isMoveEnabled = false;
    private boolean isBatchMode = false;
    private int reportLevel = 3;
    private String cryptoPassword = null;
    private Jets3tProperties properties = null;
    private final ByteFormatter byteFormatter = new ByteFormatter();
    private final TimeFormatter timeFormatter = new TimeFormatter();
    private FileComparer fileComparer = null;
    private int maxTemporaryStringLength = 0;
    private final Map<String, Object> customMetadata = new HashMap<String, Object>();
    S3ServiceEventAdaptor serviceEventAdaptor = new S3ServiceEventAdaptor(){

        private void displayIgnoredErrors(ServiceEvent event) {
            if (5 == event.getEventCode()) {
                Throwable[] throwables = event.getIgnoredErrors();
                for (int i = 0; i < throwables.length; ++i) {
                    Synchronize.this.printOutputLine("Ignoring error: " + throwables[i].getMessage(), 3);
                }
            }
        }

        public void event(CreateObjectsEvent event) {
            super.event(event);
            this.displayIgnoredErrors(event);
            if (3 == event.getEventCode()) {
                Synchronize.this.displayProgressStatus("Upload: ", event.getThreadWatcher());
            }
        }

        public void event(MultipartStartsEvent event) {
            super.event(event);
            if (3 == event.getEventCode()) {
                Synchronize.this.displayProgressStatus("Starting large file uploads: ", event.getThreadWatcher());
            }
        }

        public void event(MultipartCompletesEvent event) {
            super.event(event);
            if (3 == event.getEventCode()) {
                Synchronize.this.displayProgressStatus("Completing large file uploads: ", event.getThreadWatcher());
            }
        }

        public void event(MultipartUploadsEvent event) {
            super.event(event);
            this.displayIgnoredErrors(event);
            if (3 == event.getEventCode()) {
                Synchronize.this.displayProgressStatus("Large upload parts: ", event.getThreadWatcher());
            }
        }

        public void event(DownloadObjectsEvent event) {
            super.event(event);
            this.displayIgnoredErrors(event);
            if (3 == event.getEventCode()) {
                Synchronize.this.displayProgressStatus("Download: ", event.getThreadWatcher());
            }
        }

        public void event(GetObjectHeadsEvent event) {
            super.event(event);
            this.displayIgnoredErrors(event);
            if (3 == event.getEventCode()) {
                Synchronize.this.displayProgressStatus("Retrieving object details from service: ", event.getThreadWatcher());
            }
        }

        public void event(DeleteObjectsEvent event) {
            super.event(event);
            this.displayIgnoredErrors(event);
            if (3 == event.getEventCode()) {
                Synchronize.this.displayProgressStatus("Deleting objects in service: ", event.getThreadWatcher());
            }
        }
    };

    public Synchronize(StorageService service, boolean doAction, boolean isQuiet, boolean isNoProgress, boolean isForce, boolean isKeepFiles, boolean isNoDelete, boolean isMoveEnabled, boolean isBatchMode, boolean isGzipEnabled, boolean isEncryptionEnabled, int reportLevel, Jets3tProperties properties) {
        this.storageService = service;
        this.doAction = doAction;
        this.isQuiet = isQuiet;
        this.isNoProgress = isNoProgress;
        this.isForce = isForce;
        this.isKeepFiles = isKeepFiles;
        this.isNoDelete = isNoDelete;
        this.isMoveEnabled = isMoveEnabled;
        this.isBatchMode = isBatchMode;
        this.isGzipEnabled = isGzipEnabled;
        this.isEncryptionEnabled = isEncryptionEnabled;
        this.reportLevel = reportLevel;
        this.properties = properties;
        this.fileComparer = FileComparer.getInstance(properties);
        for (Map.Entry<Object, Object> entry : this.properties.getProperties().entrySet()) {
            String keyName = entry.getKey().toString().toLowerCase();
            if (entry.getKey() == null || !keyName.startsWith("upload.metadata.")) continue;
            String metadataName = entry.getKey().toString().substring("upload.metadata.".length());
            String metadataValue = entry.getValue().toString();
            this.customMetadata.put(metadataName, metadataValue);
        }
    }

    private String formatTransferDetails(ThreadWatcher watcher) {
        String detailsText = "";
        long bytesPerSecond = watcher.getBytesPerSecond();
        detailsText = this.byteFormatter.formatByteSize(bytesPerSecond) + "/s";
        if (watcher.isTimeRemainingAvailable()) {
            if (detailsText.trim().length() > 0) {
                detailsText = detailsText + " - ";
            }
            long secondsRemaining = watcher.getTimeRemaining();
            detailsText = detailsText + "ETA: " + this.timeFormatter.formatTime(secondsRemaining, false);
        }
        return detailsText;
    }

    private void printOutputLine(String line, int level) {
        if (this.isQuiet && level > 0 || this.reportLevel < level) {
            return;
        }
        String blanks = "";
        for (int i = line.length(); i < this.maxTemporaryStringLength; ++i) {
            blanks = blanks + " ";
        }
        System.out.println(line + blanks);
        this.maxTemporaryStringLength = 0;
    }

    private void printProgressLine(String line) {
        if (this.isQuiet || this.isNoProgress) {
            return;
        }
        String temporaryLine = "  " + line;
        if (temporaryLine.length() > this.maxTemporaryStringLength) {
            this.maxTemporaryStringLength = temporaryLine.length();
        }
        String blanks = "";
        for (int i = temporaryLine.length(); i < this.maxTemporaryStringLength; ++i) {
            blanks = blanks + " ";
        }
        System.out.print(temporaryLine + blanks + "\r");
    }

    protected ComparisonResult compareLocalAndRemoteFiles(FileComparerResults mergedDiscrepancyResults, String bucketName, String rootObjectPath, String priorLastKey, Map<String, String> objectKeyToFilepathMap, BytesProgressWatcher md5GenerationProgressWatcher) throws ServiceException, NoSuchAlgorithmException, FileNotFoundException, IOException, ParseException {
        this.printProgressLine("Listing objects in service" + (this.isBatchMode && mergedDiscrepancyResults.getCountOfItemsCompared() > 0L ? " (Continuing in batches, objects listed previously: " + mergedDiscrepancyResults.getCountOfItemsCompared() + ")" : ""));
        boolean forceMetadataDownload = this.isEncryptionEnabled || this.isGzipEnabled;
        FileComparer.PartialObjectListing partialListing = this.fileComparer.buildObjectMapPartial(this.storageService, bucketName, rootObjectPath, priorLastKey, objectKeyToFilepathMap, !this.isBatchMode, forceMetadataDownload, this.isForce, md5GenerationProgressWatcher, this.serviceEventAdaptor);
        if (this.serviceEventAdaptor.wasErrorThrown()) {
            throw new ServiceException("Unable to build map of objects", this.serviceEventAdaptor.getErrorThrown());
        }
        md5GenerationProgressWatcher.resetWatcher();
        priorLastKey = partialListing.getPriorLastKey();
        Map<String, StorageObject> objectsMap = partialListing.getObjectsMap();
        this.printProgressLine("Comparing service contents with local system");
        FileComparerResults discrepancyResults = this.fileComparer.buildDiscrepancyLists(objectKeyToFilepathMap, objectsMap, md5GenerationProgressWatcher, this.isForce);
        mergedDiscrepancyResults.merge(discrepancyResults);
        ComparisonResult result = new ComparisonResult();
        result.priorLastKey = priorLastKey;
        result.objectsMap = objectsMap;
        result.discrepancyResults = discrepancyResults;
        return result;
    }

    public void uploadLocalDirectory(Map<String, String> objectKeyToFilepathMap, StorageBucket bucket, String rootObjectPath, String aclString, BytesProgressWatcher md5GenerationProgressWatcher) throws Exception {
        File file;
        FileComparerResults mergedDiscrepancyResults = new FileComparerResults();
        String priorLastKey = null;
        String lastFileKeypathChecked = "";
        boolean skipMissingFiles = this.properties.getBoolProperty("upload.ignoreMissingPaths", false);
        EncryptionUtil encryptionUtil = null;
        if (this.isEncryptionEnabled) {
            String algorithm = this.properties.getStringProperty("crypto.algorithm", "PBEWithMD5AndDES");
            encryptionUtil = new EncryptionUtil(this.cryptoPassword, algorithm, "2");
        }
        MultipartUtils multipartUtils = null;
        if (this.storageService instanceof S3Service) {
            long maxUploadPartSize = this.properties.getLongProperty("upload.max-part-size", 0x40000000L);
            multipartUtils = new MultipartUtils(maxUploadPartSize);
        }
        do {
            ComparisonResult result = this.compareLocalAndRemoteFiles(mergedDiscrepancyResults, bucket.getName(), rootObjectPath, priorLastKey, objectKeyToFilepathMap, md5GenerationProgressWatcher);
            priorLastKey = result.priorLastKey;
            FileComparerResults discrepancyResults = result.discrepancyResults;
            Iterator<String> objectKeyIter = objectKeyToFilepathMap.keySet().iterator();
            do {
                ArrayList<LazyPreparedUploadObject> objectsToUpload = new ArrayList<LazyPreparedUploadObject>();
                while (objectKeyIter.hasNext()) {
                    String relativeKeyPath;
                    String targetKey = relativeKeyPath = objectKeyIter.next();
                    if (rootObjectPath.length() > 0) {
                        targetKey = rootObjectPath.endsWith(Constants.FILE_PATH_DELIM) ? rootObjectPath + targetKey : rootObjectPath + Constants.FILE_PATH_DELIM + targetKey;
                    }
                    if (this.isBatchMode) {
                        if (priorLastKey != null && targetKey.compareTo(priorLastKey) > 0 || targetKey.compareTo(lastFileKeypathChecked) <= 0) continue;
                        lastFileKeypathChecked = targetKey;
                    }
                    file = new File(objectKeyToFilepathMap.get(relativeKeyPath));
                    byte[] md5HashOfFile = null;
                    if (!file.isDirectory()) {
                        if (this.fileComparer.isGenerateMd5Files()) {
                            md5HashOfFile = this.fileComparer.generateFileMD5Hash(file, targetKey, null);
                        } else if (this.fileComparer.isUseMd5Files()) {
                            md5HashOfFile = this.fileComparer.lookupFileMD5Hash(file, targetKey);
                        }
                    }
                    if (discrepancyResults.onlyOnClientKeys.contains(relativeKeyPath)) {
                        this.printOutputLine("N " + targetKey, 1);
                        objectsToUpload.add(new LazyPreparedUploadObject(targetKey, file, md5HashOfFile, aclString, encryptionUtil));
                    } else if (discrepancyResults.updatedOnClientKeys.contains(relativeKeyPath)) {
                        this.printOutputLine("U " + targetKey, 1);
                        objectsToUpload.add(new LazyPreparedUploadObject(targetKey, file, md5HashOfFile, aclString, encryptionUtil));
                    } else if (discrepancyResults.alreadySynchronisedKeys.contains(relativeKeyPath) || discrepancyResults.alreadySynchronisedLocalPaths.contains(relativeKeyPath)) {
                        if (this.isForce) {
                            this.printOutputLine("F " + targetKey, 1);
                            objectsToUpload.add(new LazyPreparedUploadObject(targetKey, file, md5HashOfFile, aclString, encryptionUtil));
                        } else {
                            this.printOutputLine("- " + targetKey, 3);
                        }
                    } else if (discrepancyResults.updatedOnServerKeys.contains(relativeKeyPath)) {
                        if (this.isKeepFiles) {
                            this.printOutputLine("r " + targetKey, 2);
                        } else {
                            this.printOutputLine("R " + targetKey, 1);
                            objectsToUpload.add(new LazyPreparedUploadObject(targetKey, file, md5HashOfFile, aclString, encryptionUtil));
                        }
                    } else {
                        throw new SynchronizeException("Invalid discrepancy comparison details for file " + file.getPath() + ". Sorry, this is a program error - aborting to keep your data safe");
                    }
                    if (!this.isBatchMode || (long)objectsToUpload.size() < 1000L) continue;
                    this.printOutputLine("Uploading batch of " + objectsToUpload.size() + " files", 1);
                    break;
                }
                int uploadBatchSize = objectsToUpload.size();
                if ((this.isEncryptionEnabled || this.isGzipEnabled) && this.properties.containsKey("upload.transformed-files-batch-size")) {
                    uploadBatchSize = this.properties.getIntProperty("upload.transformed-files-batch-size", 1000);
                }
                while (this.doAction && objectsToUpload.size() > 0) {
                    ArrayList<StorageObject> objectsForStandardPut = new ArrayList<StorageObject>();
                    ArrayList<StorageObject> objectsForMultipartUpload = new ArrayList<StorageObject>();
                    int maxBatchSize = Math.min(uploadBatchSize, objectsToUpload.size());
                    for (int i = 0; i < maxBatchSize; ++i) {
                        LazyPreparedUploadObject lazyObj = (LazyPreparedUploadObject)objectsToUpload.remove(0);
                        StorageObject object = null;
                        try {
                            object = lazyObj.prepareUploadObject();
                        }
                        catch (FileNotFoundException e) {
                            if (skipMissingFiles) {
                                this.printOutputLine("WARNING: Skipping unreadable file: " + lazyObj.getFile().getAbsolutePath(), 0);
                                continue;
                            }
                            throw e;
                        }
                        if (multipartUtils != null && multipartUtils.isFileLargerThanMaxPartSize(lazyObj.getFile())) {
                            objectsForMultipartUpload.add(object);
                            continue;
                        }
                        objectsForStandardPut.add(object);
                    }
                    if (objectsForStandardPut.size() > 0) {
                        new ThreadedStorageService(this.storageService, this.serviceEventAdaptor).putObjects(bucket.getName(), objectsForStandardPut.toArray(new StorageObject[0]));
                        this.serviceEventAdaptor.throwErrorIfPresent();
                    }
                    if (objectsForMultipartUpload.size() <= 0) continue;
                    multipartUtils.uploadObjects(bucket.getName(), (S3Service)this.storageService, objectsForMultipartUpload, this.serviceEventAdaptor);
                }
            } while (objectKeyIter.hasNext());
        } while (priorLastKey != null);
        ArrayList<StorageObject> objectsToDelete = new ArrayList<StorageObject>();
        Iterator<String> serverOnlyIter = mergedDiscrepancyResults.onlyOnServerKeys.iterator();
        while (serverOnlyIter.hasNext()) {
            String relativeKeyPath;
            String targetKey = relativeKeyPath = serverOnlyIter.next();
            if (rootObjectPath.length() > 0) {
                targetKey = rootObjectPath.endsWith(Constants.FILE_PATH_DELIM) ? rootObjectPath + targetKey : rootObjectPath + Constants.FILE_PATH_DELIM + targetKey;
            }
            StorageObject object = new StorageObject(targetKey);
            if (this.isKeepFiles || this.isNoDelete) {
                this.printOutputLine("d " + relativeKeyPath, 2);
                continue;
            }
            this.printOutputLine("D " + relativeKeyPath, 1);
            if (!this.doAction) continue;
            objectsToDelete.add(object);
        }
        if (objectsToDelete.size() > 0) {
            StorageObject[] objects = objectsToDelete.toArray(new StorageObject[objectsToDelete.size()]);
            new ThreadedStorageService(this.storageService, this.serviceEventAdaptor).deleteObjects(bucket.getName(), objects);
            this.serviceEventAdaptor.throwErrorIfPresent();
        }
        ArrayList<String> filesMoved = new ArrayList<String>();
        if (this.isMoveEnabled) {
            filesMoved.addAll(mergedDiscrepancyResults.onlyOnClientKeys);
            filesMoved.addAll(mergedDiscrepancyResults.updatedOnClientKeys);
            filesMoved.addAll(mergedDiscrepancyResults.updatedOnServerKeys);
            filesMoved.addAll(mergedDiscrepancyResults.alreadySynchronisedKeys);
            ArrayList<File> dirsToDelete = new ArrayList<File>();
            for (String keyPath : filesMoved) {
                file = new File(objectKeyToFilepathMap.get(keyPath));
                this.printOutputLine("M " + keyPath, 1);
                if (!this.doAction) continue;
                if (file.isDirectory()) {
                    dirsToDelete.add(file);
                    continue;
                }
                file.delete();
            }
            for (File dir : dirsToDelete) {
                dir.delete();
            }
        }
        this.printOutputLine((this.doAction ? "" : "[No Action] ") + "New files: " + mergedDiscrepancyResults.onlyOnClientKeys.size() + ", Updated: " + mergedDiscrepancyResults.updatedOnClientKeys.size() + (this.isKeepFiles ? ", Kept: " + mergedDiscrepancyResults.updatedOnServerKeys.size() : ", Reverted: " + mergedDiscrepancyResults.updatedOnServerKeys.size()) + (this.isNoDelete || this.isKeepFiles ? ", Not Deleted: " + mergedDiscrepancyResults.onlyOnServerKeys.size() : ", Deleted: " + mergedDiscrepancyResults.onlyOnServerKeys.size()) + (this.isForce ? ", Forced updates: " + mergedDiscrepancyResults.alreadySynchronisedKeys.size() : ", Unchanged: " + mergedDiscrepancyResults.alreadySynchronisedKeys.size()) + (this.isMoveEnabled ? ", Moved: " + filesMoved.size() : ""), 0);
    }

    public void restoreToLocalDirectory(Map<String, String> objectKeyToFilepathMap, String rootObjectPath, File localDirectory, StorageBucket bucket, BytesProgressWatcher md5GenerationProgressWatcher) throws Exception {
        FileComparerResults mergedDiscrepancyResults = new FileComparerResults();
        String priorLastKey = null;
        HashMap<String, StorageObject> objectsMoved = new HashMap<String, StorageObject>();
        do {
            ComparisonResult result = this.compareLocalAndRemoteFiles(mergedDiscrepancyResults, bucket.getName(), rootObjectPath, priorLastKey, objectKeyToFilepathMap, md5GenerationProgressWatcher);
            priorLastKey = result.priorLastKey;
            FileComparerResults discrepancyResults = result.discrepancyResults;
            Map<String, StorageObject> objectsMap = result.objectsMap;
            Iterator<String> objectKeyIter = objectsMap.keySet().iterator();
            do {
                ArrayList<DownloadPackage> downloadPackagesList = new ArrayList<DownloadPackage>();
                while (objectKeyIter.hasNext()) {
                    DownloadPackage downloadPackage;
                    String keyPath = objectKeyIter.next();
                    StorageObject object = objectsMap.get(keyPath);
                    String localPath = keyPath;
                    if (!object.isMetadataComplete() && object.getContentLength() == 0L && !object.isDirectoryPlaceholder()) continue;
                    File fileTarget = new File(localDirectory, keyPath);
                    if (object.isDirectoryPlaceholder()) {
                        localPath = ObjectUtils.convertDirPlaceholderKeyNameToDirName(keyPath);
                        fileTarget = new File(localDirectory, localPath);
                        if (this.doAction) {
                            fileTarget.mkdirs();
                        }
                    }
                    if (discrepancyResults.onlyOnServerKeys.contains(keyPath)) {
                        this.printOutputLine("N " + localPath, 1);
                        downloadPackage = ObjectUtils.createPackageForDownload(object, fileTarget, this.isGzipEnabled, this.isEncryptionEnabled, this.cryptoPassword);
                        if (downloadPackage != null) {
                            downloadPackagesList.add(downloadPackage);
                        }
                    } else if (discrepancyResults.updatedOnServerKeys.contains(keyPath)) {
                        this.printOutputLine("U " + localPath, 1);
                        downloadPackage = ObjectUtils.createPackageForDownload(object, fileTarget, this.isGzipEnabled, this.isEncryptionEnabled, this.cryptoPassword);
                        if (downloadPackage != null) {
                            downloadPackagesList.add(downloadPackage);
                        }
                    } else if (discrepancyResults.alreadySynchronisedKeys.contains(keyPath)) {
                        if (this.isForce) {
                            this.printOutputLine("F " + localPath, 1);
                            downloadPackage = ObjectUtils.createPackageForDownload(object, fileTarget, this.isGzipEnabled, this.isEncryptionEnabled, this.cryptoPassword);
                            if (downloadPackage != null) {
                                downloadPackagesList.add(downloadPackage);
                            }
                        } else {
                            this.printOutputLine("- " + localPath, 3);
                        }
                    } else if (discrepancyResults.updatedOnClientKeys.contains(keyPath)) {
                        if (this.isKeepFiles) {
                            this.printOutputLine("r " + localPath, 2);
                        } else {
                            this.printOutputLine("R " + localPath, 1);
                            downloadPackage = ObjectUtils.createPackageForDownload(object, fileTarget, this.isGzipEnabled, this.isEncryptionEnabled, this.cryptoPassword);
                            if (downloadPackage != null) {
                                downloadPackagesList.add(downloadPackage);
                            }
                        }
                    } else {
                        throw new SynchronizeException("Invalid discrepancy comparison details for object " + localPath + ". Sorry, this is a program error - aborting to keep your data safe");
                    }
                    if (this.isMoveEnabled) {
                        objectsMoved.put(localPath, object);
                    }
                    if (!this.isBatchMode || (long)downloadPackagesList.size() < 1000L) continue;
                    this.printOutputLine("Downloading batch of " + downloadPackagesList.size() + " objects", 1);
                    break;
                }
                if (!this.doAction || downloadPackagesList.size() <= 0) continue;
                DownloadPackage[] downloadPackages = downloadPackagesList.toArray(new DownloadPackage[downloadPackagesList.size()]);
                new ThreadedStorageService(this.storageService, this.serviceEventAdaptor).downloadObjects(bucket.getName(), downloadPackages);
                this.serviceEventAdaptor.throwErrorIfPresent();
            } while (objectKeyIter.hasNext());
        } while (priorLastKey != null);
        ArrayList<File> dirsToDelete = new ArrayList<File>();
        for (String keyPath : mergedDiscrepancyResults.onlyOnClientKeys) {
            File file = new File(objectKeyToFilepathMap.get(keyPath));
            if (this.isKeepFiles || this.isNoDelete) {
                this.printOutputLine("d " + keyPath, 2);
                continue;
            }
            this.printOutputLine("D " + keyPath, 1);
            if (!this.doAction) continue;
            if (file.isDirectory()) {
                dirsToDelete.add(file);
                continue;
            }
            file.delete();
        }
        for (File dir : dirsToDelete) {
            dir.delete();
        }
        if (this.isMoveEnabled) {
            ArrayList objectsMovedLocalPaths = new ArrayList(objectsMoved.size());
            objectsMovedLocalPaths.addAll(objectsMoved.keySet());
            Collections.sort(objectsMovedLocalPaths);
            for (String movedLocalPath : objectsMovedLocalPaths) {
                if (this.doAction) {
                    this.printOutputLine("M " + movedLocalPath, 1);
                    continue;
                }
                this.printOutputLine("m " + movedLocalPath, 1);
            }
            if (objectsMoved.size() > 0 && this.doAction) {
                StorageObject[] objects = objectsMoved.values().toArray(new StorageObject[objectsMoved.size()]);
                new ThreadedStorageService(this.storageService, this.serviceEventAdaptor).deleteObjects(bucket.getName(), objects);
                this.serviceEventAdaptor.throwErrorIfPresent();
            }
        }
        this.printOutputLine((this.doAction ? "" : "[No Action] ") + "New files: " + mergedDiscrepancyResults.onlyOnServerKeys.size() + ", Updated: " + mergedDiscrepancyResults.updatedOnServerKeys.size() + (this.isKeepFiles ? ", Kept: " + mergedDiscrepancyResults.updatedOnClientKeys.size() : ", Reverted: " + mergedDiscrepancyResults.updatedOnClientKeys.size()) + (this.isNoDelete || this.isKeepFiles ? ", Not Deleted: " + mergedDiscrepancyResults.onlyOnClientKeys.size() : ", Deleted: " + mergedDiscrepancyResults.onlyOnClientKeys.size()) + (this.isForce ? ", Forced updates: " + mergedDiscrepancyResults.alreadySynchronisedKeys.size() : ", Unchanged: " + mergedDiscrepancyResults.alreadySynchronisedKeys.size()) + (this.isMoveEnabled ? ", Moved: " + objectsMoved.size() : ""), 0);
    }

    public void run(String servicePath, File[] files, String actionCommand, String cryptoPassword, String aclString, String providerId) throws Exception {
        String bucketName = null;
        String objectPath = "";
        int slashIndex = servicePath.indexOf(Constants.FILE_PATH_DELIM);
        if (slashIndex >= 0) {
            bucketName = servicePath.substring(0, slashIndex);
            objectPath = servicePath.substring(slashIndex + 1, servicePath.length());
        } else {
            bucketName = servicePath;
        }
        if ("UP".equals(actionCommand)) {
            String uploadPathSummary = null;
            if (files.length > 1) {
                int dirsCount = 0;
                int filesCount = 0;
                for (File file : files) {
                    if (file.isDirectory()) {
                        ++dirsCount;
                        continue;
                    }
                    ++filesCount;
                }
                uploadPathSummary = "[" + dirsCount + (dirsCount == 1 ? " directory" : " directories") + ", " + filesCount + (filesCount == 1 ? " file" : " files") + "]";
            } else {
                uploadPathSummary = Arrays.toString(files);
            }
            this.printOutputLine("UP " + (this.doAction ? "" : "[No Action] ") + "Local " + uploadPathSummary + " => " + providerId + "[" + servicePath + "]", 0);
        } else if ("DOWN".equals(actionCommand)) {
            if (files.length != 1) {
                throw new SynchronizeException("Only one target directory is allowed for downloads");
            }
            this.printOutputLine("DOWN " + (this.doAction ? "" : "[No Action] ") + providerId + "[" + servicePath + "] => Local " + files[0], 0);
        } else {
            throw new SynchronizeException("Action string must be 'UP' or 'DOWN'");
        }
        this.cryptoPassword = cryptoPassword;
        StorageBucket bucket = null;
        if (this.storageService.getProviderCredentials() == null) {
            bucket = new StorageBucket(bucketName);
        } else {
            try {
                bucket = this.storageService.getBucket(bucketName);
            }
            catch (ServiceException e) {
                // empty catch block
            }
            if (bucket == null) {
                try {
                    bucket = this.storageService.createBucket(new StorageBucket(bucketName));
                }
                catch (ServiceException e) {
                    try {
                        this.storageService.listObjectsChunked(bucketName, null, null, 1L, null, false);
                        bucket = new StorageBucket(bucketName);
                    }
                    catch (ServiceException e2) {
                        throw new SynchronizeException("Unable to create or access bucket: " + bucketName, e);
                    }
                }
            }
        }
        boolean storeEmptyDirectories = this.properties.getBoolProperty("uploads.storeEmptyDirectories", true);
        this.printProgressLine("Listing files in local file system");
        Map<String, String> objectKeyToFilepathMap = null;
        if ("UP".equals(actionCommand)) {
            for (File file : files) {
                if (file.exists()) continue;
                throw new IOException("File '" + file.getPath() + "' does not exist");
            }
            objectKeyToFilepathMap = this.fileComparer.buildObjectKeyToFilepathMap(files, "", storeEmptyDirectories);
        } else if ("DOWN".equals(actionCommand)) {
            File[] filesInTargetDir = files[0].listFiles();
            if (filesInTargetDir == null) {
                throw new IOException("Unable to list files in download target directory: " + files[0].getAbsolutePath());
            }
            objectKeyToFilepathMap = this.fileComparer.buildObjectKeyToFilepathMap(filesInTargetDir, "", storeEmptyDirectories);
        }
        long[] filesSizeTotal = new long[]{0L};
        BytesProgressWatcher md5GenerationProgressWatcher = new BytesProgressWatcher(filesSizeTotal[0]){

            public void updateBytesTransferred(long byteCount) {
                super.updateBytesTransferred(byteCount);
                Synchronize.this.printProgressLine("Comparing files: " + Synchronize.this.byteFormatter.formatByteSize(super.getBytesTransferred()));
            }
        };
        if ("UP".equals(actionCommand)) {
            this.uploadLocalDirectory(objectKeyToFilepathMap, bucket, objectPath, aclString, md5GenerationProgressWatcher);
        } else if ("DOWN".equals(actionCommand)) {
            this.restoreToLocalDirectory(objectKeyToFilepathMap, objectPath, files[0], bucket, md5GenerationProgressWatcher);
        }
    }

    public void run(String servicePath, List<File> files, String actionCommand, String cryptoPassword, String aclString, String providerId) throws Exception {
        File[] filesArray = files.toArray(new File[files.size()]);
        this.run(servicePath, filesArray, actionCommand, cryptoPassword, aclString, providerId);
    }

    private void displayProgressStatus(String prefix, ThreadWatcher watcher) {
        String progressMessage = prefix + watcher.getCompletedThreads() + "/" + watcher.getThreadCount();
        if (watcher.isBytesTransferredInfoAvailable()) {
            String bytesTotalStr = this.byteFormatter.formatByteSize(watcher.getBytesTotal());
            long percentage = (int)((double)watcher.getBytesTransferred() / (double)watcher.getBytesTotal() * 100.0);
            String detailsText = this.formatTransferDetails(watcher);
            progressMessage = progressMessage + " - " + percentage + "% of " + bytesTotalStr + (detailsText.length() > 0 ? " (" + detailsText + ")" : "");
        } else {
            long percentage = (int)((double)watcher.getCompletedThreads() / (double)watcher.getThreadCount() * 100.0);
            progressMessage = progressMessage + " - " + percentage + "%";
        }
        this.printProgressLine(progressMessage);
    }

    private static void printHelpAndExit(boolean fullHelp) {
        System.out.println();
        System.out.println("Usage: Synchronize [options] UP <Path> <File/Directory> (<File/Directory>...)");
        System.out.println("   or: Synchronize [options] DOWN <Path> <DownloadDirectory>");
        System.out.println("");
        System.out.println("UP      : Synchronize the contents of the Local Directory with a service.");
        System.out.println("DOWN    : Synchronize the contents of a service with the Local Directory");
        System.out.println("Path    : A path to the resource. This must include at least the");
        System.out.println("          bucket name, but may also specify a path inside the bucket.");
        System.out.println("          E.g. <bucketName>/Backups/Documents/20060623");
        System.out.println("File/Directory : A file or directory on your computer to upload");
        System.out.println("DownloadDirectory : A directory on your computer where downloaded files");
        System.out.println("          will be stored");
        System.out.println();
        System.out.println("Required properties can be provided via: a file named 'synchronize.properties'");
        System.out.println("in the classpath, a file specified with the --properties option, or by typing");
        System.out.println("them in when prompted on the command line. Required properties are:");
        System.out.println("          accesskey : Your Access Key (Required)");
        System.out.println("          secretkey : Your Secret Key (Required)");
        System.out.println("          password  : Encryption password (only required when using crypto)");
        System.out.println("Properties specified in this file will override those in jets3t.properties.");
        if (!fullHelp) {
            System.out.println("");
            System.out.println("For more help : Synchronize --help");
            System.exit(1);
        }
        System.out.println("");
        System.out.println("Options");
        System.out.println("-------");
        System.out.println("-h | --help");
        System.out.println("   Displays this help message.");
        System.out.println("");
        System.out.println("--provider <provider id>");
        System.out.println("   Service provider, either 'S3' for Amazon S3 or 'GS' for Google Storage");
        System.out.println("");
        System.out.println("-n | --noaction");
        System.out.println("   No action taken. No files will be changed locally or on service, instead");
        System.out.println("   a report will be generating showing what will happen if the command");
        System.out.println("   is run without the -n option.");
        System.out.println("");
        System.out.println("-q | --quiet");
        System.out.println("   Runs quietly, without reporting on each action performed or displaying");
        System.out.println("   progress messages. The summary is still displayed.");
        System.out.println("");
        System.out.println("-p | --noprogress");
        System.out.println("   Runs somewhat quietly, without displaying progress messages.");
        System.out.println("   The action report and overall summary are still displayed.");
        System.out.println("");
        System.out.println("-f | --force");
        System.out.println("   Force tool to perform synchronization even when files are up-to-date.");
        System.out.println("   This may be useful if you need to update metadata or timestamps online.");
        System.out.println("");
        System.out.println("-k | --keepfiles");
        System.out.println("   Keep outdated files on destination instead of reverting/removing them.");
        System.out.println("   This option cannot be used with --nodelete.");
        System.out.println("");
        System.out.println("-d | --nodelete");
        System.out.println("   Keep files on destination that have been removed from the source. This");
        System.out.println("   option is similar to --keepfiles except that files may be reverted.");
        System.out.println("   This option cannot be used with --keepfiles.");
        System.out.println("");
        System.out.println("-m | --move");
        System.out.println("   Move items rather than merely copying them. Files on the local computer will");
        System.out.println("   be deleted after they have been uploaded to service, or objects will be deleted");
        System.out.println("   from service after they have been downloaded. Be *very* careful with this option.");
        System.out.println("   This option cannot be used with --keepfiles.");
        System.out.println("");
        System.out.println("-b | --batch");
        System.out.println("   Download or upload files in batches, rather than all at once. Enabling this");
        System.out.println("   option will reduce the memory required to synchronize large buckets, and will");
        System.out.println("   ensure file transfers commence as soon as possible. When this option is");
        System.out.println("   enabled, the progress status lines refer only to the progress of a single batch.");
        System.out.println("");
        System.out.println("-g | --gzip");
        System.out.println("   Compress (GZip) files when backing up and Decompress gzipped files");
        System.out.println("   when restoring.");
        System.out.println("");
        System.out.println("-c | --crypto");
        System.out.println("   Encrypt files when backing up and decrypt encrypted files when restoring. If");
        System.out.println("   this option is specified the properties must contain a password.");
        System.out.println("");
        System.out.println("--properties <filename>");
        System.out.println("   Load the synchronizer app properties from the given file rather than from");
        System.out.println("   a synchronizer.properties file in the classpath.");
        System.out.println("");
        System.out.println("--credentials <filename>");
        System.out.println("   Load your service credentials from an encrypted file, rather than from the");
        System.out.println("   synchronizer.properties file. This encrypted file can be created using");
        System.out.println("   the Cockpit application, or the JetS3t API library.");
        System.out.println("");
        System.out.println("--acl <ACL string>");
        System.out.println("   Specifies the Access Control List setting to apply. This value must be one");
        System.out.println("   of: PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE. This setting will override any");
        System.out.println("   acl property specified in the synchronize.properties file");
        System.out.println("");
        System.out.println("--reportlevel <Level>");
        System.out.println("   A number that specifies how much report information will be printed:");
        System.out.println("   0 - no report items will be printed (the summary will still be printed)");
        System.out.println("   1 - only actions are reported          [Prefixes N, U, D, R, F, M]");
        System.out.println("   2 - differences & actions are reported [Prefixes N, U, D, R, F, M, d, r]");
        System.out.println("   3 - DEFAULT: all items are reported    [Prefixes N, U, D, R, F, M, d, r, -]");
        System.out.println("");
        System.out.println("Report");
        System.out.println("------");
        System.out.println("Report items are printed on a single line with an action flag followed by");
        System.out.println("the relative path of the file or object. The report legend follows:");
        System.out.println("");
        System.out.println("N: A new file/object will be created");
        System.out.println("U: An existing file/object has changed and will be updated");
        System.out.println("D: A file/object existing on the target does not exist on the source and");
        System.out.println("   will be deleted.");
        System.out.println("d: A file/object existing on the target does not exist on the source but");
        System.out.println("   because the --keepfiles or --nodelete option was set it was not deleted.");
        System.out.println("R: An existing file/object has changed more recently on the target than on the");
        System.out.println("   source. The target version will be reverted to the older source version");
        System.out.println("r: An existing file/object has changed more recently on the target than on the");
        System.out.println("   source but because the --keepfiles option was set it was not reverted.");
        System.out.println("-: A file is identical between the local system and service, no action is necessary.");
        System.out.println("F: A file identical locally and in service was updated due to the Force option.");
        System.out.println("M: The file/object will be moved (deleted after it has been copied to/from service).");
        System.out.println();
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        Jets3tProperties myProperties = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME);
        String propertiesFileName = "synchronize.properties";
        Jets3tProperties synchronizeProperties = Jets3tProperties.getInstance(propertiesFileName);
        if (synchronizeProperties.isLoaded()) {
            myProperties.loadAndReplaceProperties(synchronizeProperties, propertiesFileName + " in classpath");
        }
        String actionCommand = null;
        String servicePath = null;
        int reqArgCount = 0;
        HashSet<File> fileSet = new HashSet<File>();
        boolean doAction = true;
        boolean isQuiet = false;
        boolean isNoProgress = false;
        boolean isForce = false;
        boolean isKeepFiles = false;
        boolean isNoDelete = false;
        boolean isGzipEnabled = false;
        boolean isEncryptionEnabled = false;
        boolean isMoveEnabled = false;
        boolean isBatchMode = false;
        String aclString = null;
        int reportLevel = 3;
        ProviderCredentials providerCredentials = null;
        String providerId = "S3";
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                if (arg.equalsIgnoreCase("-h") || arg.equalsIgnoreCase("--help")) {
                    Synchronize.printHelpAndExit(true);
                    continue;
                }
                if (arg.equalsIgnoreCase("-n") || arg.equalsIgnoreCase("--noaction")) {
                    doAction = false;
                    continue;
                }
                if (arg.equalsIgnoreCase("-q") || arg.equalsIgnoreCase("--quiet")) {
                    isQuiet = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-p") || arg.equalsIgnoreCase("--noprogress")) {
                    isNoProgress = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-f") || arg.equalsIgnoreCase("--force")) {
                    isForce = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-k") || arg.equalsIgnoreCase("--keepfiles")) {
                    isKeepFiles = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-d") || arg.equalsIgnoreCase("--nodelete")) {
                    isNoDelete = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-g") || arg.equalsIgnoreCase("--gzip")) {
                    isGzipEnabled = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-c") || arg.equalsIgnoreCase("--crypto")) {
                    isEncryptionEnabled = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-m") || arg.equalsIgnoreCase("--move")) {
                    isMoveEnabled = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-s") || arg.equalsIgnoreCase("--skipmetadata")) {
                    System.err.println("WARNING: --skipmetadata is obsolete since JetS3t 0.8.1, it has no effect");
                    continue;
                }
                if (arg.equalsIgnoreCase("-b") || arg.equalsIgnoreCase("--batch")) {
                    isBatchMode = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("--provider")) {
                    if (i + 1 < args.length) {
                        if ("S3".equalsIgnoreCase(providerId = args[++i]) || "GS".equalsIgnoreCase(providerId)) continue;
                        System.err.println("ERROR: --provider option must be one of 'S3' or 'GS'");
                        Synchronize.printHelpAndExit(false);
                        continue;
                    }
                    System.err.println("ERROR: --provider option must be followed by a provider ID 'S3' or 'GS'");
                    Synchronize.printHelpAndExit(false);
                    continue;
                }
                if (arg.equalsIgnoreCase("--properties")) {
                    if (i + 1 < args.length) {
                        File propertiesFile;
                        if (!(propertiesFile = new File(propertiesFileName = args[++i])).canRead()) {
                            System.err.println("ERROR: The properties file " + propertiesFileName + " could not be found");
                            System.exit(2);
                        }
                        myProperties.loadAndReplaceProperties(new FileInputStream(propertiesFileName), propertiesFile.getName());
                        continue;
                    }
                    System.err.println("ERROR: --properties option must be followed by a file path");
                    Synchronize.printHelpAndExit(false);
                    continue;
                }
                if (arg.equalsIgnoreCase("--acl")) {
                    if (i + 1 < args.length) {
                        if ("PUBLIC_READ".equalsIgnoreCase(aclString = args[++i]) || "PUBLIC_READ_WRITE".equalsIgnoreCase(aclString) || "PRIVATE".equalsIgnoreCase(aclString)) continue;
                        System.err.println("ERROR: Acess Control List setting \"acl\" must have one of the values PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE");
                        Synchronize.printHelpAndExit(false);
                        continue;
                    }
                    System.err.println("ERROR: --acl option must be followed by an ACL string");
                    Synchronize.printHelpAndExit(false);
                    continue;
                }
                if (arg.equalsIgnoreCase("--reportlevel")) {
                    if (i + 1 < args.length) {
                        ++i;
                        try {
                            reportLevel = Integer.parseInt(args[i]);
                            if (reportLevel >= 0 && reportLevel <= 3) continue;
                            System.err.println("ERROR: Report Level setting \"reportlevel\" must have one of the values 0 (no reporting), 1 (actions only), 2 (differences only), 3 (DEFAULT - all reporting)");
                            Synchronize.printHelpAndExit(false);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("ERROR: --reportlevel option must be followed by 0, 1, 2 or 3");
                            Synchronize.printHelpAndExit(false);
                        }
                        continue;
                    }
                    System.err.println("ERROR: --reportlevel option must be followed by 0, 1, 2 or 3");
                    Synchronize.printHelpAndExit(false);
                    continue;
                }
                if (arg.equalsIgnoreCase("--credentials")) {
                    if (i + 1 < args.length) {
                        File credentialsFile;
                        if (!(credentialsFile = new File(args[++i])).canRead()) {
                            System.err.println("ERROR: Cannot read credentials file '" + credentialsFile + "'");
                            Synchronize.printHelpAndExit(false);
                        }
                        while (providerCredentials == null) {
                            String credentialsPassword = PasswordInput.getPassword("Password for credentials file '" + credentialsFile + "'");
                            try {
                                providerCredentials = ProviderCredentials.load(credentialsPassword, credentialsFile);
                                myProperties.setProperty("accesskey", "");
                                myProperties.setProperty("secretkey", "");
                            }
                            catch (ServiceException e) {
                                System.out.println("Failed to read credentials from the file '" + credentialsFile + "'");
                            }
                        }
                        continue;
                    }
                    System.err.println("ERROR: --credentials option must be followed by a file path");
                    Synchronize.printHelpAndExit(false);
                    continue;
                }
                System.err.println("ERROR: Invalid option: " + arg);
                Synchronize.printHelpAndExit(false);
                continue;
            }
            if (reqArgCount == 0) {
                actionCommand = arg.toUpperCase(Locale.getDefault());
                if (!"UP".equals(actionCommand) && !"DOWN".equals(actionCommand)) {
                    System.err.println("ERROR: Invalid action command " + actionCommand + ". Valid values are 'UP' or 'DOWN'");
                    Synchronize.printHelpAndExit(false);
                }
            } else if (reqArgCount == 1) {
                servicePath = arg;
            } else if (reqArgCount > 1) {
                File file = new File(arg);
                if ("DOWN".equals(actionCommand)) {
                    if (reqArgCount > 2) {
                        System.err.println("ERROR: Only one target directory may be specified for " + actionCommand);
                        Synchronize.printHelpAndExit(false);
                    }
                    if (!file.exists() && !file.mkdirs()) {
                        System.err.println("ERROR: Target download directory does not exist and could not be created: " + file);
                        System.exit(1);
                    }
                    if (file.exists() && !file.isDirectory()) {
                        System.err.println("ERROR: Target download location already exists but is not a directory: " + file);
                        System.exit(1);
                    }
                    if (!file.canWrite() || !file.canWrite()) {
                        System.err.println("ERROR: Invalid permissions on target download location, cannot " + (!file.canRead() ? "read from" + (!file.canWrite() ? " or " : "") : "") + (!file.canWrite() ? "write to" : "") + " directory: " + file.getAbsolutePath());
                        System.exit(1);
                    }
                    if (!file.canWrite()) {
                        System.err.println("ERROR: Cannot write to target download location: " + file);
                        System.exit(1);
                    }
                } else if (!file.canRead()) {
                    if (myProperties != null && myProperties.getBoolProperty("upload.ignoreMissingPaths", false)) {
                        System.err.println("WARN: Ignoring missing upload path: " + file);
                        continue;
                    }
                    System.err.println("ERROR: Cannot read upload file/directory: " + file + "\n" + "       To ignore missing paths set the property upload.ignoreMissingPaths");
                    Synchronize.printHelpAndExit(false);
                }
                fileSet.add(file);
            }
            ++reqArgCount;
        }
        if (fileSet.size() < 1 && !myProperties.getBoolProperty("upload.ignoreMissingPaths", false)) {
            System.err.println("ERROR: Missing required file path(s)");
            Synchronize.printHelpAndExit(false);
        }
        if (isKeepFiles && isNoDelete) {
            System.err.println("ERROR: Options --keepfiles and --nodelete cannot be used at the same time");
            Synchronize.printHelpAndExit(false);
        }
        if (isKeepFiles && isMoveEnabled) {
            System.err.println("ERROR: Options --keepfiles and --move cannot be used at the same time");
            Synchronize.printHelpAndExit(false);
        }
        if (!myProperties.containsKey("accesskey") || !myProperties.containsKey("secretkey") || isEncryptionEnabled && !myProperties.containsKey("password")) {
            System.out.println("Please enter the required properties that have not been provided in a properties file:");
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(System.in));
            if (!myProperties.containsKey("accesskey")) {
                System.out.print("Acccess Key: ");
                myProperties.setProperty("accesskey", inputReader.readLine());
            }
            if (!myProperties.containsKey("secretkey")) {
                System.out.print("Secret Key: ");
                myProperties.setProperty("secretkey", inputReader.readLine());
            }
            if (isEncryptionEnabled && !myProperties.containsKey("password")) {
                String password1 = "password1";
                String password2 = "password2";
                while (!password1.equals(password2)) {
                    password1 = PasswordInput.getPassword("Encryption password");
                    if (password1.equals(password2 = PasswordInput.getPassword("Confirm password"))) continue;
                    System.out.println("The original and confirmation passwords do not match, try again.");
                }
                myProperties.setProperty("password", password1);
            }
        }
        if (providerCredentials == null) {
            if ("S3".equalsIgnoreCase(providerId)) {
                providerCredentials = new AWSCredentials(myProperties.getStringProperty("accesskey", null), myProperties.getStringProperty("secretkey", null));
            } else if ("GS".equalsIgnoreCase(providerId)) {
                providerCredentials = new GSCredentials(myProperties.getStringProperty("accesskey", null), myProperties.getStringProperty("secretkey", null));
            }
        }
        if (providerCredentials.getAccessKey() == null || providerCredentials.getAccessKey().length() == 0 || providerCredentials.getSecretKey() == null || providerCredentials.getSecretKey().length() == 0) {
            providerCredentials = null;
        }
        if (aclString == null) {
            aclString = myProperties.getStringProperty("acl", "PRIVATE");
        }
        if (!("PUBLIC_READ".equalsIgnoreCase(aclString) || "PUBLIC_READ_WRITE".equalsIgnoreCase(aclString) || "PRIVATE".equalsIgnoreCase(aclString))) {
            System.err.println("ERROR: Acess Control List setting \"acl\" must have one of the values PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE");
            System.exit(2);
        }
        RestStorageService service = null;
        if ("S3".equalsIgnoreCase(providerId)) {
            service = new RestS3Service(providerCredentials, APPLICATION_DESCRIPTION, new CommandLineCredentialsProvider(), myProperties);
        } else if ("GS".equalsIgnoreCase(providerId)) {
            service = new GoogleStorageService(providerCredentials, APPLICATION_DESCRIPTION, new CommandLineCredentialsProvider(), myProperties);
        }
        Synchronize client = new Synchronize(service, doAction, isQuiet, isNoProgress, isForce, isKeepFiles, isNoDelete, isMoveEnabled, isBatchMode, isGzipEnabled, isEncryptionEnabled, reportLevel, myProperties);
        client.run(servicePath, fileSet.toArray(new File[fileSet.size()]), actionCommand, myProperties.getStringProperty("password", null), aclString, providerId.toUpperCase());
    }

    private class ComparisonResult {
        public String priorLastKey;
        public FileComparerResults discrepancyResults;
        public Map<String, StorageObject> objectsMap;

        private ComparisonResult() {
        }
    }

    class LazyPreparedUploadObject {
        private final String targetKey;
        private final File file;
        private byte[] md5HashOfFile;
        private final String aclString;
        private final EncryptionUtil encryptionUtil;

        public LazyPreparedUploadObject(String targetKey, File file, byte[] md5HashOfFile, String aclString, EncryptionUtil encryptionUtil) {
            this.targetKey = targetKey;
            this.file = file;
            this.md5HashOfFile = md5HashOfFile;
            this.aclString = aclString;
            this.encryptionUtil = encryptionUtil;
        }

        public StorageObject prepareUploadObject() throws Exception {
            S3Object newObject = ObjectUtils.createObjectForUpload(this.targetKey, this.file, this.md5HashOfFile, this.encryptionUtil, Synchronize.this.isGzipEnabled, null);
            if ("PUBLIC_READ".equalsIgnoreCase(this.aclString)) {
                ((StorageObject)newObject).setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
            } else if ("PUBLIC_READ_WRITE".equalsIgnoreCase(this.aclString)) {
                ((StorageObject)newObject).setAcl(AccessControlList.REST_CANNED_PUBLIC_READ_WRITE);
            } else if (!"PRIVATE".equalsIgnoreCase(this.aclString)) {
                throw new Exception("Invalid value for ACL string: " + this.aclString);
            }
            newObject.addAllMetadata(Synchronize.this.customMetadata);
            return newObject;
        }

        public File getFile() {
            return this.file;
        }
    }
}

