/*
 * Decompiled with CFR 0.152.
 */
package io.druid.utils;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.metamx.common.ISE;
import com.metamx.common.StreamUtils;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.logger.Logger;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CompressionUtils {
    private static final Logger log = new Logger(CompressionUtils.class);

    public static long zip(File directory, File outputZipFile) throws IOException {
        if (!outputZipFile.getName().endsWith(".zip")) {
            log.warn("No .zip suffix[%s], putting files from [%s] into it anyway.", new Object[]{outputZipFile, directory});
        }
        try (FileOutputStream out = new FileOutputStream(outputZipFile);){
            long l = CompressionUtils.zip(directory, out);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long zip(File directory, OutputStream out) throws IOException {
        if (!directory.isDirectory()) {
            throw new IOException(String.format("directory[%s] is not a directory", directory));
        }
        long totalSize = 0L;
        ZipOutputStream zipOut = null;
        try {
            File[] files;
            zipOut = new ZipOutputStream(out);
            for (File file : files = directory.listFiles()) {
                log.info("Adding file[%s] with size[%,d].  Total size so far[%,d]", new Object[]{file, file.length(), totalSize});
                if (file.length() >= Integer.MAX_VALUE) {
                    zipOut.finish();
                    throw new IOException(String.format("file[%s] too large [%,d]", file, file.length()));
                }
                zipOut.putNextEntry(new ZipEntry(file.getName()));
                totalSize += ByteStreams.copy((InputSupplier)Files.newInputStreamSupplier((File)file), (OutputStream)zipOut);
            }
            zipOut.closeEntry();
        }
        finally {
            if (zipOut != null) {
                zipOut.finish();
            }
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File pulledFile, File outDir) throws IOException {
        if (!outDir.exists() || !outDir.isDirectory()) {
            throw new ISE("outDir[%s] must exist and be a directory", new Object[]{outDir});
        }
        log.info("Unzipping file[%s] to [%s]", new Object[]{pulledFile, outDir});
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(pulledFile));
            CompressionUtils.unzip(in, outDir);
        }
        catch (Throwable throwable) {
            CloseQuietly.close(in);
            throw throwable;
        }
        CloseQuietly.close((Closeable)in);
    }

    public static void unzip(InputStream in, File outDir) throws IOException {
        ZipEntry entry;
        ZipInputStream zipIn = new ZipInputStream(in);
        while ((entry = zipIn.getNextEntry()) != null) {
            FileOutputStream out = new FileOutputStream(new File(outDir, entry.getName()));
            Throwable throwable = null;
            try {
                ByteStreams.copy((InputStream)zipIn, (OutputStream)out);
                zipIn.closeEntry();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    public static void gunzip(File pulledFile, File outDir) throws IOException {
        log.info("Gunzipping file[%s] to [%s]", new Object[]{pulledFile, outDir});
        StreamUtils.copyToFileAndClose((InputStream)new GZIPInputStream(new FileInputStream(pulledFile)), (File)outDir);
        if (!pulledFile.delete()) {
            log.error("Could not delete tmpFile[%s].", new Object[]{pulledFile});
        }
    }
}

