/*
 * Decompiled with CFR 0.152.
 */
package io.druid.timeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.metamx.common.Granularity;
import io.druid.jackson.CommaListJoinDeserializer;
import io.druid.jackson.CommaListJoinSerializer;
import io.druid.query.SegmentDescriptor;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.ShardSpec;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class DataSegment
implements Comparable<DataSegment> {
    public static String delimiter = "_";
    private final Integer binaryVersion;
    private final String dataSource;
    private final Interval interval;
    private final String version;
    private final Map<String, Object> loadSpec;
    private final List<String> dimensions;
    private final List<String> metrics;
    private final ShardSpec shardSpec;
    private final long size;
    private final String identifier;

    public static String makeDataSegmentIdentifier(String dataSource, DateTime start, DateTime end, String version, ShardSpec shardSpec) {
        StringBuilder sb = new StringBuilder();
        sb.append(dataSource).append(delimiter).append(start).append(delimiter).append(end).append(delimiter).append(version);
        if (shardSpec.getPartitionNum() != 0) {
            sb.append(delimiter).append(shardSpec.getPartitionNum());
        }
        return sb.toString();
    }

    @JsonCreator
    public DataSegment(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JsonProperty(value="loadSpec") Map<String, Object> loadSpec, @JsonProperty(value="dimensions") @JsonDeserialize(using=CommaListJoinDeserializer.class) List<String> dimensions, @JsonProperty(value="metrics") @JsonDeserialize(using=CommaListJoinDeserializer.class) List<String> metrics, @JsonProperty(value="shardSpec") ShardSpec shardSpec, @JsonProperty(value="binaryVersion") Integer binaryVersion, @JsonProperty(value="size") long size) {
        Predicate<String> nonEmpty = new Predicate<String>(){

            public boolean apply(String input) {
                return input != null && !input.isEmpty();
            }
        };
        this.dataSource = dataSource.toLowerCase();
        this.interval = interval;
        this.loadSpec = loadSpec;
        this.version = version;
        this.dimensions = dimensions == null ? ImmutableList.of() : ImmutableList.copyOf((Iterable)Iterables.filter(dimensions, (Predicate)nonEmpty));
        this.metrics = metrics == null ? ImmutableList.of() : ImmutableList.copyOf((Iterable)Iterables.filter(metrics, (Predicate)nonEmpty));
        this.shardSpec = shardSpec == null ? new NoneShardSpec() : shardSpec;
        this.binaryVersion = binaryVersion;
        this.size = size;
        this.identifier = DataSegment.makeDataSegmentIdentifier(this.dataSource, this.interval.getStart(), this.interval.getEnd(), this.version, this.shardSpec);
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public Map<String, Object> getLoadSpec() {
        return this.loadSpec;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    @JsonSerialize(using=CommaListJoinSerializer.class)
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    @JsonSerialize(using=CommaListJoinSerializer.class)
    public List<String> getMetrics() {
        return this.metrics;
    }

    @JsonProperty
    public ShardSpec getShardSpec() {
        return this.shardSpec;
    }

    @JsonProperty
    public Integer getBinaryVersion() {
        return this.binaryVersion;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @JsonProperty
    public String getIdentifier() {
        return this.identifier;
    }

    public SegmentDescriptor toDescriptor() {
        return new SegmentDescriptor(this.interval, this.version, this.shardSpec.getPartitionNum());
    }

    public DataSegment withLoadSpec(Map<String, Object> loadSpec) {
        return DataSegment.builder(this).loadSpec(loadSpec).build();
    }

    public DataSegment withDimensions(List<String> dimensions) {
        return DataSegment.builder(this).dimensions(dimensions).build();
    }

    public DataSegment withSize(long size) {
        return DataSegment.builder(this).size(size).build();
    }

    public DataSegment withVersion(String version) {
        return DataSegment.builder(this).version(version).build();
    }

    public DataSegment withBinaryVersion(int binaryVersion) {
        return DataSegment.builder(this).binaryVersion(binaryVersion).build();
    }

    @Override
    public int compareTo(DataSegment dataSegment) {
        return this.getIdentifier().compareTo(dataSegment.getIdentifier());
    }

    public boolean equals(Object o) {
        if (o instanceof DataSegment) {
            return this.getIdentifier().equals(((DataSegment)o).getIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public String toString() {
        return "DataSegment{size=" + this.size + ", shardSpec=" + this.shardSpec + ", metrics=" + this.metrics + ", dimensions=" + this.dimensions + ", version='" + this.version + '\'' + ", loadSpec=" + this.loadSpec + ", interval=" + this.interval + ", dataSource='" + this.dataSource + '\'' + ", binaryVersion='" + this.binaryVersion + '\'' + '}';
    }

    public static Comparator<DataSegment> bucketMonthComparator() {
        return new Comparator<DataSegment>(){

            @Override
            public int compare(DataSegment lhs, DataSegment rhs) {
                DateTime rhsMonth;
                DateTime lhsMonth = Granularity.MONTH.truncate(lhs.getInterval().getStart());
                int retVal = lhsMonth.compareTo((Object)(rhsMonth = Granularity.MONTH.truncate(rhs.getInterval().getStart())));
                if (retVal != 0) {
                    return retVal;
                }
                return lhs.compareTo(rhs);
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataSegment segment) {
        return new Builder(segment);
    }

    public static class Builder {
        private String dataSource;
        private Interval interval;
        private String version;
        private Map<String, Object> loadSpec;
        private List<String> dimensions;
        private List<String> metrics;
        private ShardSpec shardSpec;
        private Integer binaryVersion;
        private long size;

        public Builder() {
            this.loadSpec = ImmutableMap.of();
            this.dimensions = ImmutableList.of();
            this.metrics = ImmutableList.of();
            this.shardSpec = new NoneShardSpec();
            this.size = -1L;
        }

        public Builder(DataSegment segment) {
            this.dataSource = segment.getDataSource();
            this.interval = segment.getInterval();
            this.version = segment.getVersion();
            this.loadSpec = segment.getLoadSpec();
            this.dimensions = segment.getDimensions();
            this.metrics = segment.getMetrics();
            this.shardSpec = segment.getShardSpec();
            this.binaryVersion = segment.getBinaryVersion();
            this.size = segment.getSize();
        }

        public Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder interval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder loadSpec(Map<String, Object> loadSpec) {
            this.loadSpec = loadSpec;
            return this;
        }

        public Builder dimensions(List<String> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder metrics(List<String> metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder shardSpec(ShardSpec shardSpec) {
            this.shardSpec = shardSpec;
            return this;
        }

        public Builder binaryVersion(Integer binaryVersion) {
            this.binaryVersion = binaryVersion;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public DataSegment build() {
            Preconditions.checkNotNull((Object)this.dataSource, (Object)"dataSource");
            Preconditions.checkNotNull((Object)this.interval, (Object)"interval");
            Preconditions.checkNotNull((Object)this.version, (Object)"version");
            Preconditions.checkNotNull((Object)this.shardSpec, (Object)"shardSpec");
            return new DataSegment(this.dataSource, this.interval, this.version, this.loadSpec, this.dimensions, this.metrics, this.shardSpec, this.binaryVersion, this.size);
        }
    }
}

