/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.common.collect.Lists;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.logger.Logger;
import java.util.List;

public class LifecycleScope
implements Scope {
    private static final Logger log = new Logger(LifecycleScope.class);
    private final Lifecycle.Stage stage;
    private Lifecycle lifecycle;
    private List<Object> instances = Lists.newLinkedList();

    public LifecycleScope(Lifecycle.Stage stage) {
        this.stage = stage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
        List<Object> list = this.instances;
        synchronized (list) {
            for (Object instance : this.instances) {
                lifecycle.addManagedInstance(instance);
            }
        }
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){
            private volatile T value = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized T get() {
                if (this.value == null) {
                    Object retVal = unscoped.get();
                    List list = LifecycleScope.this.instances;
                    synchronized (list) {
                        if (LifecycleScope.this.lifecycle == null) {
                            LifecycleScope.this.instances.add(retVal);
                        } else {
                            try {
                                LifecycleScope.this.lifecycle.addMaybeStartManagedInstance(retVal, LifecycleScope.this.stage);
                            }
                            catch (Exception e) {
                                log.warn((Throwable)e, "Caught exception when trying to create a[%s]", new Object[]{key});
                                return null;
                            }
                        }
                    }
                    this.value = retVal;
                }
                return this.value;
            }
        };
    }
}

