/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.metamx.common.logger.Logger;
import com.metamx.common.parsers.ParseException;
import com.metamx.common.parsers.Parser;
import com.metamx.common.parsers.ToLowerCaseParser;
import io.druid.data.input.ByteBufferInputRowParser;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.DataSpec;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.JSONParseSpec;
import io.druid.data.input.impl.MapInputRowParser;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.SpatialDimensionSchema;
import io.druid.data.input.impl.TimestampSpec;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import java.util.Map;

public class StringInputRowParser
implements ByteBufferInputRowParser {
    private static final Logger log = new Logger(StringInputRowParser.class);
    private final ParseSpec parseSpec;
    private final MapInputRowParser mapParser;
    private final Parser<String, Object> parser;
    private CharBuffer chars = null;

    @JsonCreator
    public StringInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="data") DataSpec dataSpec, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="dimensionExclusions") List<String> dimensionExclusions) {
        if (parseSpec == null) {
            this.parseSpec = dataSpec == null ? new JSONParseSpec(timestampSpec, new DimensionsSpec(dimensions, dimensionExclusions, (List<SpatialDimensionSchema>)ImmutableList.of())) : dataSpec.toParseSpec(timestampSpec, dimensionExclusions);
            this.mapParser = new MapInputRowParser(this.parseSpec, null, null, null, null);
            this.parser = new ToLowerCaseParser(this.parseSpec.makeParser());
        } else {
            this.parseSpec = parseSpec;
            this.mapParser = new MapInputRowParser(parseSpec, null, null, null, null);
            this.parser = new ToLowerCaseParser(parseSpec.makeParser());
        }
    }

    @Override
    public InputRow parse(ByteBuffer input) {
        return this.parseMap(this.buildStringKeyMap(input));
    }

    @Override
    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @Override
    public StringInputRowParser withParseSpec(ParseSpec parseSpec) {
        return new StringInputRowParser(parseSpec, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> buildStringKeyMap(ByteBuffer input) {
        Map<String, Object> theMap;
        CoderResult coderResult;
        int payloadSize = input.remaining();
        if (this.chars == null || this.chars.remaining() < payloadSize) {
            this.chars = CharBuffer.allocate(payloadSize);
        }
        if ((coderResult = Charsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(input, this.chars, true)).isUnderflow()) {
            this.chars.flip();
            try {
                theMap = this.parseString(this.chars.toString());
            }
            finally {
                this.chars.clear();
            }
        } else {
            throw new ParseException("Failed with CoderResult[%s]", new Object[]{coderResult});
        }
        return theMap;
    }

    private Map<String, Object> parseString(String inputString) {
        return this.parser.parse(inputString);
    }

    @Override
    public InputRow parse(String input) {
        return this.parseMap(this.parseString(input));
    }

    private InputRow parseMap(Map<String, Object> theMap) {
        return this.mapParser.parse(theMap);
    }
}

