/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.metamx.common.logger.Logger;
import com.metamx.common.parsers.ParseException;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.JSONParseSpec;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.SpatialDimensionSchema;
import io.druid.data.input.impl.TimestampSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class MapInputRowParser
implements InputRowParser<Map<String, Object>> {
    private static final Logger log = new Logger(MapInputRowParser.class);
    private final ParseSpec parseSpec;

    @JsonCreator
    public MapInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="dimensionExclusions") List<String> dimensionExclusions, @JsonProperty(value="spatialDimensions") List<SpatialDimensionSchema> spatialDimensions) {
        if (parseSpec == null) {
            if (dimensionExclusions == null) {
                dimensionExclusions = Lists.newArrayList();
            }
            if (timestampSpec != null) {
                dimensionExclusions.add(timestampSpec.getTimestampColumn());
            }
            this.parseSpec = new JSONParseSpec(timestampSpec, new DimensionsSpec(dimensions, dimensionExclusions, spatialDimensions));
        } else {
            this.parseSpec = parseSpec;
        }
    }

    @Override
    public InputRow parse(Map<String, Object> theMap) {
        DateTime timestamp;
        ArrayList dimensions = this.parseSpec.getDimensionsSpec().hasCustomDimensions() ? this.parseSpec.getDimensionsSpec().getDimensions() : Lists.newArrayList((Iterable)Sets.difference(theMap.keySet(), this.parseSpec.getDimensionsSpec().getDimensionExclusions()));
        try {
            timestamp = this.parseSpec.getTimestampSpec().extractTimestamp(theMap);
            if (timestamp == null) {
                String input = theMap.toString();
                throw new NullPointerException(String.format("Null timestamp in input: %s", input.length() < 100 ? input : input.substring(0, 100) + "..."));
            }
        }
        catch (Exception e) {
            throw new ParseException((Throwable)e, "Unparseable timestamp found!", new Object[0]);
        }
        return new MapBasedInputRow(timestamp.getMillis(), (List<String>)dimensions, theMap);
    }

    @Override
    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @Override
    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new MapInputRowParser(parseSpec, null, null, null, null);
    }
}

