/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.druid.data.input.impl.SpatialDimensionSchema;
import java.util.List;
import java.util.Set;

public class DimensionsSpec {
    private final List<String> dimensions;
    private final Set<String> dimensionExclusions;
    private final List<SpatialDimensionSchema> spatialDimensions;

    @JsonCreator
    public DimensionsSpec(@JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="dimensionExclusions") List<String> dimensionExclusions, @JsonProperty(value="spatialDimensions") List<SpatialDimensionSchema> spatialDimensions) {
        this.dimensions = dimensions == null ? Lists.newArrayList() : dimensions;
        this.dimensionExclusions = dimensionExclusions == null ? Sets.newHashSet() : Sets.newHashSet(dimensionExclusions);
        this.spatialDimensions = spatialDimensions == null ? Lists.newArrayList() : spatialDimensions;
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public Set<String> getDimensionExclusions() {
        return this.dimensionExclusions;
    }

    @JsonProperty
    public List<SpatialDimensionSchema> getSpatialDimensions() {
        return this.spatialDimensions;
    }

    public boolean hasCustomDimensions() {
        return this.dimensions != null && !this.dimensions.isEmpty();
    }

    public DimensionsSpec withDimensions(List<String> dims) {
        return new DimensionsSpec(dims, (List<String>)ImmutableList.copyOf(this.dimensionExclusions), this.spatialDimensions);
    }

    public DimensionsSpec withDimensionExclusions(Set<String> dimExs) {
        return new DimensionsSpec(this.dimensions, (List<String>)ImmutableList.copyOf(dimExs), this.spatialDimensions);
    }

    public DimensionsSpec withSpatialDimensions(List<SpatialDimensionSchema> spatials) {
        return new DimensionsSpec(this.dimensions, (List<String>)ImmutableList.copyOf(this.dimensionExclusions), spatials);
    }
}

