/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.metamx.common.parsers.DelimitedParser;
import com.metamx.common.parsers.Parser;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.TimestampSpec;
import java.util.List;

public class DelimitedParseSpec
extends ParseSpec {
    private final String delimiter;
    private final String listDelimiter;
    private final List<String> columns;

    @JsonCreator
    public DelimitedParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="listDelimiter") String listDelimiter, @JsonProperty(value="columns") List<String> columns) {
        super(timestampSpec, dimensionsSpec);
        this.delimiter = delimiter;
        this.listDelimiter = listDelimiter;
        this.columns = columns == null ? Lists.newArrayList() : columns;
        for (String column : this.columns) {
            Preconditions.checkArgument((!column.contains(",") ? 1 : 0) != 0, (String)"Column[%s] has a comma, it cannot", (Object[])new Object[]{column});
        }
    }

    @JsonProperty(value="delimiter")
    public String getDelimiter() {
        return this.delimiter;
    }

    @JsonProperty(value="columns")
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public void verify(List<String> usedCols) {
        for (String columnName : usedCols) {
            Preconditions.checkArgument((boolean)this.columns.contains(columnName), (String)"column[%s] not in columns.", (Object[])new Object[]{columnName});
        }
    }

    @Override
    public Parser<String, Object> makeParser() {
        DelimitedParser retVal = new DelimitedParser(Optional.fromNullable((Object)this.delimiter), Optional.fromNullable((Object)this.listDelimiter));
        retVal.setFieldNames(this.columns);
        return retVal;
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new DelimitedParseSpec(spec, this.getDimensionsSpec(), this.delimiter, this.listDelimiter, this.columns);
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new DelimitedParseSpec(this.getTimestampSpec(), spec, this.delimiter, this.listDelimiter, this.columns);
    }

    public ParseSpec withDelimiter(String delim) {
        return new DelimitedParseSpec(this.getTimestampSpec(), this.getDimensionsSpec(), delim, this.listDelimiter, this.columns);
    }

    public ParseSpec withListDelimiter(String delim) {
        return new DelimitedParseSpec(this.getTimestampSpec(), this.getDimensionsSpec(), this.delimiter, delim, this.columns);
    }

    public ParseSpec withColumns(List<String> cols) {
        return new DelimitedParseSpec(this.getTimestampSpec(), this.getDimensionsSpec(), this.delimiter, this.listDelimiter, cols);
    }
}

