/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.metamx.common.parsers.DelimitedParser;
import com.metamx.common.parsers.Parser;
import io.druid.data.input.impl.DataSpec;
import io.druid.data.input.impl.DelimitedParseSpec;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.SpatialDimensionSchema;
import io.druid.data.input.impl.TimestampSpec;
import java.util.List;

@Deprecated
public class DelimitedDataSpec
implements DataSpec {
    private final String delimiter;
    private final String listDelimiter;
    private final List<String> columns;
    private final List<String> dimensions;
    private final List<SpatialDimensionSchema> spatialDimensions;

    @JsonCreator
    public DelimitedDataSpec(@JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="listDelimiter") String listDelimiter, @JsonProperty(value="columns") List<String> columns, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="spatialDimensions") List<SpatialDimensionSchema> spatialDimensions) {
        this.delimiter = delimiter;
        this.listDelimiter = listDelimiter;
        Preconditions.checkNotNull(columns);
        for (String column : columns) {
            Preconditions.checkArgument((!column.contains(",") ? 1 : 0) != 0, (String)"Column[%s] has a comma, it cannot", (Object[])new Object[]{column});
        }
        this.columns = columns;
        this.dimensions = dimensions;
        this.spatialDimensions = spatialDimensions == null ? Lists.newArrayList() : spatialDimensions;
    }

    @JsonProperty
    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @JsonProperty(value="delimiter")
    public String getDelimiter() {
        return this.delimiter;
    }

    @JsonProperty(value="columns")
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    @JsonProperty(value="dimensions")
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @Override
    @JsonProperty(value="spatialDimensions")
    public List<SpatialDimensionSchema> getSpatialDimensions() {
        return this.spatialDimensions;
    }

    @Override
    public void verify(List<String> usedCols) {
        for (String columnName : usedCols) {
            Preconditions.checkArgument((boolean)this.columns.contains(columnName), (String)"column[%s] not in columns.", (Object[])new Object[]{columnName});
        }
    }

    @Override
    public boolean hasCustomDimensions() {
        return this.dimensions != null && !this.dimensions.isEmpty();
    }

    @Override
    public Parser<String, Object> getParser() {
        DelimitedParser retVal = new DelimitedParser(Optional.fromNullable((Object)this.delimiter), Optional.fromNullable((Object)this.listDelimiter));
        retVal.setFieldNames(this.columns);
        return retVal;
    }

    @Override
    public ParseSpec toParseSpec(TimestampSpec timestampSpec, List<String> dimensionExclusions) {
        return new DelimitedParseSpec(timestampSpec, new DimensionsSpec(this.dimensions, dimensionExclusions, this.spatialDimensions), this.delimiter, this.listDelimiter, this.columns);
    }
}

