/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.json;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.base.ProviderBase;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.cfg.MapperConfiguratorBase;
import com.fasterxml.jackson.jaxrs.json.JsonEndpointConfig;
import com.fasterxml.jackson.jaxrs.json.JsonMapperConfigurator;
import com.fasterxml.jackson.jaxrs.json.PackageVersion;
import java.lang.annotation.Annotation;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
public class JacksonJsonProvider
extends ProviderBase<JacksonJsonProvider, ObjectMapper, JsonEndpointConfig, JsonMapperConfigurator> {
    public static final String MIME_JAVASCRIPT = "application/javascript";
    public static final String MIME_JAVASCRIPT_MS = "application/x-javascript";
    public static final Annotations[] BASIC_ANNOTATIONS = new Annotations[]{Annotations.JACKSON};
    protected String _jsonpFunctionName;
    @Context
    protected Providers _providers;

    public JacksonJsonProvider() {
        this((ObjectMapper)null, BASIC_ANNOTATIONS);
    }

    public JacksonJsonProvider(Annotations ... annotationsArray) {
        this((ObjectMapper)null, annotationsArray);
    }

    public JacksonJsonProvider(ObjectMapper objectMapper) {
        this(objectMapper, BASIC_ANNOTATIONS);
    }

    public JacksonJsonProvider(ObjectMapper objectMapper, Annotations[] annotationsArray) {
        super((MapperConfiguratorBase)new JsonMapperConfigurator(objectMapper, annotationsArray));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public void setJSONPFunctionName(String string) {
        this._jsonpFunctionName = string;
    }

    @Deprecated
    protected boolean isJsonType(MediaType mediaType) {
        return this.hasMatchingMediaType(mediaType);
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String string = mediaType.getSubtype();
            return "json".equalsIgnoreCase(string) || string.endsWith("+json") || "javascript".equals(string) || "x-javascript".equals(string);
        }
        return true;
    }

    protected ObjectMapper _locateMapperViaProvider(Class<?> clazz, MediaType mediaType) {
        if (this._providers != null) {
            ContextResolver contextResolver = this._providers.getContextResolver(ObjectMapper.class, mediaType);
            if (contextResolver == null) {
                contextResolver = this._providers.getContextResolver(ObjectMapper.class, null);
            }
            if (contextResolver != null) {
                return (ObjectMapper)contextResolver.getContext(clazz);
            }
        }
        return null;
    }

    protected JsonEndpointConfig _configForReading(ObjectMapper objectMapper, Annotation[] annotationArray) {
        return JsonEndpointConfig.forReading(objectMapper, annotationArray);
    }

    protected JsonEndpointConfig _configForWriting(ObjectMapper objectMapper, Annotation[] annotationArray) {
        return JsonEndpointConfig.forWriting(objectMapper, annotationArray, this._jsonpFunctionName);
    }
}

