/*
 * Decompiled with CFR 0.152.
 */
package io.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.repackaged.com.google.common.base.Throwables;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.druid.data.input.InputRow;
import io.druid.data.input.Rows;
import io.druid.timeline.partition.NumberedShardSpec;
import io.druid.timeline.partition.ShardSpec;
import io.druid.timeline.partition.ShardSpecLookup;
import java.util.List;

public class HashBasedNumberedShardSpec
extends NumberedShardSpec {
    private static final HashFunction hashFunction = Hashing.murmur3_32();
    private final ObjectMapper jsonMapper;

    @JsonCreator
    public HashBasedNumberedShardSpec(@JsonProperty(value="partitionNum") int partitionNum, @JsonProperty(value="partitions") int partitions, @JacksonInject ObjectMapper jsonMapper) {
        super(partitionNum, partitions);
        this.jsonMapper = jsonMapper;
    }

    @Override
    public boolean isInChunk(InputRow inputRow) {
        return ((long)this.hash(inputRow) - (long)this.getPartitionNum()) % (long)this.getPartitions() == 0L;
    }

    protected int hash(InputRow inputRow) {
        List groupKey = Rows.toGroupKey((long)inputRow.getTimestampFromEpoch(), (InputRow)inputRow);
        try {
            return hashFunction.hashBytes(this.jsonMapper.writeValueAsBytes((Object)groupKey)).asInt();
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "HashBasedNumberedShardSpec{partitionNum=" + this.getPartitionNum() + ", partitions=" + this.getPartitions() + '}';
    }

    @Override
    public ShardSpecLookup getLookup(final List<ShardSpec> shardSpecs) {
        return new ShardSpecLookup(){

            public ShardSpec getShardSpec(InputRow row) {
                int index = Math.abs(HashBasedNumberedShardSpec.this.hash(row) % HashBasedNumberedShardSpec.this.getPartitions());
                return (ShardSpec)shardSpecs.get(index);
            }
        };
    }
}

