/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.sql;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.guava.CloseQuietly;
import io.druid.data.input.Row;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.Druids;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.sql.antlr4.DruidSQLLexer;
import io.druid.sql.antlr4.DruidSQLParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.joda.time.DateTime;

public class SQLRunner {
    private static final String STATEMENT = "select count(*), (1 - count(*) / sum(count)) * 100 as ratio from wikipedia where timestamp between '2013-02-01' and '2013-02-14' and (namespace = 'article' or page ~ 'Talk:.*') and language in ( 'en', 'fr' )  and user ~ '(?i)^david.*' group by granularity(timestamp, 'day'), language";

    public static void main(String[] args) throws Exception {
        TypeReference typeRef;
        TimeseriesQuery query;
        Options options = new Options();
        options.addOption("h", "help", false, "help");
        options.addOption("v", false, "verbose");
        options.addOption("e", "host", true, "endpoint [hostname:port]");
        CommandLine cmd = new GnuParser().parse(options, args);
        if (cmd.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("SQLRunner", options);
            System.exit(2);
        }
        String hostname = cmd.getOptionValue("e", "localhost:8080");
        String sql = cmd.getArgs().length > 0 ? cmd.getArgs()[0] : STATEMENT;
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        ObjectWriter jsonWriter = objectMapper.writerWithDefaultPrettyPrinter();
        ANTLRInputStream stream = new ANTLRInputStream(sql);
        DruidSQLLexer lexer = new DruidSQLLexer((CharStream)stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DruidSQLParser parser = new DruidSQLParser((TokenStream)tokenStream);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        parser.addErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        try {
            DruidSQLParser.QueryContext queryContext = parser.query();
            if (parser.getNumberOfSyntaxErrors() > 0) {
                throw new IllegalStateException();
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null) {
                System.err.println(e);
            }
            System.exit(1);
        }
        boolean groupBy = false;
        if (parser.groupByDimensions.isEmpty()) {
            query = Druids.newTimeseriesQueryBuilder().dataSource(parser.getDataSource()).aggregators(new ArrayList<AggregatorFactory>(parser.aggregators.values())).postAggregators(parser.postAggregators).intervals(parser.intervals).granularity(parser.granularity).filters(parser.filter).build();
            typeRef = new TypeReference<List<Result<TimeseriesResultValue>>>(){};
        } else {
            query = GroupByQuery.builder().setDataSource(parser.getDataSource()).setAggregatorSpecs(new ArrayList<AggregatorFactory>(parser.aggregators.values())).setPostAggregatorSpecs(parser.postAggregators).setInterval(parser.intervals).setGranularity(parser.granularity).setDimFilter(parser.filter).setDimensions(new ArrayList<DimensionSpec>(parser.groupByDimensions.values())).build();
            typeRef = new TypeReference<List<Row>>(){};
            groupBy = true;
        }
        String queryStr = jsonWriter.writeValueAsString((Object)query);
        if (cmd.hasOption("v")) {
            System.err.println(queryStr);
        }
        URL url = new URL(String.format("http://%s/druid/v2/?pretty", hostname));
        URLConnection urlConnection = url.openConnection();
        urlConnection.addRequestProperty("content-type", "application/json");
        urlConnection.getOutputStream().write(queryStr.getBytes(Charsets.UTF_8));
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        Object res = objectMapper.readValue((Reader)stdInput, typeRef);
        Joiner tabJoiner = Joiner.on((String)"\t");
        if (groupBy) {
            List rows = (List)res;
            Iterable dimensions = Iterables.transform(parser.groupByDimensions.values(), (Function)new Function<DimensionSpec, String>(){

                public String apply(@Nullable DimensionSpec input) {
                    return input.getOutputName();
                }
            });
            System.out.println(tabJoiner.join(Iterables.concat((Iterable)Lists.newArrayList((Object[])new String[]{"timestamp"}), (Iterable)dimensions, parser.fields)));
            for (final Row r : rows) {
                System.out.println(tabJoiner.join(Iterables.concat((Iterable)Lists.newArrayList((Object[])new DateTime[]{parser.granularity.toDateTime(r.getTimestampFromEpoch())}), (Iterable)Iterables.transform(parser.groupByDimensions.values(), (Function)new Function<DimensionSpec, String>(){

                    public String apply(@Nullable DimensionSpec input) {
                        return Joiner.on((String)",").join((Iterable)r.getDimension(input.getOutputName()));
                    }
                }), (Iterable)Iterables.transform(parser.fields, (Function)new Function<String, Object>(){

                    public Object apply(@Nullable String input) {
                        return Float.valueOf(r.getFloatMetric(input));
                    }
                }))));
            }
        } else {
            List rows = (List)res;
            System.out.println(tabJoiner.join(Iterables.concat((Iterable)Lists.newArrayList((Object[])new String[]{"timestamp"}), parser.fields)));
            for (final Result r : rows) {
                System.out.println(tabJoiner.join(Iterables.concat((Iterable)Lists.newArrayList((Object[])new DateTime[]{r.getTimestamp()}), (Iterable)Lists.transform(parser.fields, (Function)new Function<String, Object>(){

                    public Object apply(@Nullable String input) {
                        return ((TimeseriesResultValue)r.getValue()).getMetric(input);
                    }
                }))));
            }
        }
        CloseQuietly.close((Closeable)stdInput);
    }
}

