/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.router;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.metamx.common.Pair;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.selector.HostSelector;
import io.druid.curator.discovery.ServerDiscoveryFactory;
import io.druid.curator.discovery.ServerDiscoverySelector;
import io.druid.query.Query;
import io.druid.server.coordinator.rules.LoadRule;
import io.druid.server.coordinator.rules.Rule;
import io.druid.server.router.CoordinatorRuleManager;
import io.druid.server.router.TieredBrokerConfig;
import io.druid.server.router.TieredBrokerSelectorStrategy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class TieredBrokerHostSelector<T>
implements HostSelector<T> {
    private static EmittingLogger log = new EmittingLogger(TieredBrokerHostSelector.class);
    private final CoordinatorRuleManager ruleManager;
    private final TieredBrokerConfig tierConfig;
    private final ServerDiscoveryFactory serverDiscoveryFactory;
    private final ConcurrentHashMap<String, ServerDiscoverySelector> selectorMap = new ConcurrentHashMap();
    private final List<TieredBrokerSelectorStrategy> strategies;
    private final Object lock = new Object();
    private volatile boolean started = false;

    @Inject
    public TieredBrokerHostSelector(CoordinatorRuleManager ruleManager, TieredBrokerConfig tierConfig, ServerDiscoveryFactory serverDiscoveryFactory, List<TieredBrokerSelectorStrategy> strategies) {
        this.ruleManager = ruleManager;
        this.tierConfig = tierConfig;
        this.serverDiscoveryFactory = serverDiscoveryFactory;
        this.strategies = strategies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            try {
                for (Map.Entry<String, String> entry : this.tierConfig.getTierToBrokerMap().entrySet()) {
                    ServerDiscoverySelector selector = this.serverDiscoveryFactory.createSelector(entry.getValue());
                    selector.start();
                    this.selectorMap.put(entry.getValue(), selector);
                }
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            try {
                for (ServerDiscoverySelector selector : this.selectorMap.values()) {
                    selector.stop();
                }
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            this.started = false;
        }
    }

    @Override
    public String getDefaultServiceName() {
        return this.tierConfig.getDefaultBrokerServiceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<String, ServerDiscoverySelector> select(Query<T> query) {
        ServerDiscoverySelector retVal;
        Object object = this.lock;
        synchronized (object) {
            if (!this.ruleManager.isStarted() || !this.started) {
                return this.getDefaultLookup();
            }
        }
        String brokerServiceName = null;
        for (TieredBrokerSelectorStrategy strategy : this.strategies) {
            Optional<String> optionalName = strategy.getBrokerServiceName(this.tierConfig, query);
            if (!optionalName.isPresent()) continue;
            brokerServiceName = (String)optionalName.get();
            break;
        }
        if (brokerServiceName == null) {
            List<Rule> rules = this.ruleManager.getRulesWithDefault((String)Iterables.getFirst((Iterable)query.getDataSource().getNames(), null));
            DateTime now = new DateTime();
            int lastRulePosition = -1;
            LoadRule baseRule = null;
            block4: for (Interval interval : query.getIntervals()) {
                int currRulePosition = 0;
                for (Rule rule : rules) {
                    if (rule instanceof LoadRule && currRulePosition > lastRulePosition && rule.appliesTo(interval, now)) {
                        lastRulePosition = currRulePosition;
                        baseRule = (LoadRule)rule;
                        continue block4;
                    }
                    ++currRulePosition;
                }
            }
            if (baseRule == null) {
                return this.getDefaultLookup();
            }
            for (Map.Entry entry : this.tierConfig.getTierToBrokerMap().entrySet()) {
                if (!baseRule.getTieredReplicants().containsKey(entry.getKey())) continue;
                brokerServiceName = (String)entry.getValue();
                break;
            }
        }
        if (brokerServiceName == null) {
            log.error("WTF?! No brokerServiceName found for datasource[%s], intervals[%s]. Using default[%s].", new Object[]{query.getDataSource(), query.getIntervals(), this.tierConfig.getDefaultBrokerServiceName()});
            brokerServiceName = this.tierConfig.getDefaultBrokerServiceName();
        }
        if ((retVal = this.selectorMap.get(brokerServiceName)) == null) {
            log.error("WTF?! No selector found for brokerServiceName[%s]. Using default selector for[%s]", new Object[]{brokerServiceName, this.tierConfig.getDefaultBrokerServiceName()});
            retVal = this.selectorMap.get(this.tierConfig.getDefaultBrokerServiceName());
        }
        return new Pair((Object)brokerServiceName, (Object)retVal);
    }

    public Pair<String, ServerDiscoverySelector> getDefaultLookup() {
        String brokerServiceName = this.tierConfig.getDefaultBrokerServiceName();
        ServerDiscoverySelector retVal = this.selectorMap.get(brokerServiceName);
        return new Pair((Object)brokerServiceName, (Object)retVal);
    }
}

