/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.router;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.server.router.PriorityTieredBrokerSelectorStrategy;
import io.druid.server.router.TieredBrokerSelectorStrategy;
import io.druid.server.router.TimeBoundaryTieredBrokerSelectorStrategy;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.joda.time.Period;

public class TieredBrokerConfig {
    @JsonProperty
    @NotNull
    private String defaultBrokerServiceName = "";
    @JsonProperty
    private LinkedHashMap<String, String> tierToBrokerMap;
    @JsonProperty
    @NotNull
    private String defaultRule = "_default";
    @JsonProperty
    @NotNull
    private String rulesEndpoint = "/druid/coordinator/v1/rules";
    @JsonProperty
    @NotNull
    private String coordinatorServiceName = null;
    @JsonProperty
    @NotNull
    private Period pollPeriod = new Period((Object)"PT1M");
    @JsonProperty
    @NotNull
    private List<TieredBrokerSelectorStrategy> strategies = Arrays.asList(new TimeBoundaryTieredBrokerSelectorStrategy(), new PriorityTieredBrokerSelectorStrategy(0, 1));

    public LinkedHashMap<String, String> getTierToBrokerMap() {
        return this.tierToBrokerMap == null ? new LinkedHashMap<String, String>((Map<String, String>)ImmutableMap.of((Object)"_default_tier", (Object)this.defaultBrokerServiceName)) : this.tierToBrokerMap;
    }

    public String getDefaultBrokerServiceName() {
        return this.defaultBrokerServiceName;
    }

    public String getDefaultRule() {
        return this.defaultRule;
    }

    public String getRulesEndpoint() {
        return this.rulesEndpoint;
    }

    public String getCoordinatorServiceName() {
        return this.coordinatorServiceName;
    }

    public Period getPollPeriod() {
        return this.pollPeriod;
    }

    public List<TieredBrokerSelectorStrategy> getStrategies() {
        return ImmutableList.copyOf(this.strategies);
    }
}

