/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.metrics;

import com.google.inject.Inject;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.AbstractMonitor;
import io.druid.client.DruidServerConfig;
import io.druid.server.coordination.ServerManager;
import java.util.Map;

public class ServerMonitor
extends AbstractMonitor {
    private final DruidServerConfig serverConfig;
    private final ServerManager serverManager;

    @Inject
    public ServerMonitor(DruidServerConfig serverConfig, ServerManager serverManager) {
        this.serverConfig = serverConfig;
        this.serverManager = serverManager;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder;
        String dataSource;
        emitter.emit(new ServiceMetricEvent.Builder().build("server/segment/max", (Number)this.serverConfig.getMaxSize()));
        long totalUsed = 0L;
        long totalCount = 0L;
        for (Map.Entry<String, Long> entry : this.serverManager.getDataSourceSizes().entrySet()) {
            dataSource = entry.getKey();
            long used = entry.getValue();
            totalUsed += used;
            builder = new ServiceMetricEvent.Builder().setUser1(dataSource).setUser2(this.serverConfig.getTier());
            emitter.emit(builder.build("server/segment/used", (Number)used));
            double usedPercent = this.serverConfig.getMaxSize() == 0L ? 0.0 : (double)used / (double)this.serverConfig.getMaxSize();
            emitter.emit(builder.build("server/segment/usedPercent", (Number)usedPercent));
        }
        for (Map.Entry<String, Long> entry : this.serverManager.getDataSourceCounts().entrySet()) {
            dataSource = entry.getKey();
            long count = entry.getValue();
            totalCount += count;
            builder = new ServiceMetricEvent.Builder().setUser1(dataSource).setUser2(this.serverConfig.getTier());
            emitter.emit(builder.build("server/segment/count", (Number)count));
        }
        ServiceMetricEvent.Builder builder2 = new ServiceMetricEvent.Builder().setUser2(this.serverConfig.getTier());
        emitter.emit(builder2.build("server/segment/totalUsed", (Number)totalUsed));
        double totalUsedPercent = this.serverConfig.getMaxSize() == 0L ? 0.0 : (double)totalUsed / (double)this.serverConfig.getMaxSize();
        emitter.emit(builder2.build("server/segment/totalUsedPercent", (Number)totalUsedPercent));
        emitter.emit(builder2.build("server/segment/totalCount", (Number)totalCount));
        return true;
    }
}

