/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import io.druid.server.RequestLogLine;
import io.druid.server.log.RequestLogger;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.MutableDateTime;

public class FileRequestLogger
implements RequestLogger {
    private final ObjectMapper objectMapper;
    private final ScheduledExecutorService exec;
    private final File baseDir;
    private final Object lock = new Object();
    private volatile DateTime currentDay;
    private volatile FileWriter fileWriter;

    public FileRequestLogger(ObjectMapper objectMapper, ScheduledExecutorService exec, File baseDir) {
        this.exec = exec;
        this.objectMapper = objectMapper;
        this.baseDir = baseDir;
    }

    @LifecycleStart
    public void start() {
        try {
            this.baseDir.mkdirs();
            MutableDateTime mutableDateTime = new DateTime().toMutableDateTime();
            mutableDateTime.setMillisOfDay(0);
            this.currentDay = mutableDateTime.toDateTime();
            this.fileWriter = new FileWriter(new File(this.baseDir, this.currentDay.toString("yyyy-MM-dd'.log'")), true);
            long nextDay = this.currentDay.plusDays(1).getMillis();
            Duration delay = new Duration(nextDay - new DateTime().getMillis());
            ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)delay, (Duration)Duration.standardDays((long)1L), (Callable)new Callable<ScheduledExecutors.Signal>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ScheduledExecutors.Signal call() {
                    FileRequestLogger.this.currentDay = FileRequestLogger.this.currentDay.plusDays(1);
                    try {
                        Object object = FileRequestLogger.this.lock;
                        synchronized (object) {
                            CloseQuietly.close((Closeable)FileRequestLogger.this.fileWriter);
                            FileRequestLogger.this.fileWriter = new FileWriter(new File(FileRequestLogger.this.baseDir, FileRequestLogger.this.currentDay.toString()), true);
                        }
                    }
                    catch (Exception e) {
                        Throwables.propagate((Throwable)e);
                    }
                    return ScheduledExecutors.Signal.REPEAT;
                }
            });
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            CloseQuietly.close((Closeable)this.fileWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(RequestLogLine requestLogLine) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.fileWriter.write(String.format("%s%n", requestLogLine.getLine(this.objectMapper)));
            this.fileWriter.flush();
        }
    }
}

