/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.initialization;

import org.apache.curator.utils.ZKPaths;
import org.skife.config.Config;

public abstract class ZkPathsConfig {
    @Config(value={"druid.zk.paths.base"})
    public String getZkBasePath() {
        return "druid";
    }

    @Config(value={"druid.zk.paths.propertiesPath"})
    public String getPropertiesPath() {
        return this.defaultPath("properties");
    }

    @Config(value={"druid.zk.paths.announcementsPath"})
    public String getAnnouncementsPath() {
        return this.defaultPath("announcements");
    }

    @Config(value={"druid.zk.paths.servedSegmentsPath"})
    public String getServedSegmentsPath() {
        return this.defaultPath("servedSegments");
    }

    @Config(value={"druid.zk.paths.liveSegmentsPath"})
    public String getLiveSegmentsPath() {
        return this.defaultPath("segments");
    }

    @Config(value={"druid.zk.paths.loadQueuePath"})
    public String getLoadQueuePath() {
        return this.defaultPath("loadQueue");
    }

    @Config(value={"druid.zk.paths.coordinatorPath"})
    public String getCoordinatorPath() {
        return this.defaultPath("coordinator");
    }

    @Config(value={"druid.zk.paths.connectorPath"})
    public String getConnectorPath() {
        return this.defaultPath("connector");
    }

    @Config(value={"druid.zk.paths.indexer.announcementsPath"})
    public String getIndexerAnnouncementPath() {
        return this.defaultPath("indexer/announcements");
    }

    @Config(value={"druid.zk.paths.indexer.tasksPath"})
    public String getIndexerTaskPath() {
        return this.defaultPath("indexer/tasks");
    }

    @Config(value={"druid.zk.paths.indexer.statusPath"})
    public String getIndexerStatusPath() {
        return this.defaultPath("indexer/status");
    }

    @Config(value={"druid.zk.paths.indexer.leaderLatchPath"})
    public String getIndexerLeaderLatchPath() {
        return this.defaultPath("indexer/leaderLatchPath");
    }

    private String defaultPath(String subPath) {
        return ZKPaths.makePath((String)this.getZkBasePath(), (String)subPath);
    }
}

